/* PRECC library
 *
 *This file contains functions which precc requires to build ITSELF and
 *cannot be generated from the precc code in precc*.y (except as drop
 *through inclusions).
 *
 *These routines should not be required for other compilations
 *(the cc.c routines in the kernel suffice).
 *
 */

# include <stdio.h>
# include "preccx.h"
# include "preamble.h"

/* these sizes are pre-empted by startup switches */
int cbuffsize =  CBUFFSIZE;
int nbuffsize =  NBUFFSIZE;

# undef UNSETNAME


/* startup functions */
void usage(PRECC_DATA * self, int n)
{

    switch (n){
    case 1: fprintf(stderr,"mixed swiches and files\n");
            break;
    case 2: fprintf(stderr,"error opening %s for writing\n",p_outfile);
            break;
    case 3: fprintf(stderr,"unknown option\n");
            break;
    case 4: fprintf(stderr,"bad numerical option\n");
            break;
    case 5: fprintf(stderr,"error opening %s for reading\n",p_infile);
            break;
    }

    fprintf(stderr,"usage %s [options] [infile [outfile]]\n",p_argv[0]);
    fprintf(stderr,"options : -r<read buffer size in kb>      (%d)\n",
      (int)(self->readbuffersize*(sizeof (TOKEN) + sizeof (VALUE))/1024));
    fprintf(stderr,"          -p<program buffer size in kb>   (%d)\n",
      (int)(self->maxprogramsize*sizeof(P_INSTRUCTION)/1024)); 
    fprintf(stderr,"          -v<attribute buffer size in kb> (%d)\n",
      (int)(self->stacksize*sizeof(P_STACKVALUE)/1024));
    fprintf(stderr,"          -f<context buffer size in kb>   (%d)\n",
      (int)(self->contextstacksize*sizeof(P_FRAME)/1024));
    fprintf(stderr,"          -c<stuff buffer size in kb>     (%d)\n",
      (int)(cbuffsize*sizeof(char)/1024));
    fprintf(stderr,"          -n<name buffer size in kb>      (%d)\n",
      (int)(nbuffsize*sizeof(char)/1024));
    fprintf(stderr,"          -old                       (not set)\n");
    (void) p_exit (n);
}

int getkintarg(PRECC_DATA * self,char *s,int *t,size_t n)
/* read a number in kbytes and translate it to calloc units */
{
    if (1 != sscanf(s,"%u",t))
        usage(self,4);
    *t *= 1000; /* kbytes */
    *t /= n;    /* the unit size */
    return 0;
}


/* agents are buffers, safe places to put characters to be able to refer back to
   them later. One can 

   Concatenate a word to a buffer
   and close off the slot:            nputagent(A,word);getagent(A,&place)

   Concatenate a char to a buffer
   and close off the slot:          putagent(A,char);getagent(A,&place)

   Initialize the buffer:           initagent(A,buffer)

   Reset the buffer, old data is
   now unsafe:                      resetagent(A)
*/

/* we are now going to make all these buffers in p_create_intern_data() */

CHARS cbuff;                              /* read buffer [CBUFFSIZE] */
AGENT chars;/*{cbuff,cbuff,cbuff,cbuff}*/ /* read agent */
CHARS nbuff;                              /* name buffer [NBUFFSIZE] */
AGENT namE ;/*{nbuff,nbuff,nbuff,nbuff}*/ /* name agent */
static CHARS abuff;                       /* args buffer [NBUFFSIZE] */
AGENT args ;/*{abuff,abuff,abuff,abuff}*/ /* args agent */
static CHARS kbuff;                       /* keys buffer [NBUFFSIZE] */
AGENT keys ;/*{kbuff,kbuff,kbuff,kbuff}*/ /* keys agent */
static CHARS mbuff;                       /* keys buffer [NBUFFSIZE] */
AGENT meta ;/*{mbuff,mbuff,mbuff,mbuff}*/ /* meta agent */

VOID  p_creat_intern_data ()
    /* now make the agent buffers */
{
    long bytesfree;
    /* char * p_calloc (); */ /* gcc stlib.h and sunOS acc disagree on type */

    bytesfree = p_memleft();

    cbuff = (CHAR *) p_calloc(cbuffsize, sizeof(CHAR));
    nbuff = (CHAR *) p_calloc(nbuffsize, sizeof(CHAR));
    abuff = (CHAR *) p_calloc(nbuffsize, sizeof(CHAR));
    kbuff = (CHAR *) p_calloc(nbuffsize, sizeof(CHAR));
    mbuff = (CHAR *) p_calloc(nbuffsize, sizeof(CHAR));

    if (cbuff == NULL || nbuff == NULL || abuff == NULL ||
        kbuff == NULL || mbuff == NULL)
    {
        fprintf (stderr,
        "error; not enough memory (%lu) for internal buffers\n", bytesfree);
        (void) p_exit (1);
    }
    initagent(&chars,cbuff,cbuffsize);
    initagent(&namE ,nbuff,nbuffsize);
    initagent(&args ,abuff,nbuffsize);
    initagent(&keys ,kbuff,nbuffsize);
    initagent(&meta ,mbuff,nbuffsize);
}

VOID p_destr_intern_data ()
{
    /* int p_free(); */  /* gcc stdlib.h and sunOS acc disagree on type*/

    (void) p_free(cbuff);
    (void) p_free(nbuff);
    (void) p_free(abuff);
    (void) p_free(kbuff);
    (void) p_free(mbuff);
}

void resetall ()
{
  CHARS resetagent(AGENT*);

  resetagent(&chars);
  resetagent(&namE);
  resetagent(&args);
  resetagent(&meta);
  resetagent(&keys);
}

void stufferror (AGENT *x)
{
    /* void p_exit(); */ /* not sure if exit is always void across OSs */

    if(x->buffer == cbuff)
    {
      fprintf(stderr,
      "A stuff buffer has overflowed. Rerun using a \"-c%d\" option.\n",
      2*(cbuffsize/1024));
    } else
    {
      fprintf(stderr,
      "A name buffer has overflowed. Rerun using a \"-n%d\" option.\n",
      2*(nbuffsize/1024));
    }

    (void) p_exit(2);
}

/* methods on agents */
VOID initagent(AGENT *x,CHARS y,int n){
x->buffer=y;
x->in=y;
x->out=y;
x->limit=y+n;
*y=0;
}

CHARS putagent(AGENT *x,char y){
*x->in++=y;                /* move the in pointer on one place */
if (x->in >= x->limit)
    stufferror(x);
*x->in=0;
return(x->in-1);
}

CHARS nputagent(AGENT *x,CHARS y){
*(x->in= p_scpy(x->in,y))=0;
if (x->in >= x->limit)
    stufferror(x);
return(x->out);            /* the current out-pointer is returned */
}                          /* which points to the start of the current word */

CHARS getagent(AGENT *x,CHARS *y){
*x->in++=0;                /* finish the current in word */
*y=x->out;                 /* report the out pointer */
*x->in=0;                  /* zero next word */
return(x->out=x->in);      /* set the out pointer to next incoming word */
}

CHARS resetagent(AGENT *x){
*x->buffer=0;              /* zero first word */
return(x->out=x->in=x->buffer);
}

/* in particular */

CHARS myputchar(int c){
return(putagent(&chars,(char)c));
}

CHARS getname(CHARS *x){
return(getagent(&chars,x));
}

CHARS putname(CHARS x){
return(nputagent(&chars,(x)));
}

CHARS putint(int x){
static char shortbuf[32];
sprintf(shortbuf,"%d",x);
return(putname(shortbuf));
}

CHARS putargs(CHARS x){
return(nputagent(&args,x));
}

CHARS getargs(CHARS *x){
return(getagent(&args,x));
}

CHARS putmeta(CHARS x){
return(nputagent(&meta,x));
}

CHARS getmeta(CHARS *x){
return(getagent(&meta,x));
}


CHARS putkeys(CHARS x){
return(nputagent(&keys,x));
}

CHARS getkeys(CHARS *x){
return(getagent(&keys,x));
}



/* end of methods on agents */


# include <ctype.h>
 

        /* these are here to do char-int argument conversions */

P_BEGIN
BOOLEAN p_isalpha(char c)
{
        return(isalpha((int)c) || (c=='_'));
}
 
BOOLEAN p_isdigit(char c)
{
        return(isdigit((int)c));
}

BOOLEAN p_ishexdig(char c)
{
        return(isxdigit((int)c));
}

BOOLEAN p_isoctdig(char c)
{
        return(isdigit((int)c) && c < '8');
}

BOOLEAN p_isspace(char c)
{       /* '\b' rendered by yylex for newline in the middle of a line seq */
        return(c==' ' || c=='\t' || c=='\b');
}

BOOLEAN p_isalnum(char c)
{
        return(isalnum((int)c) || (c=='_'));
}
P_END

        /* this returns the address of the LAST char copied */
 
char *p_scpy(char *x,char *y)
{
        while((*x++ = *y++) != 0);
        return(&x[-1]);
}

int precc_yytchar;
int precc_yylen;
CHARS precc_yylloc; /* this is the address of the LAST token
               * I returned from the readahead buffer, if it's not NULL,
               * which means the buffer is empty. */
int  precc_yylineno;/* I need to supply this for precc */
VALUE precc_yylval; /* ditto */

int precc_yywrap()
/* makes us repeat parse attempts */
{
    return 1;
}
 
#if 0  /* define to stress test the yylex buffering behaviour */
# define YYREADBUFFERSIZE 2
#endif

# ifndef YYREADBUFFERSIZE
# define YYREADBUFFERSIZE READBUFFERSIZE
# endif

/* this lexer is fragile wrt long input lines. Keep 'em under 2k */

int precc_yylex()
/*
 * Read ahead lines into yybuffer until EOL,
 * but ignore escaped End-Of-Lines (either escaped by
 * trailing `\' or by `@' at beginning of next line after this line began
 * with one.
 *
 * Dole out characters one at a time.
 *
 * Return 0!=TOKEN for a good read and 0=FAILURE when an EOF is encountered.
 */
{         

    int n;
    static char  yybuffer[YYREADBUFFERSIZE];  /* virtual line buffer   */
    CHARS buff = &yybuffer[0];
    static int atsignalled, linecount;
    static char c; extern int precc_yytchar; extern int precc_yylen;
    static int nbuff;

         /* gets returns nonzero EITHER if given ^^Z OR on the next
            call after a ^foo^Z - which is all OK for nonzero=EOF
          */

    if(NULL!=precc_yylloc) {

        if (nbuff>0) {/* we can use a token we read ahead for */
            precc_yylen=1;
            nbuff--;
            return(precc_yytchar=(int)(precc_yylval=(VALUE)(int) *++precc_yylloc));
        }

         /* otherwise we ask for more TOKENS next time and return the EOL
            (0) now and it'll be used to terminate a string. */

        precc_yylloc=(char*)NULL;
        precc_yylen=0;    
        nbuff=0;
        return (precc_yytchar=(int)(precc_yylval=(VALUE)0));
        
    }


    /*if(NULL==precc_yylloc){*/   /* we have to load the readahead buff  */
    
        precc_yylloc=buff-1;      /* we will return a token at *buff ... */
        *buff=precc_yytchar=0;    /* ... but we start clean              */
        nbuff=0;            /* length of readahead buffer          */
        atsignalled=0;      /* we're not in an @ sequence yet      */
        linecount=0;        /* we've read no sequence of lines yet */

        /* and carry on */

    
        /* we're here because the readahead buffer was empty and so
           the initialization conditions hold: precc_yylloc=buff-1, etc. */

        while (gets((char*)buff)!=NULL) { 

          precc_yylineno++;
          linecount++;

          n = (int)strlen((char*)buff);  /* count the booty */
          nbuff+=n;         /* keep count of the buffer contents */

          if (n==0) {       /* we got a linefeed only  and it's time to start
                             * feeding out stuff from the buffer */
            
          if (nbuff>0){
                 precc_yylen=1;
                 nbuff--;
                 return(precc_yytchar=(int)(precc_yylval=(VALUE)(int) *++precc_yylloc));
          }
                
                             /* here we've got no tokens, now or before */
          precc_yylen=0;        
          precc_yylloc=(char*)NULL;/* signal to read ahead again next time round */
          return (precc_yytchar=(int)(precc_yylval=(VALUE)0));   /* return the 0 string
                              * terminator */
        }


        /* we're here with nbuff>0 already, and with n>0 */

                             /* check to see if this is an @ seq start */

        if ((linecount==1) && (*buff=='@'))
          atsignalled=1;

                             /* if it is, allow escaped linefeeds */

        if (atsignalled && (buff[n-1]=='\\')){
                             /* escaped newline, so .. 
                              * .. chop off the escape and .. */
          buff += --n;       /* .. we go round again */

          nbuff--;           /* we knock off one from our buffer count */
          continue;
        }

        if (!atsignalled) {
                              /* ordinary token return. just ... 
                               * ... crank our buffer */
            nbuff--;          /* remember that nbuff>0 so this is OK */
            precc_yylen=0;

            return (precc_yytchar=(int)(precc_yylval=(VALUE)(int) *++precc_yylloc));

         }

              /* we're here because we're in an @ sequence without an
                 escaped linefeed */

          switch (c=getchar()){
            default:          /* we peeked at the next line ... */
                              /* and it didn't start with @, so ... */
              ungetc((int)c,stdin);
                              /* we finished the readahead, and ... */
                              /* can start unloading tokens */
              nbuff--;        /* remember that nbuff>0 so this is OK */
              precc_yylen=1;

              return (precc_yytchar=(int)(precc_yylval=(VALUE)(int) *++precc_yylloc));        

            case '@':          /* or it did start @, so eat the '@' --
                                * now it won't be seen next time */
              ungetc((int)'\b',stdin); /* NEW! ... */
                               /* replace the @ by a formfeed */
              buff += n;
              continue;   /* and go round again */
          }

        } /* endwhile*/

        /*  we're here because gets() failed */

        precc_yytchar=EOF;                          /*  EOF encountered */
                              /* doesn't have to be precc_yytchar = (TOKEN)EOF
                               * because we know everything is int  at
                               * this level - it's a special precc_yylex */

        precc_yylloc=(char*)NULL;/* signal that readahead buffer is empty */
        precc_yylen=0;
        return ((int)(precc_yylval=(VALUE)0));
}

CHARS GNAME(CHARS x)
/*
        Return "f" from "f(a,b,c)". Return "f" from "f".
        The returned pointer is safe until  UNSETNAME.
*/
{
        static char *a;
        getname(&a);        /* finish off last name */
        a=strchr(x,'(');
        if (a) {
                *a = 0;
                putname(x);
                *a = '(';
                }
        else
                putname(x);
        getname(&x);
        return(x);
}


CHARS findbrkt(char a, CHARS x, char b, char s, int *nargs, CHARS xx, int *nargx)
/*
if *x is '(' then find the matching ')' and return its address.
If there is no match, return NULL. If *x is not '(', find the
closing bracket which matches the first open bracket encountered.

I think this should return NULL if there is no opening bracket, but
I am not sure that it does.

Also count the 1st level true separators s encountered in nargs.
*/
/* *nargx           = no. of VALUE-type args (look in xx) */
{
        register char c;
        static int n;               /* the level count */
        static CHARS arg;           /* each argument (between separators) */
        extern int pis_in(CHARS,CHARS);

        n=0;                        /* zero the level count */
        arg=x;

    /* zero the item count */
    if(nargs) *nargs=0;
    if(nargx) *nargx=0;

        while(0!=(c=*x++)){
                if(c=='"') {       /* get to the end of the string */
                        while(0!=(c=*x++)) {
                                if(c=='\\') {
                                    if(0!=(c=*x++))
                                        continue;
                                    else
                                        return --x; /* with prejudice */
                                }
                                if(c=='"')
                                        break;
                                /* else keep looking */
                        }
                        /* now x is one beyond the end of the string */
                        continue;  /* now look for a comma */
                }
                else if(c=='\'') {
                        while(0!=(c=*x++)) {
                                if(c=='\\') {
                                     if(0!=(c=*x++))
                                          continue;
                                     else
                                        return --x; /* with prejudice */
                                }
                                if(c=='\'')
                                        break;
                                /* else keep looking */
                        }
                        /* now x is one beyond the end of the quote */
                        continue;
                }
                else if (c==a) {
                        /* found an open bracket */
                        n++;
                        /* now x is at the start of an arg */
                        arg  = x;
                        continue;
                 }
                else if(c==b) {
                        /* found a close bracket */
                        if(--n<0) { /* decrement the bracket count */
                        /* if(n==0) { * we should be at the final bracket */
                            x[-1] = 0;
                            if (pis_in(arg,xx)==1)
                                if(nargx) (*nargx)++;
                            x[-1] = c;
                            /* reset the arg pointer */
                            arg  = x;
                            return --x;    /* too many! bad news? Or OK? */
                        }
                        /* go round again - why no "continue" ? */
                }
                else if(c==s) {
                        /* found a separator */
                        if(n==0) {
                        /* increment the item count */
                             if(nargs) (*nargs)++;
                             /* now x is one beyond the separator */
                             x[-1] = 0;
                             if (pis_in(arg,xx)==1)
                                 if(nargx) (*nargx)++;
                             x[-1] = c;
                             /* reset the arg pointer */
                             arg  = x;
                        }
                        continue;
                }
                                 
        }

        return (CHARS)NULL;
}

BOOLEAN ISEMPTY(CHARS x){
    /* a string consists of only whitespace chars */
    static CHARS a; int n;

    getname(&a);                /* finish off the last word */
    n = strspn(x," \t\b\n\r");
    if (x[n]) { /* nonwhitespace */
       return 0;   
    }
    return 1;
}

CHARS GARGS(CHARS x)
/*
        Return "a,b,c" from "f(a,b,c)". Return "" from "f".
        The returned pointer is safe until  UNSETNAME.
*/
{
        static CHARS a, b; static int nargs, nargx;

        getname(&a);                /* finish off the last word */
        a=strchr(x,'(');
        if (a) {
                b = findbrkt('(',++a,')',',',&nargs,"",&nargx);
                if (b)  {
                        *b=0;
                        putname(a);
                        *b = ')';
                        }
                /* else
                        putname(a); */
                }
        getname(&x);
        return(x);
}

CHARS CATFUNCARGS(CHARS x, CHARS xx)
/*
        Turn "f(a,b,c,d)" into "f,4,a,b,c,d". Turn "f" into "f,0".
        The returned pointer is safe until  UNSETNAME.

        "xx" should enable us to modify the count to cope with larger
        sized parameters. It ought to be an excess, perhaps determined
        by counting the number of "VALUE" tagged entries (as opposed to
        the number of "PARAM" tags) in the "metaenv" list. or
        perhaps counted directly by "count".
*/
{
        static CHARS brkt1, brkt2, arg1; static int nargs, nargx;
        static char numbuff[32];

        brkt1=(CHARS)strchr(x,'(');
        if ((int)brkt1!=(int)NULL) {
                *brkt1=0;
                putname(x);  /* write the function name */
                *brkt1='(';
                            

        /* this is where we want to find the corresponding ')'.
           We are sure that we start at a '(', so we can't
           get b=a back again. */

        arg1=brkt1;
        while(0!=*++arg1)
             if((*arg1!=' ')||(*arg1!='\t')) break; 
                brkt2 = findbrkt('(',arg1,')',',',&nargs,xx,&nargx);
                
                if ((int)brkt2!=(int)NULL)  {/* there is a 2nd bracket */
                        *brkt2=0;
                        if((int)brkt2!=(int)arg1){
                                         /* & it wasn't an empty one */
                                putname(",");
                                /* write the number of args */
                                sprintf(numbuff,P_FRSZ,nargs+1,nargx); /* (int)%d maybe? */
                                putname(numbuff);
                                putname(",");
                                /* write the args */
                                putname(arg1);
                        }
                        else                     /* it was empty */
                                putname(",0");       /* (int)0 maybe? */
                        *brkt2 = ')';
            
                }
                else                  /* no second bracket!! IMPOSSIBLE */
                            /*putname(brkt1);*/
                putname(",0");       /* (int)0 maybe? */
        }

        else    {            /* there are no args */
                putname(x);
                putname(",0");      /* (int)0 maybe? */
        }

        getname(&x);
        return(x);
}

CHARS UNSETNAME(CHARS x)
/* identity action on x with side-effect of resetting agents */
{
        /*CHARS resetagent();

        resetall();*/
        return(x);
}

VOID GETANAME(CHARS *n, CHARS x, CHARS z, int nid)
/* use list z for vars and write "x<nid>(var1,...,vark)" in n */
{
        static CHARS y;
        static char mybuff[SMALLBUFFERSIZE];

        sprintf(&mybuff[0],"%s%d",x,nid);
        y = putname((CHARS)&mybuff[0]); /* y is the beginning of the cache */

        putname((CHARS)"(");
        y+=strlen(y);                 /* now we're where the args start */
        putname(z);

        putname((CHARS)")");
        getname(n);
}

VOID GETNEWNAME(CHARS *n, CHARS x)
/* use list x for vars and write "newname(var1,...,vark)" in n */
{
 
        static int nid;                                /* new id counter */

        GETANAME(n, "hid", x, nid++);

}

#ifndef HAVE_STRCHR
char *strchr(const char *s, int c) 
/* first char of s that is c */
{
        char *s1;

        for (s1 = (char *)s; *s1 != 0 ; s1++)
        {
          if (*s1 == c)
            return s1;
        }
        if (c == 0)
          return s1;
        else
          return NULL;
}
#endif
                 
#ifndef HAVE_STRSTR
char *strstr0(char *s1, char *s2) 
/* first char of s2 beyond the common initial seg */
{
        char c1, c2;

        for (c2 = *s2, c1 = *s1;  c1 != 0 && c2 != 0; c1=*++s1, c2=*++s1)
        {
          if (c1 != c2)
            return s2;
        }
        return s2;
}

char *strstr(const char *s1, const char *s2)
/* Find the first occurence of s2 in s1.  */
{
        char *s;

        if (*s2 == 0)
          return (char *)s1 + strlen((char *)s1);

        s = (char *)s1; 

        while (*s != 0) 
	{
	     s = strchr(s, *s2);   
	     if (s == NULL)
	       return NULL; /* failed */
             if (*strstr0(s,(char *)s2) == 0)
               /* number of matching initial chars is all of s2*/
               return s;
             s++;
	}
	return NULL; /* failed */
}
#endif

int is_in(CHARS x,CHARS y)
/*
  y should be a comma separated list, with y[-1]='('.
  x is a simple name.
*/
{
        register CHARS z;
        int n;

        n=strlen(x);
        while (1)
        {

        /* look for substring matching x in y */

                z = strstr((char*)y,(char*)x);

                if (z==NULL)

        /* I didn't see any */

                        return(0);

                if ((z==y || z[-1]==',') &&

         /* hmm. Possible. It starts off right.  */

                        (z[n]==0 || z[n]==',' ))

        /* and it ends ok too. Accept the match. */

                        return(1);

        /* No match. Try again. Increase y to next comma position+1 */

                y = strchr((char*)y,',');
                if (y++ == NULL)
                        break;
        }
        return(0);
}

int pis_in(CHARS x,CHARS y)
/*
  y should be a comma separated list of FOO x's, with y[-1]='('.
  x is a simple name.

  return 0 if not in list. 1 if in list tagged with VALUE and 2 if
  tagged with PARAM
*/
{
        int n;
        int m = 0; /* the result */

        n=strlen(x);
        while (*y)
        {
        /* move past initial VALUE or PARAM in y */
                if (! strncmp((char*)y,"VALUE ",6))
                    m=1;
                else if (! strncmp((char*)y,"PARAM ",6))
                    m=2;
        /* I didn't see any */
                else
                    return(0);

        /* increase y to this position */

                y += 6; /* length of "PARAM " and "VALUE " */

        /* look for substring matching x in y */

                if(!strncmp((char*)y,(char*)x,n) &&

         /* hmm. Possible. It starts off right.  */

                (!y[n] || y[n]==','))

        /* and it ends ok too. Accept the match. */

                        return m;

        /* No match. Try again. Increase y to next comma position+1 */

                y = strchr((char*)y,',');
                if (y++ == NULL)
                        break;
        }
        return 0;
}

