%{ 
/*****************************************************************************
 *   mkprintf: 	wraps any text file to a C function that outputs the 
 *		original text
 *
 *   Copyright (C) 1999  Frank Reker <frank@reker.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ******************************************************************************/
#define YY_DECL int mkprint_scanner()
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef VERSION
#define VERSION
#endif
FILE * f=NULL;
char * fdname = NULL;
int open = 0;
%}

%option lex-compat
%array
%option noyywrap

LINE		[^\%\n\t\f\0\a\b\r\v\"\'\\\001-\006\016-\037\x7f-\xff]+
NONPRINT	[\001-\006\016-\037\x7f-\xff]


%%
^{LINE}	{ fprintf (f, "\tfprintf (%s, \"%s", fdname, yytext); open = 1; }
{LINE}	{ fprintf (f, "%s", yytext); open = 1; }

^{NONPRINT}	{ fprintf (f, "\tfprintf (%s, \"\\%.3o", 
				fdname, yytext[0]); open = 1; }
{NONPRINT}	{ fprintf (f, "\\%.3o", yytext[0]); open = 1; }

^\n	{ fprintf (f, "\tfprintf (%s, \"\\n\");\n", fdname); open = 0; }
\n	{ fprintf (f, "\\n\");\n"); open = 0; }

^\t	{ fprintf (f, "\tfprintf (%s, \"\\t", fdname); open = 1; }
\t	{ fprintf (f, "\\t"); open = 1; }

^\%	{ fprintf (f, "\tfprintf (%s, \"%%%%", fdname); open = 1; }
\%	{ fprintf (f, "%%%%"); open = 1; }

^\f	{ fprintf (f, "\tfprintf (%s, \"\\f", fdname); open = 1; }
\f	{ fprintf (f, "\\f"); open = 1; }

^\0	{ fprintf (f, "\tfprintf (%s, \"\\0", fdname); open = 1; }
\0	{ fprintf (f, "\\0"); open = 1; }

^\a	{ fprintf (f, "\tfprintf (%s, \"\\a", fdname); open = 1; }
\a	{ fprintf (f, "\\a"); open = 1; }

^\b	{ fprintf (f, "\tfprintf (%s, \"\\b", fdname); open = 1; }
\b	{ fprintf (f, "\\b"); open = 1; }

^\r	{ fprintf (f, "\tfprintf (%s, \"\\r", fdname); open = 1; }
\r	{ fprintf (f, "\\r"); open = 1; }

^\v	{ fprintf (f, "\tfprintf (%s, \"\\v", fdname); open = 1; }
\v	{ fprintf (f, "\\v"); open = 1; }

^\"	{ fprintf (f, "\tfprintf (%s, \"\\\"", fdname); open = 1; }
\"	{ fprintf (f, "\\\""); open = 1; }

^\'	{ fprintf (f, "\tfprintf (%s, \"\\\'", fdname); open = 1; }
\'	{ fprintf (f, "\\\'"); open = 1; }

^\\	{ fprintf (f, "\tfprintf (%s, \"\\\\", fdname); open = 1; }
\\	{ fprintf (f, "\\\\"); open = 1; }


%%
main (int argc, char * argv[]) {
	int i;
	char * sfunc = NULL;
	char * infile = NULL;
	int with_head=1;
	open = 0;
	for (i=1; i<argc; i++) {
		if (!strcmp (argv[i], "--help") | !strcmp (argv[i], "-h")) {
			fprintf (stderr, "mkprintf: wraps any text file to a C function that outputs the original text\n\tusage:\n");
			fprintf (stderr, "\tmkprintf [-n] [-o <outfile>] [-f <function name>] \n\t\t\t[-d <file-descriptor name>] [<infile>]\n");
			fprintf (stderr, "\tmkprintf -V | --ver | --version\n");
			fprintf (stderr, "\tmkprintf -h | --help\n");
			fprintf (stderr, "\t-n\t no function header\n\n"); 
			return 0; }
		else if (!strcmp (argv[i], "--ver")) {
			printf ("mkprintf: Version %s\n", VERSION);
			printf ("\twritten by Frank Reker <frank@reker.net>\n");
			return 0; }
		else if (!strcmp (argv[i], "--version")) {
			printf ("mkprintf: version %s, Copyright (C) 1999 Frank Reker <frank@reker.net>\n", VERSION);
			printf ("    mkprintf comes with ABSOLUTELY NO WARRANTY.\n");
			printf ("    This is free software, and you are welcome to redistribute it\n");
			printf ("    under the terms of GNU General Public License (version 2).\n\n"); 
			return 0; }
		else if (!strcmp (argv[i], "-V")) {
			printf ("mkprintf: Version %s\n", VERSION);
			return 0; }
		else if (!strcmp (argv[i], "-o") && ((i+1) < argc))
			f = fopen (argv[++i], "w");
		else if (!strcmp (argv[i], "-f") && ((i+1) < argc))
			sfunc = strdup (argv[++i]);
		else if (!strcmp (argv[i], "-d") && ((i+1) < argc))
			fdname = strdup (argv[++i]);
		else if (!strcmp (argv[i], "-n"))
			with_head=0;
		else infile = argv[i];
	}
	if (!f) f=stdout;
	if (!sfunc) sfunc = strdup ("give");
	if (!fdname) fdname = strdup ("out_file");
	if (infile) 
		yyin = fopen (infile, "r");
	else	yyin = stdin;
	if (with_head) {
		fprintf (f, "#include <stdio.h>\n");
		fprintf (f, "#include <stdlib.h>\n\n");
		fprintf (f, "%s (FILE * %s) {\n", sfunc, fdname); }
	mkprint_scanner();
	if (open)
		fprintf (f, "\");\n");
	if (with_head)
		fprintf (f, "}\n\n");
	if (f != stdout) fclose (f);
	if (infile) fclose (yyin);
	free (sfunc); sfunc = NULL;
	free (fdname); fdname = NULL;
}






