;THIS PROGRAM TYPES PANTEL IF CHARACTER 0 IS SEND TO IT
org $2000
teststart:
start:
	mov sp,#$20
	ajmp main		;jump main
CR		equ	#$0d
LF		equ	#$0a
DELIMITER	equ	#$24
init:				;initialise serial i/o
	mov scon,#$52		;scon mode 1,ren=1,ti=1
	mov tmod,#$20		;tmod tc1= auto reload mode
	mov th1,#$ee		;th1 for 1200 Bd at 8Mhz
	mov tl1,#$55		;tl1 for 1200 Bd at 8Mhz
	setb tr1		;tr1 start timer1 (baud clock generator)
	setb ps			;ps enable s interrupt (ps bit in ip)
	setb es			;enable intr (es bit in ie)
	clr $af			;general enable of int
	ret
serin:				;serial in
	jnb ri,serin		;test received interrupt flag
				;ri=1 is data reception complete
	mov a,sbuf		;read data from sbuf into acc.
	clr ri			;sbuf ready for new data
	mov c,p			;load parity of received byte into carry
				;(acc.7 of transmitted byte)
	cpl c			;complement carry to form odd parity
	clr acc.7		;mask acc.7 (parity bit) for parity test of
				;new received byte
	ret
SEROUT:				;serial out
	mov c,p			;load carry with the parity flag (psw.0)
	cpl c			;complement carry to form odd parity
	mov acc.7,c		;load acc.7 with the carry bit
terout:
	jnb ti,terout		;test ti flag, if ti=0 sbuf not yet empty
	clr ti			;ti went high when sbuf became empty,ti flag
				;must be cleared before next byte can be
				;written to sbuf
	mov sbuf,a		;load new data to be transmitted into sbuf
	ret
main:				;main
	acall init		;initialise serial i/o
waitin:	acall serin		;call serial in (waits for received data)
;jc waitin			;if carry is 1 (parity error) ignore
	mov c,acc.0		;get bit 0 rcvd. data in carry.
	mov p1.2,c		;use it for LED (green).
	cjne a,'0',gepa		;if character 0 print panteltje
	mov r1,a		;save present char in r1
	mov dptr,strtxt		;start of txt
	acall prtrom		;call print from rom
	mov a,r1		;get the old character (0)
;prntxt:
;	movx a,@dptr		;get a text byte
;	cjne a,DELIMITER,gedel	;test for delimiter $
;	mov a,r1		;get the old character (0)
;	sjmp gepa		;delimiter found stop printing text
;gedel:			
;	acall SEROUT		;serial out text
;	inc dptr		;increment txt pointer
;	sjmp prntxt		;loop for next text byte
gepa:
	cjne a,CR,output	;compare to CR
	acall SEROUT		;call serial out with CR if it was a CR
	mov a,LF		;if CR send LF too
	acall SEROUT		;call serial out with LF
	sjmp waitin		;wait for received data
output:
	acall SEROUT		;call serial out (echo character)
	sjmp waitin		;loop for next byte from terminal

strtxt:	ds	'panteltje$'	;comment 1

prtrom:				;print from rom
getit:
	mov a,#0
	movc a,@a+dptr
	inc dptr
	cjne a,DELIMITER,typeit
	ret
typeit:
	acall SEROUT
	sjmp getit
;ACTUAL PROGRAM ENDS HERE

