/*
a52 (c) 28-12-1988-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



/*AL52S.C*/


#include "a52.h"

isbit(f)
char f;
{
int bval;
if(strcmp(oper[f],"cy")==0){return 0xd7;}
else if(strcmp(oper[f],"ac")==0){return 0xd6;}
else if(strcmp(oper[f],"f0")==0){return 0xd5;}
else if(strcmp(oper[f],"rs1")==0){return 0xd4;}
else if(strcmp(oper[f],"rs0")==0){return 0xd3;}
else if(strcmp(oper[f],"ov")==0){return 0xd2;}
else if(strcmp(oper[f],"p")==0){return 0xd0;}
else if(strcmp(oper[f],"tf1")==0){return 0x8f;}
else if(strcmp(oper[f],"tr1")==0){return 0x8e;}
else if(strcmp(oper[f],"tf0")==0){return 0x8d;}
else if(strcmp(oper[f],"tr0")==0){return 0x8c;}
else if(strcmp(oper[f],"ie1")==0){return 0x8b;}
else if(strcmp(oper[f],"it1")==0){return 0x8a;}
else if(strcmp(oper[f],"ie0")==0){return 0x89;}
else if(strcmp(oper[f],"it0")==0){return 0x88;}
else if(strcmp(oper[f],"sm0")==0){return 0x9f;}
else if(strcmp(oper[f],"sm1")==0){return 0x9e;}
else if(strcmp(oper[f],"sm2")==0){return 0x9d;}
else if(strcmp(oper[f],"ren")==0){return 0x9c;}
else if(strcmp(oper[f],"tb8")==0){return 0x9b;}
else if(strcmp(oper[f],"rb8")==0){return 0x9a;}
else if(strcmp(oper[f],"ti")==0){return 0x99;}
else if(strcmp(oper[f],"ri")==0){return 0x98;}
else if(strcmp(oper[f],"ea")==0){return 0xaf;}
else if(strcmp(oper[f],"es")==0){return 0xac;}
else if(strcmp(oper[f],"et1")==0){return 0xab;}
else if(strcmp(oper[f],"ex1")==0){return 0xaa;}
else if(strcmp(oper[f],"et0")==0){return 0xa9;}
else if(strcmp(oper[f],"ex0")==0){return 0xa8;}
else if(strcmp(oper[f],"ps")==0){return 0xbc;}
else if(strcmp(oper[f],"pt1")==0){return 0xbb;}
else if(strcmp(oper[f],"px1")==0){return 0xba;}
else if(strcmp(oper[f],"pt0")==0){return 0xb9;}
else if(strcmp(oper[f],"px0")==0){return 0xb8;}
else if(strcmp(oper[f],"rd")==0){return 0xb7;}
else if(strcmp(oper[f],"wr")==0){return 0xb6;}
else if(strcmp(oper[f],"t1")==0){return 0xb5;}
else if(strcmp(oper[f],"t0")==0){return 0xb4;}
else if(strcmp(oper[f],"int1")==0){return 0xb3;}
else if(strcmp(oper[f],"int0")==0){return 0xb2;}
else if(strcmp(oper[f],"txd")==0){return 0xb1;}
else if(strcmp(oper[f],"rxd")==0){return 0xb0;}
else return -1;
}

datstr(f)
char f;
{
int a,b;
a=0;
b=0;
if(oper[f][0]==39)/*the character ' */
	{
	while((a=oper[f][b+1])!=0)
		{
		if(a==39)break;
		o[b]=a;
		b++;
		}
	return b;
	}
else return -1;
}

issfr(f)
char f;
{
int biad,ind;
if((ind=zindex(oper[f],"."))!=-1)
	{
	biad=oper[f][ind+1]-48;
	}
else biad=0;
if(oper[f][0]=='p')
	{
	if(oper[f][1]=='0')return biad+0x80;
	else if(oper[f][1]=='1')return biad+0x90;
	else if(oper[f][1]=='2')return biad+0xa0;
	else if(oper[f][1]=='3')return biad+0xb0;
	else if(zindex(oper[f],"psw")==0){return biad+0xd0;}
	else if(zindex(oper[f],"pcon")==0){return biad+0x87;} /* modified for more bits */
	else return -1;
	}
else if(oper[f][0]=='t')
	{
	if(zindex(oper[f],"t2con")==0){return biad+0xc8;}
	else if(zindex(oper[f],"tcon")==0){return biad+0x88;}
	else if(strcmp(oper[f],"tmod")==0){return 0x89;}
	else if(strcmp(oper[f],"tl0")==0){return 0x8a;}
	else if(strcmp(oper[f],"tl1")==0){return 0x8b;}
	else if(strcmp(oper[f],"th0")==0){return 0x8c;}
	else if(strcmp(oper[f],"th1")==0){return 0x8d;}
	else if(strcmp(oper[f],"tl2")==0){return 0xcc;}
	else if(strcmp(oper[f],"th2")==0){return 0xcd;}
	else return -1;
	}
else if(zindex(oper[f],"acc")==0){return biad+0xe0;}
else if(strcmp(oper[f],"rcap2l")==0){return 0xca;}
else if(strcmp(oper[f],"rcap2h")==0){return 0xcb;}
else if(zindex(oper[f],"ip")==0){return biad+0xb8;}
else if(zindex(oper[f],"ie")==0){return biad+0xa8;}
else if(zindex(oper[f],"scon")==0){return biad+0x98;}
else if(strcmp(oper[f],"sbuf")==0){return 0x99;}
else if(strcmp(oper[f],"sp")==0){return 0x81;}
else if(strcmp(oper[f],"dpl")==0){return 0x82;}
else if(strcmp(oper[f],"dph")==0){return 0x83;}
else if(zindex(oper[f],"b")==0){return biad+0xf0;}
else return -1;
}

stolab(f)
char f;
{
register int a,b,i,startv;
register char rounfl;
rounfl=0;
a=0;
b=0;
a=oper[f][0];
if((a>='a')&&(a<='z'))goto islabel;
if((a>='A')&&(a<='Z'))goto islabel;
return -4; /* illegal label */

islabel: ;
for(i=0;i<LABELLENGTH;i++)
	{
	a=oper[f][i];
	if(a==0)break;
	b=b^a;
	}
if(i==LABELLENGTH){return -3;}/*label too long*/
b=b+256*(1-(i-2*(i/2)));/*even character count in upper part of array*/
startv=b;
np: if((rounfl)&&(b==startv)){return -1;}/*no free space*/
 if(labelf[b]==0)
	{
	for(i=0;i<LABELLENGTH;i++)
		{
		if(oper[f][i]==0)break;
		labelt[b][i]=oper[f][i];
		}
	labelt[b][i]=0;
	}
else
	{
	if(strcmp(oper[f],labelt[b])==0){return -2;}/*multi defined*/
	b+=1;
	if(b>LABELTABLENGTH)
		{
		rounfl=1;
		b=0;
		}
	goto np;
	}
labelv[b]=pc;
labelf[b]=1;
return 0;
}

getlab(f)
char f;
{
int a,b,i,startv;
char rounfl;
rounfl=0;
a=0;
b=0;
for(i=0;i<LABELLENGTH;i++)
	{
	a=oper[f][i];
	if(a==0)break;
	b=b^a;
	}
b=b+256*(1-(i-2*(i/2)));/*even character count in upper part of array*/
startv=b;
np: if((rounfl)&&(b==startv)){return -1;}/* not found in array */
if(labelf[b]!=1){return -1;} /* not found, calculated position is empty */
if(strcmp(oper[f],labelt[b])==0){return b;} /* found, return array position */
b+=1;
if(b>LABELTABLENGTH)
	{
	rounfl=1;
	b=0;
	}
goto np;/*try one position higher, if end array start at beginning*/
}

hash(s)/*form hash value for string s */
char *s;
{
int hashval;
for(hashval=0;*s!='\0';)hashval+= *s++;
/* sum of ascii value of characters divived by tablesize */
return hashval % EQUTABLENGTH;
}

struct equtab *lookup(s)  /*look for s in pnttab */
char *s;
{
struct equtab *pa;
for(pa=pnttab[hash(s)];pa!=NULL;pa=pa->nxtentr)/*pa points to next entry*/
if(strcmp(s,pa->text)==0)return pa;/*found it (the text pointed to by pa)*/
return NULL;/*not found*/
}

struct equtab *install(text,replac)/*put (text.replac) in pnttab*/
char *text,*replac;
{
struct equtab *pa,*lookup();
char *strsave();
/*char *alloc()*/
int hashval;
if((pa=lookup(text))==NULL) /*not found*/
	{
	pa=(struct equtab *)malloc(sizeof(*pa));
	if(pa==0)return NULL;
	if((pa->text=strsave(text))==NULL)return NULL;
	hashval=hash(pa->text);
	pa->nxtentr=pnttab[hashval];
	pnttab[hashval]=pa;
	}
else /*already there*/
	free (pa->replac); /*free previous defenition*/
if ((pa->replac=strsave(replac))==NULL)return NULL;
else return pa;
}

char *strsave(s) /*save string s somewhere*/
char *s;
{
char *p;
/*char *alloc()*/
if ((p=malloc(strlen(s)+1))!=NULL)
	strcpy(p,s);
return p;
}

