/*
a52 (c) 28-12-1988-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#include "a52.h"


al52()
{
static char aflag,eflag,fflag,bflag,vi2,vi3,vi4,va1,va2,va3,va4,pca,rev,shift;
static char a,b,i;
static int vi1,dsl,dbc;
static unsigned int retv;
/*in pass 1 and pass 2 pc is determined*/
orgfl=0;
if(oper[0][0]=='o')
	{
	if((strcmp(oper[0],"org")==0)&&(fields==2))
		{
		evaluate(1);
		if((t[1]==DATA)||(t[1]==IMDATA))
						{
						pc=e[1];
						pco=pc;
						orgfl=1;
						return OK;
						}
		else errorp('E');
		return ERROR;
		}
	}/*not org*/
if(oper[0][0]=='d')
	{
	if((strcmp(oper[0],"ds")==0)&&(fields==2))
		{
		if((dsl=datstr(1))!=-1)
			{
			pc+=dsl;
			return OK;
			}
		else errorp('E');
		return ERROR;
		}/*not ds*/
	if((strcmp(oper[0],"dw")==0)&&(fields==2)&&(pass==1))
		{
		pc+=2;
		return OK;
		}
	if(strcmp(oper[0],"db")==0)
		{
		pc+=-1;
		}
	}
pc++;/*always 1 opcode, exept for org this sets pc  also ds*/
shift=0;
if((fields==1)&&(pass==1))return OK;
else for(field=1;field<fields;field++)
	{
	o[field]=0;
	evaluate(field);
	switch(t[field])
		{
		case DATA :
		case IMDATA:
				{
				/*the 16 bit exeptions*/
				if((oper[0][0]=='l')||(oper[1][0]=='d'))
					{
			if(strcmp(oper[0],"ljmp")==0){o[0]=0x02;  }
			else if(strcmp(oper[0],"lcall")==0){o[0]=0x12;  }
			else if(strcmp(oper[1],"dptr")==0){o[0]=0x90;  }
						{
						pc+=2;
						if(pass==2)
							{
							if(o[0]!=0x90)
								{
							o[1]=(e[1]/256);
							o[2]=e[1]-256*o[1];
								}
							else
								{
							o[1]=(e[2]/256);
							o[2]=e[2]-256*o[1];
								}
							}
						return OK;/*all passes*/
						}
					}
				else
					{
					pc++;
					if(pass==2)
						{
						o[field-shift]=e[field];
						}
					break;
					}
				}
		case REGISTER:{shift++;break;}
		}/*end switch*/
	}/*end all fields*/
if(pass==1)return OK;
/*********************/
if((zindex(oper[0],"j")!= -1)&&(oper[0][0]!='a'))/*exeption "ajmp"*/
	{
	/*jumping relative*/
	if((a=rel(shift))==0){errorp('R');return ERROR;}
	if(fields==2)
		{
		if((strcmp(oper[0],"jmp")==0)&&(t[1]==REGISTER)&&(e[1]==QAPLDPTR))
			{
			{o[0]=0x73;return OK;}
			}
		else if (strcmp(oper[0],"jz")==0){o[0]=0x60;return OK;}
		else if (strcmp(oper[0],"jnz")==0){o[0]=0x70;return OK;}
		else if (strcmp(oper[0],"jc")==0){o[0]=0x40;return OK;}
		else if (strcmp(oper[0],"sjmp")==0){o[0]=0x80;return OK;}
		}
	else if(fields==3)
		{
		if (strcmp(oper[0],"jnc")==0){o[0]=0x50;return OK;}
		else if (strcmp(oper[0],"jb")==0){o[0]=0x20;return OK;}
		else if (strcmp(oper[0],"jnb")==0){o[0]=0x30;return OK;}
		else if (strcmp(oper[0],"jbc")==0){o[0]=0x10;return OK;}
		else if (strcmp(oper[0],"djnz")==0)
			{
			if(t[1]==DATA){o[0]=0xd5;return OK;}
			else if(t[1]==REGISTER){o[0]=0xd0+e[1];return OK;}
			else errorp('E');
			return ERROR;
			}
		}
	else if (fields==4)
		{
		if (strcmp(oper[0],"cjne")==0)
			{
			if((t[1]==REGISTER)&&(t[2]==IMDATA)&&(e[1]==AREG))
				{o[0]=0xb4;return OK;}
			else if((t[1]==REGISTER)&&(t[2]==DATA)&&(e[1]==AREG))
				{o[0]=0xb5;return OK;}
			else if((t[1]==REGISTER)&&(t[2]==IMDATA))
				{o[0]=0xb0+e[1];return OK;}
			else errorp('E');
			return ERROR;
			}
		}
	else errorp('O');
	return ERROR;
	}/*end jumping*/
else if(oper[0][0]=='m')
	{
	/*m group*/
	if ((strcmp(oper[0],"mov")==0)&&(fields==3))
		{
		/*mov    */
		if((r[1]==RELI)||(r[2]==RELI)){errorp('E');return ERROR;}/*movx,movc*/
		if((t[1]==DATA)&&(t[2]==DATA)){o[0]=0x85;return OK;}
		else if((t[1]==DATA)&&(t[2]==IMDATA)){o[0]=0x75;return OK;}
		else if((t[1]==REGISTER)&&(e[1]==CARRY)&&(t[2]==DATA))
			{
			/*mov c,bit addr*/
			o[0]=0xa2;return OK;
			}
		else if((t[2]==REGISTER)&&(e[2]==CARRY)&&(t[1]==DATA))
			{
			/*mov bit addr,c*/
			o[0]=0x92;return OK;
			}
		else if((t[1]==REGISTER)&&(e[1]==AREG))
			{
			/*mov a,???*/
			if(t[2]==IMDATA){o[0]=0x74;return OK;}
			else if (t[2]==DATA){o[0]=0xe5;return OK;}
			else if(t[2]==REGISTER){o[0]=0xe0+e[2];return OK;}
			else errorp('E');
			return ERROR;
			}/*end mov a,???*/
		else if((t[1]==REGISTER)&&(t[2]==DATA))
			{
			/*mov reg,data*/
			o[0]=0xa0+e[1];return OK;
			}
		else if((t[1]==REGISTER)&&(t[2]==IMDATA))
			{
			/*mov reg,#data*/
			o[0]=0x70+e[1];return OK;
			}
		else if((t[2]==REGISTER)&&(e[2]==AREG))
			{
			/*mov ???,a*/
			if(t[1]==DATA){o[0]=0xf5;return OK;}
			else if(t[1]==REGISTER){o[0]=0xf0+e[1];return OK;}
			else errorp('E');
			return ERROR;
			}/*end mov ???,a*/
		else if((t[2]==REGISTER)&&(e[2]!=CARRY)&&(t[1]==DATA))
			{
			/*mov data addr,reg*/
			o[0]=0x80+e[2];return OK;
			/*end mov data addr,reg*/
			}
		else errorp('E');
		return ERROR;
		}/*end mov*/
	else if((strcmp(oper[0],"movx")==0)&&(fields==3))
		{
		/* movx*/    
		if((t[1]==REGISTER)&&(e[1]==AREG)&&(t[2]==REGISTER)\
				&&(fields==3))
			{
			if(e[2]==QDPTR){o[0]=0xe0;return OK;}
			else if(e[2]==QR0){o[0]=0xe2;return OK;}
			else if(e[2]==QR1){o[0]=0xe3;return OK;}
			else errorp('E');
			return(ERROR);
			}
		else if((t[1]==REGISTER)&&(t[2]==REGISTER)&&(e[2]==AREG)\
				&&(fields==3))
			{
			if(e[1]==QDPTR){o[0]=0xf0;return(OK);}
			else if(e[1]==QR0){o[0]=0xf2;return(OK);}
			else if(e[1]==QR1){o[0]=0xf3;return(OK);}
			}
		else errorp('S');
		return(ERROR);
		}/*end movx*/

	else if((strcmp(oper[0],"movc")==0)&&(fields==3))
		{
		/*movc  */
		if((t[1]==REGISTER)&&(t[2]==REGISTER)&&(e[1]==AREG)\
					&&(fields==3))
			{
			if(e[2]==QAPLDPTR){o[0]=0x93;return(OK);}
			else if(e[2]==QAPLPC){o[0]=0x83;return(OK);}
			}
		else errorp('E');
		return(ERROR);
		}/*end movc  */
	else if(strcmp(oper[0],"mul")==0)
		{
		/*mul ab*/
		if((fields==2)&&(t[1]==REGISTER)&&(e[1]==ABREG))
			{
			o[0]=0xa4;return(OK);
			}
		else errorp('E');
		return(ERROR);
		}/*end mul ab*/
	else errorp('O');
	return(ERROR);
	}/*end m group*/
else if(oper[0][0]=='a')
	/*a group*/
	{
	if(strcmp(oper[0],"add")==0)
		{
		/*add a,???*/
		if((t[1]==REGISTER)&&(e[1]==AREG)&&(fields==3))
			{
			if(t[2]==IMDATA){o[0]=0x24;return(OK);}
			else if(t[2]==DATA){o[0]=0x25;return(OK);}
			else if(t[2]==REGISTER){o[0]=0x20+e[2];return(OK);}
			}
		else errorp('E');
		return(ERROR);
		}
	else if(strcmp(oper[0],"addc")==0)
		{
		/*addc a,???*/
		if((t[1]==REGISTER)&&(e[1]==AREG)&&(fields==3))
			{
			if(t[2]==IMDATA){o[0]=0x34;return(OK);}
			else if(t[2]==DATA){o[0]=0x35;return(OK);}
			else if(t[2]==REGISTER){o[0]=0x30+e[2];return(OK);}
			}
		else errorp('E');
		return(ERROR);
		}
	else if((strcmp(oper[0],"anl")==0)&&(fields==3))
		/*anl ?,???*/
		{
		if((t[1]==DATA)&&(t[2]==REGISTER)&&(e[2]==AREG))
			{
			o[0]=0x52;return(OK);
			}
		else if((t[1]==DATA)&&(t[2]==IMDATA))
			{
			o[0]=0x53;return(OK);
			}
		else if((t[1]==REGISTER)&&(t[2]==IMDATA)&&(e[1]==AREG))
			{
			o[0]=0x54;return(OK);
			}
		else if((t[1]==REGISTER)&&(t[2]==DATA)&&(e[1]==AREG))
			{
			o[0]=0x55;return(OK);
			}
		else if((t[1]==REGISTER)&&(t[2]==REGISTER)&&(e[1]==AREG))
			{
			o[0]=0x50+e[2];return(OK);
			}
		else if((t[1]==REGISTER)&&(e[1]==CARRY)&&(t[2]==DATA))
			{
			if(oper[2][0]=='/'){o[0]=0xb0;return(OK);}
			else {o[0]=0x82;return(OK);}
			}
		else errorp('E');
		return(ERROR);
		}/*end anl*/
	else if(strcmp(oper[0],"acall")==0)
		{
		if(fields==2)
			{
			if((retv=agrp(17))==1)return(OK);
			else errorp('R');
			return(ERROR);
			}
		else errorp('E');
		return(ERROR);
		}/*end acall*/
	else if (strcmp(oper[0],"ajmp")==0)
		{
		if(fields==2)
			{
			if((retv=agrp(1))==1)return(OK);
			else errorp('R');
			return(ERROR);
			}
		else errorp('E');
		return(ERROR);
		}/*end ajmp*/
	else errorp('O');
	return(ERROR);
	}/*end a group*/
else if(oper[0][0]=='x')
	{
	/*x group*/
	if((strcmp(oper[0],"xrl")==0)&&(fields==3))
		{
		/*xrl*/
		if((t[1]==DATA)&&(t[2]==REGISTER)&&(e[2]==AREG))
			{
			o[0]=0x62;return(OK);
			}
		else if((t[1]==DATA)&&(t[2]==IMDATA))
			{
			o[0]=0x63;return(OK);
			}
		else if((t[1]==REGISTER)&&(t[2]==IMDATA)&&(e[1]==AREG))
			{
			o[0]=0x64;return(OK);
			}
		else if((t[1]==REGISTER)&&(t[2]==DATA)&&(e[1]==AREG))
			{
			o[0]=0x65;return(OK);
			}
		else if((t[1]==REGISTER)&&(t[2]==REGISTER)&&(e[1]==AREG))
			{
			o[0]=0x60+e[2];return(OK);
			}
		else errorp('E');
		return(ERROR);
		}/*end xlr*/
	else if((strcmp(oper[0],"xch")==0)&&(fields==3))
		{
		/*xch a,???*/
		if((t[1]==REGISTER)&&(t[2]==DATA)&&(e[1]==AREG))
			{
			o[0]=0xc5;return(OK);
			}
		else if((t[1]==REGISTER)&&(t[2]==REGISTER)&&(e[1]==AREG))
			{
			o[0]=0xc0+e[2];return(OK);
			}
		else errorp('E');
		return(ERROR);
		}/*end xch a,???*/
	else if((strcmp(oper[0],"xchd")==0)&&(fields==3))
		{
		if((t[1]==REGISTER)&&(e[1]==AREG)&&(t[2]==REGISTER))
			{
			if(e[2]==QR0){o[0]=0xd6;return(OK);}
			else if(e[2]==QR1){o[0]=0xd7;return(OK);}
			}
		else errorp('E');
		return(ERROR);
		}/*end xchd a,@r?*/
	else errorp('O');
	return(ERROR);
	}/*end x group*/
else if(oper[0][0]=='s')
	{
	/*s group*/
	if((strcmp(oper[0],"subb")==0)&&(fields==3))
		{
		if((t[1]==REGISTER)&&(e[1]==AREG))
			{
			if(t[2]==IMDATA){o[0]=0x94;return(OK);}
			else if(t[2]==DATA){o[0]=0x95;return(OK);}
			else if(t[2]==REGISTER){o[0]=0x90+e[2];return(OK);}
			}
		else errorp('E');
		return(ERROR);
		}/*end subb*/
	else if((strcmp(oper[0],"swap")==0)&&(fields==2))
		{
		if((t[1]==REGISTER)&&(e[1]==AREG)){o[0]=0xc4;return(OK);}
		else errorp('E');
		return(ERROR);
		}/*end swap*/
	else if((strcmp(oper[0],"setb")==0)&&(fields=2))
		{
		if(t[1]==DATA){o[0]=0xd2;return(OK);}
		else if((t[1]=REGISTER)&&(e[1]==CARRY)){o[0]=0xd3;return(OK);}
		else errorp('E');
		return(ERROR);
		}
	else errorp('O');
	return(ERROR);
	}/*end s group*/
else if(oper[0][0]=='i')
	{
	/*i group*/
	if((strcmp(oper[0],"inc")==0)&&(fields==2))
		{
		if((t[1]==REGISTER)&&(e[1]==AREG)){o[0]=0x04;return(OK);}
		else if((t[1]==REGISTER)&&(e[1]==DPTR)){o[0]=0xa3;return(OK);}
		else if(t[1]==DATA){o[0]=0x05;return(OK);}
		else if(t[1]==REGISTER){o[0]=0x00+e[1];return(OK);}
		else errorp('E');
		return(ERROR);
		}/*end inc ?*/
	else errorp('O');
	return(ERROR);
	}/*end i group*/
else if(oper[0][0]=='d')
	{
	/*d group*/
	if((strcmp(oper[0],"dec")==0)&&(fields==2))
		{
		if((t[1]==REGISTER)&&(e[1]==AREG)){o[0]=0x14;return(OK);}
		else if(t[1]==DATA){o[0]=0x15;return(OK);}
		else if(t[1]==REGISTER){o[0]=0x10+e[1];return(OK);}
		else errorp('E');
		return(ERROR);
		}/*end dec ?*/
	else if((strcmp(oper[0],"div")==0)&&(fields==2))
		{
		if((t[1]==REGISTER)&&(e[1]==ABREG)){o[0]=0x84;return(OK);}
		else errorp('E');
		return(ERROR);
		}
	else if((strcmp(oper[0],"da")==0)&&(fields==2))
		{
		if((t[1]==REGISTER)&&(e[1]==AREG)){o[0]=0xd4;return(OK);}
		else errorp('E');
		return(ERROR);
		}
	else if((strcmp(oper[0],"dw")==0)&&(fields==2))
		{
		if((t[1]==IMDATA)||(t[1]==DATA))
			{
			o[0]=e[1]/256;
			o[1]=e[1]-256*o[0];
			return(OK);
			}
		else errorp('E');
		return(ERROR);
		}
	else if((strcmp(oper[0],"db")==0))
		{
		for(dbc=0;dbc<fields-1;dbc++)
/*for db 111 :fields=2, t[0] and t[1], only one time evaluation*/
			{
			if((t[dbc+1]==DATA)||(t[dbc+1]==IMDATA))
				{
				if(e[dbc+1]<256)
					{
					o[dbc]=e[dbc+1];/*was =o[ breakpoint*/
					continue;
					}
				else errorp('V');
				return(ERROR);
				}
			else
				{
				errorp('E');
				return(ERROR);
				}
			}
		return(OK);
		}
	else errorp('O');
	return(ERROR);
	}/*end d group*/
else if(oper[0][0]=='o')
	{
	/*o group*/
	if((strcmp(oper[0],"orl")==0)&&(fields==3))
		{
		if((t[1]==DATA)&&(t[2]==REGISTER)&&(e[2]==AREG))
			{
			o[0]=0x42;return(OK);
			}
		else if((t[1]==DATA)&&(t[2]==IMDATA)){o[0]=0x43;return(OK);}
		else if((t[1]==REGISTER)&&(e[1]==AREG))
			{
			if(t[2]==IMDATA){o[0]=0x44;return(OK);}
			else if(t[2]==DATA){o[0]=0x45;return(OK);}
			else if(t[2]==REGISTER){o[0]=0x40+e[2];return(OK);}
			}
		else if((t[1]==REGISTER)&&(e[1]==CARRY)&&(t[2]==DATA))
			{
			if(oper[2][0]!='/'){o[0]=0x72;return(OK);}
			else if(oper[2][0]=='/'){o[0]=0xa0;return(OK);}
			}
		else errorp('E');
		return(ERROR);
		}/*end orl ?*/
	else errorp('O');
	return(ERROR);
	}/*end o group*/
else if(oper[0][0]=='c')
	{
	/*c group*/
	if((strcmp(oper[0],"clr")==0)&&(fields==2))
		{
		if(t[1]==DATA){o[0]=0xc2;return(OK);}
		else if((t[1]==REGISTER)&&(e[1]==CARRY)){o[0]=0xc3;return(OK);}
		else if((t[1]==REGISTER)&&(e[1]==AREG)){o[0]=0xe4;return(OK);}
		else errorp('E');
		return(ERROR);
		}
	else if((strcmp(oper[0],"cpl")==0)&&(fields==2))
		{
		if(t[1]==DATA){o[0]=0xb2;return(OK);}
		else if((t[1]==REGISTER)&&(e[1]==AREG)){o[0]=0xf4;return(OK);}
		else if((t[1]==REGISTER)&&(e[1]==CARRY)){o[0]=0xb3;return(OK);}
		else errorp('E');
		return(ERROR);
		}
	else errorp('O');
	return(ERROR);
	}/*end c group*/
else if(oper[0][0]=='r')
	{
	/*r group*/
	if((t[1]==REGISTER)&&(e[1]==AREG)&&(fields==2))
		{
		if(strcmp(oper[0],"rr")==0){o[0]=0x03;return(OK);}
		else if(strcmp(oper[0],"rrc")==0){o[0]=0x13;return(OK);}
		else if(strcmp(oper[0],"rl")==0){o[0]=0x23;return(OK);}
		else if(strcmp(oper[0],"rlc")==0){o[0]=0x33;return(OK);}
		else errorp('E');
		return(ERROR);
		}
	else if(fields==1)
		{
		if(strcmp(oper[0],"ret")==0){o[0]=0x22;return(OK);}
		else if(strcmp(oper[0],"reti")==0){o[0]=0x32;return(OK);}
		else errorp('O');
		return(ERROR);
		}
	else errorp('E');
	return(ERROR);
	}/*end r group*/
else if(oper[0][0]=='p')
	{
	/*p group*/
	if(strcmp(oper[0],"pop")==0)
		{
		if((fields==2)&&(t[1]==DATA)){o[0]=0xd0;return(OK);}
		else errorp('E');
		return(ERROR);
		}
	else if(strcmp(oper[0],"push")==0)
		{
		if((fields==2)&&(t[1]==DATA)){o[0]=0xc0;return(OK);}
		else errorp('E');
		return(ERROR);
		}
	else errorp('O');
	return(ERROR);
	}/*end p group*/
else if(oper[0][0]=='n')
	{
	/*n group*/
	if(strcmp(oper[0],"nop")==0)
		{
		if(fields==1){o[0]=0x00;return(OK);}
		else errorp('E');
		return(ERROR);
		}
	else errorp('O');
	return(ERROR);
	}/*end n group*/
else errorp('O');
return(ERROR);
}/*end al52*/


agrp(grp)
int grp;
{
unsigned int a12,apg,rpg,h;
apg=pc/2048;
rpg=e[1]/2048;
a12=e[1]&0x07ff;/*the 2048 page base address*/
h=a12/256;
o[1]=a12-256*h;
o[0]=grp+32*h;
if(apg!=rpg)return(0);
return(1);
}


ev(f)
char	f;
{
char d,operat,labelfl,laipfl,nwfifl,lacoco,chipfl,imdfl,notfl,bitfl;
unsigned int a,b,c,y,tval,i;
b=0;
c=10;
imdfl=0;
laipfl=0;
notfl=0;
bitfl=0;
labelfl=0;
nwfifl=1;
lacoco=0;
chipfl=0;
operat='+';
tval=0;
for(i=0;i<20;i++)
	{
	d=oper[f][i];
	if((d==0)||(d=='+')||(d=='-'))
		{
		if(laipfl)
			{
			laipfl=0;
			oper[14][lacoco]=0;
			if((y=getlab(14))==-1){errorp('U');}
			else
				{
				if(operat=='+')tval+=labelv[y];
				else if(operat=='-')tval-=labelv[y];
				labelfl=1;
				}
			}
		else if(chipfl>0)
			{
			if(chipfl==2)
				{
				if(operat=='+')tval+=b;
				else if(operat=='-')tval-=b;
				imdfl=1;
				}
			else{errorp('C');}
			}
		else
			{
			if(operat=='+')tval+=b;
			else if(operat=='-')tval-=b;
			}
		operat=d;
		c=10;
		b=0;
		bitfl=0;
		if(d==0)break;
		nwfifl=1;
		lacoco=0;
		continue;
		}
	if(nwfifl)
		{
		nwfifl=0;
		laipfl=0;
		chipfl=0;
		if((d>='a')&&(d<='z'))laipfl=1;
		else if((d>='A')&&(d<='Z'))laipfl=1;
		/*labels start with a character*/
		if(d==39){chipfl=1;continue;}/*character must follow ' */
		}

	if(laipfl)
		{
		oper[14][lacoco]=oper[f][i];/*copy the label text*/
		lacoco++;
		continue;
		}
	if(!laipfl)
		{
		if(chipfl==1)
			{
			b=d;
			chipfl=2;
			continue;
			}
		if((d==39)&&(chipfl==2)){continue;}
		else if(d=='/'){notfl=1;continue;}
		else if(d=='#'){imdfl=1;continue;}
		else if(d=='$'){c=16;continue;}
		else if(d=='&'){c=2;continue;}
		else if(d=='.'){bitfl=1;continue;}
		if(c==2){if((d!='0')&&(d!='1')){errorp('B'); }}
		else if(c==10){if(isdigit(d)==0){errorp('D'); }}
		else if(c==16){if(ishex(d)==0){errorp('H'); }}
		if(d<58)a=d-48;
		else if(d>96)a=d-87;
		if(!bitfl){b=b*c+a;}
		else if(bitfl>1){errorp('A');}
		else if(bitfl=1)
			{
			if(a>7){errorp('A');}
			if((b<0x20)||(b>0x2f)){errorp('A');}
			else 
				{
// bugfix Sun Jan 10 23:31:38 CET 2010
// 0x20 = base
// 0x2Fh is last
// 0x20 is bit 0
// 0x21 is bit 8
// 0x22 is bit 16
				b = ( (b - 0x20) * 8) + a;
				bitfl++;
				}
			}
		continue;
		}
	}
e[f]=tval;
if(labelfl)
	{
	r[f]=LABEL;
	t[f]=IMDATA;
	}
else if(bitfl)
	{
	r[f]=0;
	t[f]=DATA;
	}
else
	{
	r[f]=0;
	if(imdfl)t[f]=IMDATA;
	else t[f]=DATA;
	}
return(0);
}


isreg(f)
char	f;
{
int	av;
if((oper[f][0]=='r')&&(isdigit(oper[f][1])))
					{
					av=oper[f][1]-48+8;
					return(av);
					}
else if(strcmp(oper[f],"@r0")==0){return(QR0);}
else if(strcmp(oper[f],"@r1")==0){return(QR1);}
else if(strcmp(oper[f],"ab")==0)return(ABREG);
else if(strcmp(oper[f],"a")==0)return(AREG);
else if(strcmp(oper[f],"b")==0)return(BREG);
else if(strcmp(oper[f],"c")==0)return(CARRY);
else if(strcmp(oper[f],"@a+dptr")==0){r[f]=RELI;return(QAPLDPTR);}
else if(strcmp(oper[f],"@a+pc")==0){r[f]=RELI;return(QAPLPC);}
else if(strcmp(oper[f],"dptr")==0)return(DPTR);
else if(strcmp(oper[f],"@dptr")==0){r[f]=RELI;return(QDPTR);}
return(ERROR);
}


evaluate(f)
char f;
{
int a;
r[f]=0;/*not yet label*/
if((a=isreg(f))!=-1)
	{
	e[f]=a;
	t[f]=REGISTER;
	return(1);
	}
else if((a=issfr(f))!=-1)
	{
	e[f]=a;
	t[f]=DATA;
	return(1);
	}
else if((a=isbit(f))!=-1)
	{
	e[f]=a;
	t[f]=DATA;
	return(1);
	}
else
	{
	ev(f);
	/*e[f],t[f] en r[f] set by ev(f)*/
	return(1);
	}
/*no error message here, this is already done by ev(f)*/
}


rel(sh)
char sh;
{
unsigned int a,b;
b=e[fields-1];
if(r[fields-1]==LABEL)
	{
	if(b>=pc)
		{
		a=b-pc;
		if(a>127){return(0);}
		}
	else if(pc>b)
		{
		a=pc-b;
		if(a>128){return(0);}
		a=256-a;/*Set the sign flag*/
		}
	}
else 
	{
	a=b;
	if(a>255){return(0);}
	}
o[fields-1-sh]=a;
return(1);
}


errorp(a)
char a;
{
lierfl=1;
error=a;
if(pass==2)errors++;
}


ishex(a)
char a;
{
if((a>='0')&&(a<='9'))return(1);
else if((a>='a')&&(a<='f'))return(1);
else return(0);
}

