
A52 DOC		1-1-1989	copyright Jan Pantelte.

Documentation of the a52 assembler for the 8051/8052 series microcomputers.


NOTHING OUT OF THIS FILE MAY BE COPIED IN ANY WAY WITHOUT THE WRITTEN PERMISSION OF THE AUTHOR.

THE AUTHOR IS NOT RESPONSABLE FOR ANY DAMAGE OF ANY KIND CAUSED BY ERRORS
IN THE ASSEMBLER OR THIS DOCUMENTATION FILE (IF THERE ARE ANY).


The a52 assembler is a 2 pass assembler.
During pass 1 labels and definitions by the equ statement are stored in ram,
also the program counter is incremented by the correct value.
In pass 2 the actual code is generated by looking up the labels, equ statements
and commands.
Expressions are also evaluated in pass 2, with the exeption of the expression
following org, wich is evaluated in pass 1.

The assembler operates line and field orientated, this is:
The input text is split into fields of max 20 characters.
A line ends with a CR or LF, and may consist of several instructions, each of
several fields (max. 15 fields), followed by a comment.
A field ends with  tab  space  ,  CR  LF  `   and  ;
An instruction ends if a CR LF or the characters ` or ; are read from the input
file.

If more instructions on one line are used, the character ` can be used as a
separator. This has the same effect as a CR or LF, but you can view more of 
your listing at the same time on the screen.


COMMENTS
Comments must be preceded by the character ; and anything on a line following ; is ignored.
Comments do not appear in the list file.
The list file shows how the input file was split.


COMMANDLINE/SOURCEFILE
The assembler requires a source file with the extention of .asm,
if the source file has any other extention then this extention must
be specified in the command line.

Example: The command line could take the form of:
a52 sourcef -b -r
or:
a52 -b -i sourcef.ext
a52 -b50000 sourcef.ext -l >filename.ext
This last Unix stile i/o redirection sends the listing to filename.ext,
there will be no console output.


The following switches are allowed in the command line:
-l	generate a listing on the console including the bytes and addresses 
	generated by the assembler.

-bn	make a outputfile sourcef.bas.
	This file contains a program in MCS basic with the assembled code in
	data statements.
	For next loops are added as required by the code in the assembled
	program, that poke the code into ram on the 8052ah basic device.
	The basic program starts at line n.
	If n is omitted then the program starts at line 0.
	n must be between 0 and 65535 inclusive.
	This basic program can be merged (with any editor) or uploaded after
	you have written your own on the 8052ah device.
	At the beginning of your basic program it must be called as a sub-
	routine.
	If no other data statements are present in the basic program, add a
	line with the restore statement before the point where this subroutine
	is called.
	You can now call your assembly language routine from anywhere in the
	basic program using the MCS basic call statement.

-r	If the b switch is used, the -r switch will create a slightly different
	basic program.
	This program can be directly run, it will poke your code into ram,
	then it will call the first org statement used in the asm file.
	In the hardware, in the code area you use, psen and rd MUST be anded
	together, also you must take care that your assembly language routine
	is not orged somewhere within the basic listing.
	This option allows for extremely fast software devellopment,
	since it does not require the presence of a special loader on the 
	8052ah device, and you can now upload at your own favorit high speed.

-i	This switch causes the assembler to generate an outputfile
	in Intel hex format.This file has the extention .hex.

-h	If invoced this switch lets the assembler make an output file in the 
	form of a hexdump. The extention is .hxd.

-s	If this switch is used a symbol file is created.
	This file contains all the labels and their addresses.
	The extention of this file is .sym.

-u	Convert any uppercase in the source file to lowercase.
	This option is usefull in processing code written for other assemblers
	that require the special function operators and instructions in
	uppercase.



Switches and source filename may appear anywhere in the commandline.

If you have too many files open at the same time,the assembler will abort with an error message.
(This is for CPM only, due to limitations of the compiler used.)

If you leave out the source file name, the assembler will also abort with an error message.


LABELS
	Labels may be up to 20 characters long, and MUST start with a to z,
	or A to Z.
	Uppercase and lowercase is treated as different.
	Labels must end with : (That defines the label)
	A maximum of 500 labels is allowed in the source file.

Examples of labels are:
	label1:
	LaBeL_#$@&%*!:
	q}[]\|?/.><:
	a55:
	UPPERCASELABEL
+ - ` and tabs and spaces as well as CR LF are not allowed in labels.


THE EQU STATEMENT

	If equ is used, an internal flag is set in the assembler,
	and every field is checked for the text in the equ statement.
	Not using equ slightly increases assembly speed, but if equ is used
	once or more, this advantage is lost.
	Equ defenitions may appear anywhere in the source file, and redefining
	equ is possible.
	The equ statement operates field orientated, this means that you can
	define an expression with an equ statement, but you cannot use equ
	in an expression.
	A maximum of 256 equ statements is allowed per sourcefile.

exemples of equ statements are:

SOMEWHERE	equ	biglabel+1+&01+$22
biglabel must be defined somewhere.

CR	equ	#$0d
Note that the # (immediate data) symbol MUST be placed in the equ defenition.

ld equ mov
For those used to z80's.

This means it is possible to define your own mnemonics.
See the demofile for the correct use of equ.


EXPRESSIONS
	Arithmatic expressions may contain:
	+	(sum)
	-	(minus)
	'x'	(where the ascii value of character x is substituted)
	labels	(the address value of the label is substituted)
	$	(this indicates that the following characters represent hex.)
	&	(this indicates that the following characters represent bin.)
	Any number 0 to 65535 inclusive not preceded by $ or & is taken for dec.
	All the previous described may be combined to a maximum field length
	of 20 characters.


SPECIAL FUNTION OPERATORS

	Special function operators:
	All Intel special function registers, bit addresses and byte addresses
	are supported, that were known to me at the time of writing the
	assembler.
	These symbols MUST be in lower case.
	If you have an uppercase source file the -u switch can be used.


THE DATA STATEMENTS
	The 'd' statements:
	dw expression   (reserves space for 2 bytes in the output file,
			The first is the low byte the second the high byte of
			the expression, which after evaluation must be between
			0 and 65525 inclusive.)

	db expr.(0),expr.(1),expr.(2),__,___,expr.(n)
			(reserves space for n bytes,n must be between 1 and 14.
			The result of the expression must be <256.)

	ds 'any ascii text'
			(stores the ascii value of the text string between
			' and ' in the assembled code at location program-
			counter.
			CR and LF are not allowed,but can be substituted for 
			by db 10,13.
			The max length of the text string is 19 bytes.)



ERROR MESSAGES


Errors are reported at the beginning of every line they are detected.
Errors in labels and equ statements and command line errors are reported in
pass one, and completely described.
The assembler may abort if the error is such that further assembly is
not practical.(such as OUT OF SYMBOL SPACE)

Errors in pass 2 are indicated by a character in uppper case, in the left margin.

	The error messages are:
	A	incorrect bit address, either not bit 0 to 7 inclusive, or
		not data register address 20 hex to 2f hex inclusive or both.
	B	a binary number was specified using &, but this is not 0 or 1
	D	a decimal number was expected by default, but this is not 0 to
		9 inclusive.
	E	cannot evaluate expression.	
	H	a hexadecimal number was specified using $, but this is not 0
		to 9 inclusive or a to h inclusive.
	O	opcode error, this instruction is not recognised by the
		assembler.(spelling?).
	R	relative jump out of range.
	U	undefined label.
	V	the value of the field after evaluation was >255, but only 255
		is allowed as maximum here.

The error counter:

At the end of assembly (if there was no abort) the assembler will report the number of errors found.
This may be a higher number then the count of source file lines that were flagged as errors.
The reason for this is that the assembler only reports the last error found in every line.
If you assemble the source again a different error may now be reported on the same line.

DO NOT TRY TO RUN YOUR CODE UNTIL YOU HAVE A 0 ERRORS REPORT,IT MAY CONTAIN ERRORS AND CRASH!

