/*
a52 (c) 28-12-1988-always Jan Panteltje

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


/* 8052 ASSEMBLER */


#include "a52.h"

main(argc,argv)
int argc; char *argv[]; 
{
FILE *rfile();
FILE *wfile();
static int g,h;
int a,b,c,d,i,i1,basrufl,org1fl,fileco,srcfifl;
unsigned int org1;
/* the source file flag, set if any arg that does not start with - is copied\
 to tg */
struct equtab *pa;

fileco=1;/* the file counter, at least one file, the input file. */
srcfifl=0;
basrufl=0;
org1fl=0;
printf("\n8052 ASSEMBLER VERS. %s\n\
copyright 28-12-1988\t Jan Panteltje.\n", PROG_VERSION);

	if(argc < 1) {
		printf("Usage: a52 sourcefile [options]\n"); 
		 }
	for(i=1;i<argc;i++)
		{
		if(argv[i][0]=='-')
			{
			if(argv[i][1]=='b')
				{
				fileco++;
				basfifl=1;
				for(i1=0;i1<20;i1++)
					{
					if(argv[i][i1+2]==0)break;
					else ab[i1]=argv[i][i1+2];
					}
					ab[i1]=0;
				basli=atoi(ab);
				}
			else if(argv[i][1]=='l')
				{
				fileco++;
				listfl=1;
				}
			else if (argv[i][1]=='s')
				{
				fileco++;
				symfl=1;
				}
			else if(argv[i][1]=='u')
				{
				uppfl=1;
				}
			else if(argv[i][1]=='h')
				{
				fileco++;
				hexfifl=1;
				}
			else if(argv[i][1]=='i')
				{
				fileco++;
				intefl=1;
				}
			else if(argv[i][1]=='r')
				{
				basrufl=1;
				}
			}
		else
			{
			if(!srcfifl)
				{
				strcpy(tg,argv[i]);
				strcpy(tj,argv[i]);
				}

			srcfifl=1;
		/* the first argument not preceded by a minus sign it is taken for the source file */
			}
		}
	if(!srcfifl)
		{
		printf("\n\nABORTED\tNO SOURCE FILE SPECIFIED\n");
		exit(0);
		}
	extfl=0;
	for(i=0;i<20;i++)
		{
		if(tg[i]==0)break;
		if(tg[i]=='.'){extfl=1;break;}
		td[i]=tg[i];
		te[i]=tg[i];
		tf[i]=tg[i];
		th[i]=tg[i];
		ti[i]=tg[i];
		}
	tg[i]=0;
	td[i]=0;
	te[i]=0;
	tf[i]=0;
	th[i]=0;
	ti[i]=0;

	if(extfl)f1=rfile(tj);
	else
		{
		strcat(td,".asm");
		f1=rfile(td);
		}
	if (basfifl)
		{
		strcat(te,".bas");
		}
	if(symfl)
		{
		strcat(tf,".sym");
		f3=wfile(tf);
		}
	if(hexfifl)
		{
		strcat(th,".hxd");
		}
	if(intefl)
		{
		strcat(ti,".hex");
		}
/********************************PASS 1**********************************/
pass=1;
errors=0;
codbyt=0;
while ((fields=split())!=-1)
	 {
	if(labfl&&fields)
		{
		if(symfl)tosymtab();
		if((isreg(0)!=-1)||(issfr(0)!=-1)||(isbit(0)!=-1))
			{
			printf("\nLINE %d\tLABEL %s:\t\t\tRESERVED SYMBOL",licnt,oper[0]);
			errors+=1;
			}
		if((a=stolab(0))==-1)
			{
			printf("\n\nLINE %d\tLABEL %s:\t\t\tABORTED  OUT OF SYMBOL SPACE",licnt,oper[0]);
			if(symfl)fclose(f3);
			exit(0);
			}
			
		if(a==-2)
			{
			printf("\nLINE %d\tLABEL %s:\t\t\tPREVIOUSLY DEFINED",licnt,oper[0]);
			errors+=1;
			}
		if(a==-3)
			{
			printf("\nLINE %d\tLABEL %s:\t\t\tTOO LONG",licnt,oper[0]);
			errors+=1;
			}
		if(a==-4)
			{
			printf("\nLINE %d\tLABEL %s:\t\t\tILLEGAL FIRST CHARACTER",licnt,oper[0]);
			errors+=1;
			}
		}
	else if((!labfl)&&(fields>0))
		{
		if(oper[1][0]=='e')
			{
			if(strcmp(oper[1],"equ")==0)
				{
				if(! install(oper[0], oper[2]) )
					{
					printf("\n\nLINE %d\t%s\tEQU\t%s\t\t\tABORTED  OUT OF SYMBOL SPACE",licnt,oper[0], oper[2]);
					if(symfl)fclose(f3);
					exit(0);
					}
				equfl=1;
				goto noal;
				}
			}
		al52();
		noal: ;
		}
	}/*end while fields=split() */

/*******************************PASS 2***********************************/
pass=2;
licnt=0;
pc=0;
codbyt=0;
fclose(f1);
if(basfifl)
	{
	f2=wfile(te);
	forgfl=0;
	fprintf(f2,"\n%u rem code from %s\n",basli,tg);
	basli+=2;
	if(basrufl)
		{
		fprintf(f2,"%u restore\n",basli);
		basli+=2;
 		}
	}
if(hexfifl)
	{
	f4=wfile(th);
	hrecofl=0;
	hreclen=0;
	}
if(intefl)
	{
	f5=wfile(ti);
	irecofl=0;
	ireclen=0;
	}
if(extfl){f1=rfile(tj);}
else 
	{
	f1=rfile(td);
	}
while((fields=split())!=-1)
	{
	lierfl=0;
	pco=pc;
	if((!labfl)&&(fields>0))
		{
		if(oper[1][0]=='e')
			{
			if(strcmp(oper[1],"equ")==0)goto noal2;
			}
		if(equfl)
			{
			for(i=0;i<fields;i++)
				{
/*				if((pa = lookup(oper[i]))!=NULL)*/
				pa = (struct equtab *)lookup(oper[i]);
				if(pa)
					{
					strcpy(oper[i],pa->replac);
					}
				}
			}
		al52();
		noal2: ;
		pci=pc-pco;
		if(basfifl)
			{
			if(orgfl)
				{
				if(forgfl)fornex();
				forgfl=1;
				orgval=pc;
				if(basrufl)
					{
					if(!org1fl)org1=pc;
					org1fl=1;
					}
				}
			if((pci>0)&&(!orgfl))
				{
				fprintf(f2,"%u data ",basli);
				basli+=2;
				for(i=0;i<pci;i++)
					{
					fprintf(f2,"%u",o[i]);
					if(i!=(pci-1))fprintf(f2,",");
					codbyt++;
					}
				fprintf(f2,"\n");
				}
			}
		if(intefl)
			{
			if(orgfl)
				{
				irectyp=0x01;
				if(irecofl)irecpri();
				irecofl=1;
				irecadd=pc;
				}
			else if(pci>0)
				{
				for(i=0;i<pci;i++)
					{
					irecdat[ireclen]=o[i];
					ireclen++;
					if(ireclen==16)
						{
						irecpri();
						irecadd+=16;
						}
					}
				}
			}
			if(hexfifl)
			/* normal hex file */
				{
				if(orgfl)
					{
					if(hrecofl)hrecpri();
					hrecofl=1;
					hrecadd=pc;
					}
				else if(pci>0)
					{
					for(i=0;i<pci;i++)
						{
						hrecdat[hreclen]=o[i];
						hreclen++;
						if(hreclen==16)
							{
							hrecpri();
							hrecadd+=16;
							}
						}
					}
				}
		}/*end ((!labfl)&&( fields>0)) instruction processing*/
	if((listfl)||(lierfl))
		{
		printf("\n");
		if(lierfl)printf("%c",error);
		if((!labfl)&&(fields>0))
			{
			if(strcmp(oper[1],"equ")==0)
				{
				printf("\t%5u\t%04x\t\t\t\t%s %s %s",licnt,pc,oper[0],oper[1],oper[2]);
				goto enerli;
				}
			printf("\t%5u\t",licnt);
			printf("%04x\t",pco);
			}
		else
			{
			printf("\t%5u\t",licnt+1);
			printf("%04x\t",pc);
			}

		for(i=0;i<6;i++)
			{
			if((!labfl)&&(fields>0)&&(i<pci))printf("%02x ",o[i]);
			else printf("   ");
			}
		if((labfl)&&(fields==1)){printf("\t%s:",oper[0]);}
		else printf("\t%s ",oper[0]);
		for(i=1;i<fields;i++)
			{
			printf("%s",oper[i]);
			if(i<(fields-1))printf(",");
			}
		enerli: ;
		}/* end errors and listfile */	
	}/*end while split()*/
if(basfifl)
	{
	fornex();
	if(basrufl)
		{
		fprintf(f2,"%u call %u\n",basli,org1);
		}
	else
		{
		fprintf(f2,"%u\treturn\n",basli);
		}
	fclose(f2);
	}
if(symfl)
	{
	fclose(f3);
	}
if(hexfifl)
	{
	hrecpri();/* the last data */
	fclose(f4);
	}
if(intefl)
	{
	a=ireclen;/* save the length */
	irecpri();/* the last record containing data */
	irecadd+=a;
	irectyp=0x01;/* end of file auto start? */
	irecpri();/* the empty record indicates end of file */
	fclose(f5);
	}
printf("\nASSEMBLY COMPLETE\n%u\tERRORS",errors);
exit(0);
}

/*****************************end main******************************/

FILE  *rfile(fname)
char *fname;
{
FILE *i;
i=fopen(fname,"r");
if (i>0) return i;
printf("Can't open: %s\n",fname);
exit(0);
}


FILE *wfile(fname)
char *fname;
{
FILE *i;
i = fopen(fname,"w");
if (i > 0) return i;
printf("Can't open: %s\n",fname);
exit(0);
}


getbyte()
{
int a;
a=getc(f1);
if(a==EOF)exit(0);
return a;
}

split()
{
int a,b,z,i,j,sptbfl,commentfl,dsfl;
b=0;
z=0;
sptbfl=0;
for(j=0;j<MAXFIELDS;j++)
	{		
	commentfl=0;
	dsfl=0;
	for(i=0;i<FIELDL;i++)
		{
	gb:	a=getc(f1);
		if(uppfl)a=ztolower(a);
		if(a==EOF)return -1;
		if(a==10)licnt++;
		if(a==10||a==13)
				{
				commentfl=0;
				dsfl=0;
				}
		if(!dsfl)
			{
			if(a==';')
				{
				commentfl=1;
				if((sptbfl)&&(j>0))z= -1;
				}
			if(commentfl)
				{
				goto gb;
				}
			if((a==39)&&(i==0))/*the first character is ' */
				{
				dsfl=1;
				}
			if(a==9||a==' ')
					{
					if((sptbfl)||(i==0))goto gb;
					sptbfl=1;
					break;
					}
			sptbfl=0;
			if(a==','||a==10||a==13||a=='`')break;
			if(a==':'){labfl=1;break;}
			}
		if(dsfl)
			{
			if((a==39)&&(i>0))
				{
				dsfl=0;
				}
			}
		labfl=0;																																																																																																																																																														
		b=1;
		oper[j][i]=a;
		}/* end for all characters in a field */
		oper[j][i]=0;
	if(a==':'||a==10||a==13||a=='`')break;
	}/* end for all fields */
return j+b+z;
}


tosymtab()
{
fprintf(f3,"\n%04x\t%s:",pc,oper[0]);
}


fornex()
/*This function makes a basic for next loop that pokes the data bytes\
into ram at the previous value of org , length codbytes.*/
	{
	fprintf(f2,"%u\torg=%u\n",basli,orgval);
	basli+=2;
	fprintf(f2,"%u\tfor i=0 to %u\n",basli,codbyt-1);
	codbyt=0;
	basli+=2;
	fprintf(f2,"%u\tread a:xby(org+i)=a:next\n",basli);
	basli+=2;
	}


irecpri()
{
int i,sumbytes,checksum;
fprintf(f5,"\n:%02x%04x%02x",ireclen,irecadd,irectyp);
sumbytes=ireclen+highbyte(irecadd)+lowbyte(irecadd)+irectyp;
for(i=0;i<ireclen;i++)
	{
	fprintf(f5,"%02x",lowbyte(irecdat[i]));
	sumbytes=sumbytes+lowbyte(irecdat[i]);
	}
checksum=0-lowbyte(sumbytes);
/*the low byte of the sum of all the bytes including the checksum must be 0 */
fprintf(f5,"%02x",lowbyte(checksum));
ireclen=0;
}


hrecpri()
{
int i;
fprintf(f4,"\n%04x\t",hrecadd);
for(i=0;i<hreclen;i++)
	{
	fprintf(f4,"%02x ",lowbyte(hrecdat[i]));
	}
hreclen=0;
}


highbyte(a)
unsigned int a;
{
a=a/256;
return a;
}


lowbyte(a)
unsigned int a;
{
a=a-256*(a/256);
return a;
}


ztolower(c)
char   c;
{
if(('A' <=  c) && (c <=  'Z'))return c + 0x20;
return c;
}


zindex(s,t)
char s[],t[];
{
int i,j,k;
for(i=0;s[i] != '\0';i++)
	{
	for(j=i,k=0;t[k] != '\0' &&  s[j] ==  t[k];j++,k++)
	;
	if(t[k] == '\0')return i;
	}
return -1;
}

