/* -*- c++ -*-
   Map source file and line number to counters */

#pragma interface

#include <string>

class sourcefile {
    string filename;
    unsigned int numlines;	// Number of lines in file + 1
    int* lines;			// Array of number of ticks
    int dummy;
    time_t _mtime;
    bool lineswarned;
    // Make sure we cannot assign/copy by making these private
    sourcefile();
    sourcefile& operator=(const sourcefile &);
    sourcefile(const sourcefile &);
  public:
    sourcefile(string, int);
    ~sourcefile();
    int& operator[](unsigned int);
    void paste(string = ".bprof") const;
    time_t mtime() const;
    const int reallyflag = 1 << 0; // Use this source file
    const int verboseflag = 1 << 1; // Print this source file name
};

typedef sourcefile* sfpnt;

class dir {
    dev_t dev;
    ino_t ino;
    const dev_t invalid = 0;	// Can dev_t never be 0 ???
  public:
    dir(const char*);
    class less {
      public:
	bool operator()(const dir&, const dir&) const;
    };
    bool valid() const { return dev != invalid; };
};
