/* -*- c++ -*- */

#pragma interface

#include <time.h>
#include <sys/types.h>
#include <bfd.h>

class executable {
    bfd* thisbfd;		// bfd object of executable
    asection* textsec;		// .text section
    caddr_t textstart;
    asymbol** syms;		// Symbols
    static int bfdinited;	// Has bfd_init() been called?
    static void findtext(bfd*, asection*, PTR);
  public:
    executable(const char*);
    ~executable();
    int find_line(caddr_t, const char**, unsigned int*);
    time_t mtime() { return bfd_get_mtime(thisbfd); };
};
