#include <iostream.h>

#pragma implementation
#include "execute.h"

// Callback routine to match section names in order to find the text section

void executable::findtext(bfd*, asection* sect, PTR thisexec)
{
    if (!strcmp(sect->name, ".text")) {
	static_cast<executable*>(thisexec)->textsec = sect;
    }
}

int executable::bfdinited = 0;

executable::executable(const char* filename)
{
    if (!bfdinited) {
	bfd_init();
	bfdinited = 1;
    }

    thisbfd = bfd_openr(filename, 0);
    if (!thisbfd) {
	bfd_perror(filename);
	exit(1);
    }

    if (!bfd_check_format(thisbfd, bfd_object)) {
        bfd_perror("bfd_check_format");
        exit(1);
    }

    bfd_map_over_sections(thisbfd, findtext, this);
    textstart = static_cast<caddr_t>(textsec->vma);
    
    long int symsize = bfd_get_symtab_upper_bound(thisbfd);
    if (!symsize) {
	cerr << "No symbols found!\n";
	exit(1);
    }

    syms = static_cast<typeof(syms)>(new char[symsize]);
    if (!syms) {
	cerr << "Could not allocate space for symbols!\n";
	exit(1);
    }

    bfd_canonicalize_symtab(thisbfd, syms);
}

executable::~executable()
{
    delete[] syms;
    if (!bfd_close(thisbfd)) {
	bfd_perror("bfd_close");
    }
}

int executable::find_line(caddr_t eip, const char** filename, unsigned int* line)
{
    const char* func;		// Assigned to by find_nearest_line, but not used;
    return bfd_find_nearest_line(thisbfd, textsec, syms, eip - textstart, filename, &func, line);
}
