.TH BPROF 1 "16 April 1997" "" "Version 2.0"
.SH NAME
bprof \- profile per source line
.SH SYNOPSIS
\fBbprof\fP [\fIoptions\fP] [\fIexecutable\fP [\fIbmon.out\fP ... ] ]
.SH DESCRIPTION
\fBbprof\fP makes an execution profile per source line of your
program.  In other words, it gives you the time spent in each line of
your program.  This allows you to know precisely on what part of the
program to spend your efforts at speeding it up.

To get such a profile, compile your program with \-g and link it with
the object file \fCbmon.o\fP.  Make sure that the \fCbmon.o\fP file is
linked immediately after your .o files, before any system libraries.
Example:
.nf
\fC
gcc -g -c foo.c
gcc -g -c bar.c
gcc -o fubar foo.o bar.o @LIBDIR@/bmon.o -lm
\fP
.fi
You can specify optimization flags.  This will give you a better
estimate of the program behaviour when it is optimized, but it can
make the data hard to interpret as the relation between source and
object code can be obscure.

Running the program should produce a file \fBbmon.out\fP in the
current directory (that is the current directory of the program at the
moment it exits).  Now run \fBbprof\fP on your executable.  This
should produce files \fCfoo.c.bprof\fP and \fCbar.c.bprof\fP which are
the same as the corresponding source files, but have the time spent in
each line prepended to that line.  A '\fC\.\fP' in the output
indicates a line where no measurable time was spent.

Time spent is measured in clock ticks, so in 1/100 of a second.  As
timing statistics are taken stochastically by recording the current
instruction at each clock tick, these numbers are not exact and can
vary from one run to another.  Note that a source file that does not
get any clock tick will not have a \fC.bprof\fP file created.

A note for C++ users: Initialization and cleanup of timing is done in
the constructor and destructor of a static C++ object.  Because C++
does not define the order of execution of constructors and destructors
of static objects in different compilation units, time spent in those
may or may not be taken into account.

The first non-option argument given will be taken as the name of the
executable (default: a.out).  Any further arguments are interpreted as
the names of bmon.out files (default: bmon.out).  If you specify more
such files \fBbprof\fP takes the sum of the timings of these files.
.SH OPTIONS
.TP
.BI "\-d " directory
Also use any source files in \fIdirectory\fP to make profiles.  You
can use multiple \fB\-d\fP flags for multiple directories.  The
current directory is always used.

Note that in any case source files will only be looked for by the full
path name they had at the moment of compilation.  If you have moved
them around since compilation, you need to recompile, move them back
or create a symlink somewhere.
.TP
.BI "\-s " suffix
Use \fIsuffix\fP instead of \fC.bprof\fP to add to the source file
names to get the output file names.
.TP
.B \-v
Verbose mode.  Print the names of all the source files used.
.SH ENVIRONMENT
.TP
.B BPROFDIR
If this variable is set, the program will write the bmon.out file in
that directory instead of the current directory of the program when it
exits.
.SH FILES
.TP
\fCbmon.out\fP
contains timing data
.TP
\fC@LIBDIR@/bmon.o\fP
object file to link with your programs to get timing data
.SH SEE ALSO
gprof(1)
.SH BUGS
Profiling will not be done while your program is blocking the VTALRM
signal.  If you use the VTALARM signal yourself, however, \fBbprof\fP
will not work anyway.
.SH AUTHOR
Bas de Bakker.  The latest version of \fBbprof\fP should be available
at sunsite.unc.edu in the directory /pub/Linux/devel.
