#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <iostream.h>
#include <cstdio>		// perror()

#pragma implementation
#include "bmonout.h"

void bmonout::xread(int fd, void* address, size_t size)
{
    while (size) {
	ssize_t ret = read(fd, address, size);
	if (ret == -1) {
	    perror("bprof");
	    exit(1);
	}
	address += ret;
	size -= ret;
    }
}

bmonout::bmonout(const char* file)
{
    int fd = open(file, O_RDONLY);
    if (fd == -1) {
	perror(file);
	exit(1);
    }

    struct stat flstat;		// Need struct to avoid confusion with stat().
    if (fstat(fd, &flstat) == -1) {
	perror(file);
	exit(1);
    }
    _mtime = flstat.st_mtime;

    bmonheader bmhead;
    xread(fd, &bmhead, sizeof(bmhead));
    if (bmhead.bmon_magic != BMON_MAGIC) {
	cerr << file << " is not a bmon.out file\n";
	exit(1);
    }
    
    numofitems = bmhead.numofitems;
    items = new bmonitem[numofitems];
    off_t neededsize = sizeof(bmonheader) + numofitems * sizeof(bmonitem);
    if (flstat.st_size != neededsize) {
	cerr << file << " has a wrong length\n";
	exit(1);
    }

    xread(fd, items, numofitems * sizeof(*items));
    
    close(fd);
}

bmonout::~bmonout()
{
    delete[] items;
}
