;
; NAME
;  AsmRef - display a collection of help files
; INPUTS
;  * AsmRef looks in the local directory for files
;  * and also in $HOME/.a
; OUTPUT
;  * menus are mouse aware and indicate the keys
;  * that trigger actions.
;  * The buffer button stores current page into
;  * asmedit's buffer.  This can be accessed by
;  * use of the "g" get command.
; NOTES
; * source file: asmref.asm
; * If AsmRef fails to find a document the button
; * or key press is ignored.  No error message is given.
; * ----------------------------------------------

  [section .text]

  extern blk_find
  extern crt_open,crt_close,crt_table
  extern mouse_enable,key_mouse1,kbuf,key_decode1,key_decode2
  extern cursor_to_table
  extern file_read_grow
  extern crt_columns,crt_rows,status_color2
  extern crt_mouse_line
  extern crt_window
  extern key_string1
  extern crt_set_color,crt_color_at
  extern mouse_line_decode
  extern file_write_close
  extern env_home,str_move,sys_launch
  extern file_status_name
  extern enviro_ptrs
  extern install_signals

browser_win_color	dd	31003334h		;bold yellow on blue
browser_menu_sp_color	dd	31003334h
browser_menu_but_color	dd	30003037h		;
match_highlight_color	dd	30003134h

;------ program start ----------
  global _start
  global main
_start:
main:
  mov	byte [exit_flag],0
  mov	ebp,esp			;enviro lp
lp1:				;enviro lp
  pop	eax			;enviro lp
  or	eax,eax			;enviro lp
  jnz	lp1			;enviro lp
  mov	[env_ptrs],esp	;enviro lp
  mov	esp,ebp			;enviro lp

  call	crt_open		;open the display and keyboard
  call	mouse_enable		;turn the mouse on
  call	signal_install		;install sig_WINCH, (screen resize)
lp2:
  mov	esi,select_menu
  call	crt_table		;display menu
  call	key_mouse1		;get user input

  cmp	byte [kbuf],-1		;check if mouse click
  je	h_mouse			;jmp if mouse click
  mov	esi,key_decode_table1
  call	key_decode1
  call	eax			;execute process
  jmp	lp1_end
;
; mouse click occured
;
h_mouse:
  mov	esi,select_menu
  mov	cl,[kbuf + 2]		;get cursor column
  mov	ch,[kbuf + 3]		;get cursor row
  call	cursor_to_table		;return table ptr in esi
  call	find_mouse_process	;return process in eax
  call	eax
lp1_end:
  cmp	byte [exit_flag],1
  jne	lp2			;loop back
help_exit:
  call	crt_close		;close the display and keyboard
  mov	eax,1			;exit function
  xor	ebx,ebx			;exit code
  int	80h
  ret

;----------------------------------------------
; input esi = table ptr.
; output eax = process to execute
find_mouse_process:
  dec	esi
  mov	al,[esi]
  or	al,al
  jns	find_mouse_process
;
  neg	al	;convert to positive value
  xor	ebx,ebx
  mov	bl,al
  shl	ebx,2
  add	ebx,m_table -4
  mov	eax,[ebx]	;get process
  ret


;----------------------------------------------
; treat any alpha key as exit request
alpha_key:
exit_key:
  mov	byte [exit_flag],1
  ret
;-----------------------
unknown_key:
  ret
;-----------------------
left_arrow:
  mov	esi,[selected_table_entry]
la_lp1:
  dec	esi
  cmp	esi,select_menu
  je	la_exit
  cmp	byte [esi],2			;look for previous color code
  jne	la_lp1				;loop till color code found
  call	set_new_selection
la_exit:
  ret
;-----------------------
right_arrow:
  mov	esi,[selected_table_entry]
ra_lp1:
  inc	esi
  cmp	esi,table_end
  je	ra_exit				;exit if at end of table
  cmp	byte [esi],2			;check for color code
  jne	ra_lp1				;loop till color found
  call	set_new_selection
ra_exit:
  ret
;-----------------------
down_arrow:
  mov	esi,[selected_table_entry]
  xor	edx,edx				;clear position indicator
da_lp1:
  inc	esi
  cmp	esi,table_end
  je	da_exit				;exit if at end of  table
  test	byte [esi],80h			;check if entry here
  jz	da_20				;jmp if not entry
  inc	edx				;count entries
da_20:
  cmp	byte [esi],9			;check for next line
  jne	da_lp1				;loop till end of line
  sub	dl,5
  not	dl
da_lp2:
  inc	esi
  cmp	esi,table_end
  je	da_exit				;exit if at end of table
  test	byte [esi],80h
  jz	da_40				;jmp if not process code
  dec	dl
da_40:
  cmp	byte [esi],2			;check for color code
  jne	da_lp2				;loop till color found
  cmp	dl,0
  jg	da_lp2
  call	set_new_selection
da_exit:
  ret
;-----------------------
up_arrow:
  mov	esi,[selected_table_entry]	;get current selection's color ptr
  xor	edx,edx				;clear position indicator
;scan back one selection
ua_lp1:
  dec	esi
  cmp	esi,select_menu
  je	ua_exit				;exit if at top
  test	byte [esi],80h			;check for process
  jz	ua_20				;jmp if not process
  inc	edx
ua_20:
  cmp	byte [esi],9			;check for end of line
  jne	ua_lp1				;loop till end of line found
  sub	dl,5
  not	dl
ua_lp2:
  dec	esi
  cmp	esi,select_menu
  je	ua_exit
  test	byte [esi],80h
  jz	ua_40				;jmp if not process code
  dec	dl
ua_40:
  cmp	byte [esi],2			;look for previous color code
  jne	ua_lp2				;loop till color code found
  cmp	dl,0
  jg	ua_lp2
;--- entry point 
set_new_selection:
  mov	byte [esi],4			;highlight this entry
  mov	edi,[selected_table_entry]
  mov	byte [edi],2			;unhighlight previous selection
  mov	[selected_table_entry],esi	;save new selection pointer
ua_exit:
  ret  
;-----------------------
enter_key:
  mov	eax,[selected_table_entry]
  dec	eax				;point at process
  xor	ebx,ebx
  dec	ebx				;set ebx = -1
  mov	bl,[eax]			;get process number (negative)
  neg	ebx
  dec	ebx				;convert to zero based
  shl	ebx,2				;convert to dword index
  add	ebx,m_table			;index into table
  jmp	[ebx]
;-----------------------


;-----------------------
call_names	;-1 call name index
  mov	ebp,_name_calls
  jmp	do_browse
;-----------------------
access_calls	;-2 access
  mov	ebp,_access
  jmp	do_browse
;-----------------------
ascii_codes	;-3 ascii
  mov	ebp,_ascii
  jmp	do_browse
;-----------------------
asmmgr		;-4 asmmgr
  mov	ebp,_asmmgr
  jmp	do_browse
;-----------------------
call_numbers	;-5 call number index
  mov	ebp,_numeric_calls
  jmp	do_browse
;-----------------------
file_calls	;-6 file
  mov	ebp,_file
  jmp	do_browse
;-----------------------
utilities	;-7 utilities
  mov	ebp,_utility
  jmp	do_browse
;-----------------------
asmref		;-8 asmref
  mov	ebp,_asmref
  jmp	do_browse
;-----------------------
call_topics	;-9
  mov	ebp,_topic_calls
  jmp	do_browse
;-----------------------
ioctl_call	;-10
  mov	ebp,_ioctl
  jmp	do_browse
;-----------------------
vt_term		;-11
  mov	ebp,_vt_term
  jmp	do_browse
;-----------------------
asmplan		;-12
  mov	ebp,_asmplan
  jmp	do_browse
;-----------------------
;unknown_key	;-13 null process
; (see above)
;-----------------------
memory_calls	;-14
;-----------------------
x86_nasm_ref	;-15
  mov	ebp,x862_file
  jmp	do_browse
;-----------------------
asmlib_ref	;-16
  mov	ebp,lib_file
  jmp	do_browse
;-----------------------
proc_sys	;-17
  mov	ebp,_proc
  jmp	do_browse
;-----------------------
process_calls	;-18
  mov	ebp,_process
  jmp	do_browse
;-----------------------
x86_general_ref	;-19
  mov	ebp,x861_file
  jmp	do_browse
;-----------------------
asmedit_manual	;-20
  mov	ebp,manual_file
  jmp	short do_browse
;-----------------------
kernel_errors	;-21
  mov	ebp,err_file
  jmp	short do_browse
;-----------------------
signal_calls	;-22
  mov	ebp,_signal
  jmp	short do_browse
;-----------------------
;unknown_key	;-23 null process
; (see above)
;-----------------------
asmedit_quick	;-24
  mov	ebp,quick_file
  jmp	short do_browse
;-----------------------
kernel_includes	;-25
  mov	ebp,inc_file
  jmp	short do_browse
;-----------------------
system_calls	;-26
  mov	ebp,_system
  jmp	do_browse
;-----------------------
about  		;-27
  mov	ebp,_about
  jmp	do_browse
;-----------------------
;asmedit_tutor	;-28
; see below
;-----------------------
termios		;-29
  mov	ebp,_termios
  jmp	do_browse
;-----------------------
timing_calls	;-30
  mov	ebp,_timing
  jmp	do_browse
;-----------------------
asmbug		;-31
  mov	ebp,_asmbug
  jmp	do_browse
;-----------------------
asmfunc		;-32
  mov	ebp,_asmfunc
  jmp	do_browse
;-----------------------
structures	;-33
  mov	ebp,_structures
  jmp	do_browse
;-----------------------
undoc		;-34
  mov	ebp,_undoc
  jmp	do_browse
;-----------------------
;		;-35
;  mov	ebp,_about
;  jmp	do_browse
;-----------------------
asmpub		;-36
  mov	ebp,_asmpub
  jmp	do_browse
;-----------------------
;exit_key	;-37
; (see above)

do_browse:
  call	file_browser
  ret
;--------------------
asmedit_tutor:
  mov	edi,ebuf
  mov	esi,editor_name
  call	str_move
  mov	al,' '
  stosb
;
; check for local copy of file
;
  push	edi
  mov	ebx,tutor1
  call	file_status_name
  pop	edi
  js	at_not_here
;
; we have found local tutor files
;
  mov	esi,tutor1
  call	str_move
  mov	al,' '
  stosb
  mov	esi,tutor2
  call	str_move
  jmp	launch_tutor
;
; look for file at $HOME/.a
;
at_not_here:
  mov	ebx,[env_ptrs]
  call	env_home	;find home
  mov	al,'/'
  stosb
  mov	esi,base_name
  call	str_move
  mov	al,'/'
  stosb
  mov	esi,tutor1
  call	str_move
  mov	al,' '
  stosb

  push	edi			;save ptr to full path of tutor2
  mov	ebx,[env_ptrs]
  call	env_home	;find home
  mov	al,'/'
  stosb
  mov	esi,base_name
  call	str_move
  mov	al,'/'
  stosb
  mov	esi,tutor2
  call	str_move

  pop	ebx
  call	file_status_name
  js	at_also_not_here

launch_tutor:  
  mov	eax,[env_ptrs]
  mov	[enviro_ptrs],eax
  mov	eax,ebuf	;ptr to executable
  mov	ebx,base_name
  call	sys_launch
at_also_not_here:
  ret
;----------------------------------------------
signal_install:
  mov	ebp,signal_table
  call	install_signals
  ret

signal_table:
  db	28
  dd	winch_signal
  dd	0
  dd	0
  dd	0
  db	0		;end of install table

winch_signal:
  call	crt_close
  call	crt_open	;get new screen size
  ret
;----------------------------------------------
  [section .data]

_about		db	'about',0
_access		db	"_access",0
_ascii		db	"ascii",0
_asmbug		db	"asmbug",0
_asmfunc	db	"asmfunc",0
_asmmgr		db	"asmmgr",0
_asmplan	db	"asmplan",0
_asmpub		db	"asmpub",0
_asmref		db	"asmref",0
_file		db	"_file",0
_name_calls	db	"indexed_names",0
_numeric_calls db	"indexed_numerically",0
_topic_calls	db	"indexed_topic",0
_ioctl		db	"_ioctl",0
_memory		db	"_memory",0
_process	db	"_process",0
_proc		db	"proc",0
_signal		db	"_signal",0
_structures	db	"structures",0
_system		db	"_system",0
_termios	db	"termios",0
_timing		db	"_timing",0
_undoc		db	"_undoc",0
_utility	db	"utility",0
_vt_term	db	"vt_term",0

manual_file:  db  "asmedit",0			;was a.hlp
lib_file:     db  "asmlib.txt",0
inc_file:     db  "includes",0
quick_file:   db  "a_quick.txt",0
err_file:     db  "syserr.txt",0
x861_file:    db  "x86_ref.txt",0
x862_file:    db  "x86_nasm.txt",0
tutor1:	      db  "tutor1",0
tutor2:	      db  "tutor2",0
editor_name:  db  "a",0
base_name:    db  ".a",0

m_table:
  dd	call_names	;-1 call name index
  dd	access_calls	;-2 access
  dd	ascii_codes	;-3 ascii
  dd	asmmgr		;-4 asmmgr
  dd	call_numbers	;-5 call number index
  dd	file_calls	;-6 file
  dd	utilities	;-7 utilities
  dd	asmref		;-8 asmref
  dd	call_topics	;-9
  dd	ioctl_call	;-10
  dd	vt_term		;-11
  dd	asmplan		;-12
  dd	unknown_key	;-13 null process
  dd	memory_calls	;-14
  dd	x86_nasm_ref	;-15
  dd	asmlib_ref	;-16
  dd	proc_sys	;-17
  dd	process_calls	;-18
  dd	x86_general_ref	;-19
  dd	asmedit_manual	;-20
  dd	kernel_errors	;-21
  dd	signal_calls	;-22
  dd	unknown_key	;-23 null process
  dd	asmedit_quick	;-24
  dd	kernel_includes	;-25
  dd	system_calls	;-26
  dd	about		;-27
  dd	asmedit_tutor	;-28
  dd	termios		;-29
  dd	timing_calls	;-30
  dd	asmbug		;-31
  dd	asmfunc		;-32
  dd	structures	;-33
  dd	undoc		;-34
  dd	unknown_key	;-35
  dd	asmpub		;-36
  dd	exit_key	;-37


key_decode_table1:
  dd	alpha_key

  db   1bh,0			;esc
  dd   exit_key

    db	1bh,5bh,44h,0		;left arrow
  dd	left_arrow		;left arrow process

    db 1bh,5bh,43h,0		;pad_right
  dd	right_arrow

    db 1bh,5bh,41h,0		;pad_up
  dd	up_arrow

    db 1bh,5bh,42h,0		;pad_down
  dd	down_arrow

    db 0dh,0			;enter key
  dd	enter_key

    db 0ah,0			;enter key
  dd	enter_key

  db   0
  dd   unknown_key

    
;---------------
  db  -1	;trap to catch errant mice
select_menu:
mline01:   db  1,'KERNEL INDEX     KERNEL CALLS        PROGRAMMING     AsmIDE family ',9
mline02:   db  1,'------------     ------------        -----------     -------------',9	;blank line
mline03:   db  1,-1
initial_selection db 4,'call names',1,'         ',-2,2,'access',1,'              ',-3,2,'ascii',1,'              ',-4,2,'AsmMgr',1,9
mline04:   db  1,9	;blank line                                                                                                       
mline05:   db  1,-5,2,'call numbers',1,'       ',-6,2,'file',1,'                ',-7,2,'utilities',1,'          ',-8,2,'AsmRef',1,9
mline06:   db  1,9	;blank line                                                                                                       
mline07:   db  1,-9,2,'call topics',1,'        ',-10,2,'ioctl',1,'               ',-11,2,'vt-term',1,'            ',-12,2,'AsmPlan',1,9
mline09:   db  1,9	;blank line                                                                                                       
mline10:   db  1,-13,1,'KERNEL DATA',1,'        ',-14,2,'memory',1,'              ',-15,2,'x86-nasm',1,'           ',-16,2,'AsmLib',1,9
mline11:   db  1,'------------',9	;blank line                                                                                                       
mline12:   db  1,-17,2,'/proc',1,'              ',-18,2,'process',1,'             ',-19,2,'x86-ref',1,'            ',-20,2,'AsmEdit',1,9
mline13:   db  1,9	;blank line                                                                                                       
mline14:   db  1,-21,2,'errors',1,'             ',-22,2,'signals',1,'           ',-23,1,'AsmIDE family',1,'        ',-24,2,' -quick-ref',1,9
mline15:   db  1,'                                     -------------',9	;blank line                                                                                                       
mline16:   db  1,-25,2,'includes',1,'           ',-26,2,'system',1,'              ',-27,2,'about',1,'              ',-28,2,' -tutor',1,9
mline17:   db  1,9	;blank line                                                                                                       
mline18:   db  1,-29,2,'termios',1,'            ',-30,2,'timing',1,'              ',-31,2,'AsmBug',1,'             ',-32,2,'AsmFunc',1,9
mline19:   db  1,9	;blank line                                                                                                       
mline20:   db  1,-33,2,'structures',1,'         ',-34,2,'undoc',1,'               ',-35,2,'     ',1,'              ',-36,2,'AsmPub',1,9
mline21:   db  1,9	;blank line                                                                                                       
mline22:   db  'Select topics with mouse or arrow keys.',-37,2,'ESC key',1,' will exit any window',9
  db  5,0	;end of table
table_end:

selected_table_entry	dd	initial_selection	;points at color code
;----------------------------------------------
  [section .text]

fb_error:
  ret
;
; input:  ebp = filename ptr
;
file_browser:
  mov	esi,ebp
  mov	edi,data_append
  call	str_move	;form alternative address for data file
;
; look in $HOME/.asmide/doc/
;
  mov	ebp,data_path
  mov	ecx,fbuf
  mov	edi,fbuf_end
  mov	edx,fbuf
  mov	dword [last_match_ptr],edx	;needed later by search function
  mov	al,2
  mov	ebx,[env_ptrs]
  call	file_read_grow
  jns	fb_setup			;jmp if file found
  js	fb_error
fb_setup:
  add	eax,fbuf
  mov	[file_end_ptr],eax
  mov	byte [pre_fbuf],0ah
  mov	byte [eax],0ah
  mov	dword [scroll],0
  mov	al,[crt_columns]
  mov	[c_win_cols],al
  mov	al,[crt_rows]
  dec	al
  mov	[c_win_rows],al
  mov	byte [c_start_row],1
  mov	byte [c_start_col],1
  mov	byte [highlight_match],0	;clear found highlight
;
; display file
;

display_lp1:
  mov	ebp,fbuf
display_lp2:
  mov	[display_top],ebp

  mov	esi,in_block
  call	crt_window
;
; highlight match if present
;
  cmp	byte [highlight_match],0
  je	fb_buttons
  call	light_match
  mov	byte [highlight_match],0	;turn off highlight
;
; add buttons and search string
;
fb_buttons:
  mov	ah,[crt_rows]
  mov	[str_row],ah		;save for string entry
  mov	ecx,[browser_menu_sp_color]	;space color
  mov   edx,[browser_menu_but_color]		;button color
  mov	esi,button_row1
  call	crt_mouse_line
;
; get find string
;
fb_ignore:
  mov	ebp,string_table
  call	key_string1
  mov	[str_adj],ah		;save cursor col
;
  cmp	byte [kbuf],-1		;check if mouse
  je	fb_mouse
fb_decode:
  mov	esi,key_decode_table3
  call	key_decode1
  call	eax			;returns -1 if done
  jmp	short fb_cont
fb_mouse:
  mov	esi,button_row1
  mov	edi,button_actions
  mov	bl,[kbuf+2]		;get mouse column
  call	mouse_line_decode
  jecxz fb_ignore
  call	ecx			;returns al= -1 to abort
fb_cont:
  cmp	al,-1
  je	fb_exit
  cmp	al,1
  je	display_lp1		;jmp if redisplay from top of file
  jmp	display_lp2		;jmp if ebp is redisplay ptr
fb_exit:
  ret
;--------------------
find:
  mov	ebp,[file_end_ptr]
  mov	esi,string_buf
  mov	edi,fbuf
  mov	edx,1		;forward search
  mov	ch,0dfh		;ignore case
  call	blk_find
  jc	not_found
  mov	[last_match_ptr],ebx
;
; scan to start of line
;
  mov	byte [highlight_match],1 
find1:
  cmp	byte [ebx -1],0ah
  je	find2		;jmp if at start of line
  dec	ebx
  jmp	short find1
find2:
  mov	ebp,ebx
  mov	al,2
  jmp	find_exit
not_found:
  mov	eax,[status_color2]
  mov	bl,1		;column for msg
  mov	bh,[crt_rows]	;row for msg
  mov	ecx,not_fnd_msg
  call	crt_color_at
  call	key_mouse1
  mov	al,1		;indicate not found
find_exit:
  ret
;----------------------
find_again:
  mov	ebp,[file_end_ptr]
  mov	esi,string_buf
  mov	edi,[last_match_ptr]
  inc	edi		;move past last match
  mov	edx,1		;forward search
  mov	ch,0dfh		;ignore case
  call	blk_find
  jc	not_found
  mov	[last_match_ptr],ebx
  jmp	short find1
;---------------------------------
; write current page to buffer
;
to_buffer:
  xor	ecx,ecx			;line counter
  mov	esi,[display_top]
tb_lp:
  cmp	esi,[file_end_ptr]
  je	tb_write		;jmp if at end of file
  lodsb
  cmp	al,0ah
  jne	tb_lp			;loop till end of line
  inc	ecx
  cmp	cl,[crt_rows]		;max display size
  jne	tb_lp			;loop till one page collected
tb_write:
  mov	ebp,[env_ptrs]
  mov	eax,[display_top]	;buffer
  sub	esi,eax			;compute length of write
  mov	ecx,esi			;length of write in ecx
  mov	ebx,buf_file_name
  mov	esi,2			;write to $HOME
  call	file_write_close
  mov	al,1
  ret  
;-----------------------
fb_up:
  mov	esi,[display_top]
  call	prev_line
  mov	ebp,esi
  mov	al,2    
  ret

;-----------------------
fb_down:
  mov	esi,[display_top]
  call	next_line
  mov	ebp,esi
  mov	al,2
  ret

;-----------------------
fb_right:
  inc	dword [scroll]
  mov	ebp,[display_top]
  mov	al,2
  ret

;-----------------------
fb_left:
  cmp	dword [scroll],0
  je	fb_left_exit
  dec	dword [scroll]
fb_left_exit:
  mov	ebp,[display_top]
  mov	al,2
  ret

;-----------------------
fb_pgup:
  xor	ecx,ecx
  mov	cl,[c_win_rows]
  mov	esi,[display_top]
fbp_lp:
  call	prev_line
  dec	ecx
  jnz	fbp_lp
  mov	ebp,esi
  mov	al,2
  ret

;-----------------------
fb_pgdn:
  xor	ecx,ecx
  mov	cl,[c_win_rows]
  mov	esi,[display_top]
fbpg_lp:
  call	next_line
  jc	at_bottom
  dec	ecx
  jnz	fbpg_lp
  jmp	fbpg_exit
at_bottom:
  call	prev_line
fbpg_exit:
  mov	ebp,esi
  mov	al,2
  ret  

;-----------------------
quit:
  mov	al,-1
  ret
;----------------------------------------------
; input: esi = ptr to line start
; output: esi = ptr to next line
;         carry = at top now
;        no-carry = not at top
;
prev_line:
  cmp	esi,fbuf
  jbe	pl_top
  dec	esi
  cmp	byte [esi -1],0ah
  jne	prev_line
  clc
  jmp	short pl_exit
pl_top:
  stc
pl_exit:
  ret
  
;----------------------------------------------
; input: esi = ptr to current line start
; output: esi = ptr to next line
;         carry = at bottom 
next_line:
  cmp	esi,[file_end_ptr]
  jae	nl_end		;jmp if at end
  lodsb
  cmp	al,0ah
  jne	next_line
  clc
  jmp	short nl_exit
nl_end:
  stc	
nl_exit:
  ret

;----------------------------------------------
light_match:
  mov	edi,[last_match_ptr]
  mov	esi,[display_top]
  xor	ebx,ebx
  mov	bl,[c_start_col]
  add	ebx,[scroll]
lm_lp:
  cmp	esi,edi
  je	lm_found
  lodsb
  cmp	al,9		;check for tab
  jne	lm_20		;jmp if not tab
lm_tab:
  inc	ebx
  test	bl,7
  jnz	lm_tab
  jmp	lm_lp  
lm_20:
  inc	ebx
  jmp	lm_lp
lm_found:
  sub	ebx,[scroll]		;remove scroll count
  mov	eax,[match_highlight_color]
  mov	bh,1			;assume match on row 1
  mov	ecx,string_buf
  call	crt_color_at
  ret  
;----------------------------------------------

button_row1:
 db 1,'F1 find ->',1,'                              ',1,'<- again f2',2,'buffer',2,'Quit f10',1,0
button_actions:
 dd  find, unknown_key, find_again, to_buffer, quit

not_fnd_msg:
  db ' ** String not found **  press any key to continue                      ',0

key_decode_table3:
  dd	unknown_key	;alpha key

  db 1bh,5bh,5bh,41h,0		;127 F1
  dd find

  db 1bh,5bh,5bh,42h,0		;128 f2
  dd find_again

  db 1bh,4fh,50h,0		;123 F1
  dd find

  db 1bh,4fh,51h,0		;123 F2
  dd find_again

  db 1bh,5bh,41h,0		;15 pad_up
  dd fb_up

  db 1bh,5bh,42h,0		;20 pad_down
  dd fb_down

  db 1bh,5bh,43h,0		;18 pad_right
  dd fb_right

  db 1bh,5bh,44h,0		;17 pad_left
  dd fb_left

  db 1bh,5bh,35h,7eh,0		;16 pad_pgup
  dd fb_pgup

  db 1bh,5bh,36h,7eh,0		;21 pad_pgdn
  dd fb_pgdn

  db 1bh,5bh,32h,31h,7eh,0	;11 f10
  dd quit

  db 1bh,0			;ESC
  dd quit

  db 0dh,0			;enter key
  dd find

  db 0		;enc of table
  dd unknown_key ;unknown key trap

  
;----------------------------------------------
  [section .data]

in_block:				;inputs for crt_window
color		dd	30003734h
display_top	dd	0
file_end_ptr	dd	0
scroll		dd	0
c_win_cols	db	0	;win columns
c_win_rows	db	0	;win rows
c_start_row	db	0
c_start_col	db	0

string_table:
  dd	string_buf	;ptr to string buffer
  dd	30		;max string len
  dd	browser_menu_but_color
str_row:
  db	0		;row
  db	13		;column
  db	0		;flag 1=allow 0a in string
str_adj:
  db	13		;initial cursor column

string_buf:  times 32 db 0

buf_file_name:
  db  '.asmide/edit/tmp.blk',0

data_path db '.asmide/doc/'
data_append times 20 db 0          
;----------------------------------------------
  [section .bss]
env_ptrs	resd	1
exit_flag	resb	1	;1=exit program

highlight_match resb	1	;0=no match 1=highlight match
last_match_ptr	resd	1	;last find ptr

ebuf		resb	600

pre_fbuf	resb	1
fbuf		resb	32000
fbuf_end	resb	1
