#!/bin/sh
export OS `uname -s`

rm -f memcheck.log dmalloc.log
uname -a

#set environment variables for strict heap memory checking
#on those systems that support it
case `uname -s` in
    Linux)
        export MALLOC_CHECK_=2
        ;;
    FreeBSD)
        export MALLOC_OPTIONS="AJU"
        ;;
    *)
        echo "unknown system"
        ;;
esac  

#enable dmalloc for those systems that support it      
DMALLOC_OPTIONS=debug=0xdf47d6b,inter=1,log=dmalloc.log
export DMALLOC_OPTIONS

./fntests.sh && ./test_lit.sh && ./test_int.sh && ./test_dbl.sh && echo "ALL TESTS PASSED"
