// Fibonacci Number Series
// Example of Recursion

#include <iostream>
#include <sstream>

// fibonacci series = 0, 1, 1, 2, 3, 5, 8, 13, 21 ...
// fibonacci (0) = 0
// fibonacci (1) = 1
// fibonacci (n) = fibonacci(n-1) + fibonacci(n-2);

unsigned long
fibonacci (unsigned long n)
{
  if (n > 1)
  {
      n = fibonacci(n-1) + fibonacci(n-2);
  }
  return n;
}

std::string &
fibonacci_series (unsigned long number, std::string &datastr)
{
  static std::stringstream
    datastream;

  datastream << "Fibonacci Series(" << number << ") ";

  for (int i=0; i<=number; i++)
  {
    if (i > 0)
    {
      datastream << ", ";
    }
    datastream << fibonacci(i);
  }

  datastr = datastream.str();
  return datastr;
}

int
main(int argc, char * argv[])
{
  int
    result = 0;

  unsigned long
      number = 0;

  std::string
      outputstr;

  if (argc < 2)
  {
    std::cout << "Fibonacci Calculator Syntax: <number>" << std::endl;
    result = argc;
  }
  else
  {
    number = atoi(argv[1]);

    if (number <= 36)
    {
      std::cout << fibonacci_series(number, outputstr) << std::endl;
    }
    else
    {
      std::cout << "Fibonacci Calculator: " << number << " too large" << std::endl;
      result = number;
    }
  }   
 
  return result;
}




