// Fibonacci Number Series
// Example of Recursion

// fibonacci series = 0, 1, 1, 2, 3, 5, 8, 13, 21 ...
// fibonacci (0) = 0
// fibonacci (1) = 1
// fibonacci (n) = fibonacci(n-1) + fibonacci(n-2);


class Fibonacci
{

  public static long
  fibonacci (long n)
  {
    if (n > 1)
    {
        n = fibonacci(n-1) + fibonacci(n-2);
    }
    return n;
  }

  public static void
  fibonacci_series (long number, StringBuffer datastr)
  {
     datastr.append("Fibonacci Series(" + number + ") ");

     for (int i=0; i<=number; i++)
     {
       if (i > 0)
       {
         datastr.append(", ");
       }
       datastr.append(fibonacci(i));
     }
  }

  public static void
  main(String args[])
  {
     int 
       results = 0;

     long
       number = 0;

     StringBuffer
       outputstr = new StringBuffer();

     if (args.length < 1)
     {
       System.out.println("Fibonacci Calculator Syntax: <number>");
       results = args.length;
     }
     else
     {
       number = Long.valueOf(args[0]).longValue();

       if (number <= 36)
       {
         fibonacci_series(number, outputstr);

         System.out.println(outputstr);
       }
       else
       {
         System.out.println("Fibonacci Calculator: " + number + " too large\n");
         results = (int)number;
       }
     }   
 
     System.exit(results);
   }

}









