// target.h
// specification for the target base class
//
// R. Mudge
// 09/10/1998

// Notes:  Turn on symbol TARGET_UNIT_TEST to test the component

#ifndef TARGET_H
#define TARGET_H

#include <iostream>
#include <string>

namespace Seahunt
{

enum TargetStatus 
{
  UNKNOWN,
  NO_DAMAGE,
  DAMAGE,
  DEAD,
  STATUS_MAX
};

// base class
class Target
{
  protected:
    enum CONSTANTS { MAX_ARMOR=5, MAX_DEPTH=1000 };

  public:
    Target( std::string name="Uninitialized" , 
            int armor = MAX_ARMOR, 
            int depth = MAX_DEPTH );
    virtual ~Target();

    // Method interface for derived objects
    virtual bool Hit( void );
    virtual void Show( void ) const;    

    // return the status of the targer
    TargetStatus Get_status( void ) const;
    std::string Get_name ( void ) const;
    int Get_depth_limit ( void );
    int Get_armor ( void ) { return( armor ); }
    void Reset( void );   
    
    // pure virtual method creates abstract class for
    // deployed application, cannot create an instance 
    // of this class outside the test driver.
    #ifndef TARGET_TEST
    virtual void Abstract ( void ) = 0;
    #endif 

  protected:
    TargetStatus status;
    std::string name;
    int  armor;
    int  hits;
    int  depth_limit;

  private:
    Target( const Target & t )
    {
      // cannot pass target by value from a private
      // copy constructor
    }

};

} // namespace Seahunt

#endif // TARGET_H

// eof target.h

