// sub.cpp

#include <iostream>

#include "sub.h"

namespace Seahunt
{

Sub *
Sub::Create( void )
{
  std::string newname;
  int d = 0;
  int a = 0;
  std::cout << std::endl;
  Utility::UserEntry( "Submarine Name", newname, 60 );
  Utility::UserEntry( "Submarine Maximum Depth", d, 0, MAX_DEPTH );
  Utility::UserEntry( "Submarine Armor", a, 1, MAX_ARMOR ); 
  Sub * newsub = new Sub ( newname, a, d );
  return( newsub );
}

Sub *
Sub::Create( std::string name, int a, int d )
{
  Sub * newsub = new Sub ( name, a, d );
  return( newsub );
}

Sub::Sub( std::string name, int a, int d )
   : Target( name, a, d )
{
  #ifdef SUB_TEST
  std::cout << "Constructed Sub" << name << std::endl;
  #endif
}

Sub::~Sub()
{
  #ifdef SUB_TEST
  std::cout << "Destructed Sub" << name << std::endl;
  #endif
}

void
Sub::Show ( void ) const
{
  std::cout << "Sub      : ";
  Target::Show();
  std::cout << "Max Depth: " << depth_limit << std::endl;
}

bool
Sub::Hit ( void )
{
  bool hit_status = Target::Hit();
  if ( hit_status == true )
  { 
    if ( Get_status() == DEAD )
    {
      Show();
    }
  }
  return(hit_status);
}

} // namespace Seahunt

#ifdef SUB_TEST
int
main ( void )
{
  Seahunt::Sub * s = Seahunt::Sub::Create();

  s->Hit();
  s->Hit();
  s->Hit();
  s->Hit();

  std::cout << "\nCheckDepth(5): " << s->CheckDepth(5) << "\n" << std::endl;

  s->Reset();
  s->Show();

  return (0);
}
#endif // SUB_TEST



