// player.h

#ifndef PLAYER_H
#define PLAYER_H

#include <iostream>
#include <iomanip>
#include <string>
#include <ctime>

#include "ocean.h"

namespace Seahunt
{

class Player
{
  public:
    Player();
    Player( std::string name );
    ~Player();
    bool Hit( Ocean * ocean );
    int Score( Ocean * ocean );
    void Show( void ) const;
    int Get_score ( void ) const;
    int Get_number_hits ( void ) const;
    int Get_number_tries ( void ) const;
    std::string Get_name ( void ) const;
    void Set_name ( std::string n );
    
  private:
    std::string name;
    int score;
    int number_tries;
    int number_hits;
    time_t begintime;
};

}

#endif