// player.cpp

#include "player.h"

namespace Seahunt
{

Player::Player()
{
  score = 0;
  begintime = time(0);
  number_hits = 0;
  number_tries = 0;
  Utility::UserEntry( "Player Name", name, 50 );
}

Player::Player( std::string n )
{
  name = n;
  begintime = time(0);
  score = 0;
  number_hits = 0;
  number_tries = 0;
}

Player::~Player()
{
  // no dynamic memory allocated by the object
}

bool 
Player::Hit( Ocean * ocean )
{
  bool status = ocean->Hit();
  number_tries++;
  if ( status == true )
  {
    number_hits++;
  }
  Score(ocean);
  return( status );
}

int 
Player::Score( Ocean * ocean )
{
  score = (ocean->Get_destroyed_targets() * 100)
          + (2*number_hits) - 
          (number_tries-number_hits);
  return(score);
}

void 
Player::Show( void ) const
{
  double hmr = 0.0;
  if ( number_tries > 0 )
  {
    hmr = (static_cast<double>(number_hits)/
          static_cast<double>(number_tries));
  }
  std::cout << std::endl;
  std::cout.setf( std::ios::fixed );
  std::cout << std::setprecision(2);
  std::cout << "Player  : " << name << std::endl;
  std::cout << "Elapsed : " << 
               (static_cast<double>((time(0)-begintime))/
               60.0 ) << " Minutes" << std::endl;
  std::cout << "Score   : " << score << std::endl;
  std::cout << "Hit/Miss: " << hmr << std::endl << std::endl;
  std::cout.unsetf(std::ios::fixed);
}

int 
Player::Get_score ( void ) const
{
  return(score);
}

int 
Player::Get_number_hits ( void ) const
{
  return(number_hits);
}

int 
Player::Get_number_tries ( void ) const
{
  return(number_tries);
}

std::string 
Player::Get_name ( void ) const
{
  return(name);
}

void 
Player::Set_name ( std::string n )
{
  name = n;
}

}  // namespace

#ifdef PLAYER_TEST
int
main ( void )
{
  Seahunt::Ocean pacific("Pacific");
  Seahunt::Player p( "John Smith" );

  pacific.PlaceTarget();
  p.Hit(&pacific);
  p.Show();

  return(0);
}
#endif

  

  



