// ocean.h
// 
// Specification for type ocean
// 

#ifndef OCEAN_H
#define OCEAN_H

#include <string>

#include "utility.h"
#include "cell.h"
#include "target.h"

namespace Seahunt
{

class Ocean
{
  public:
    Ocean();
    ~Ocean();
    void PlaceTarget( void );
    bool Hit( void );
    void Show( void );
    void ShowTargets( void );
    int Get_target_count( void ) const;
    int Get_active_targets( void ) const;
    int Get_destroyed_targets( void ) const;
    enum Size { MAX_TARGET=5 };
  private:
    enum DIM { ROW=10, COL=10, DEPTH=10, DEPTHFACTOR=100 };
    std::string name;
    int target_count;
    int active_targets;
    int destroyed_targets;
    Cell ocean[ROW][COL][DEPTH];
    Target * targets[MAX_TARGET];
    void TargetPlacement ( Target * t );
    void Init ( void );
};

}

#endif // OCEAN_H


