// cell.h
// 
// Specification for type cell
// A cell is a piece of an ocean
//

#ifndef CELL_H
#define CELL_H

#include "target.h"

namespace Seahunt
{

class Cell
{
  public:
    Cell ();                  // constructor
    ~Cell();                  // destructor
    void  Set_xyz ( int x=0, int y=0, int z=0 );
    int   Get_x ( void ) const;
    int   Get_y ( void ) const;
    int   Get_z ( void ) const;
    bool  Set_target ( Target * t );
    Target * Get_target ( void ) const;
    bool  Hit ( void );

  private:
    Cell ( const Cell & c );  // copy constructor
    bool hit_status;          // true if the cell is hit
    Target * target;          // assigned to the cell
    int x;                    
    int y;
    int z;                    // depth of the ocean  
};

} // namepsace Seahunt

#endif // CELL_H


