
package rolodex;
import rolodex.Contact;
import java.util.LinkedList;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Rolodex
{

  private LinkedList rololist = new LinkedList();
  
  public Rolodex()
  {
    System.out.println ( "Rolodex" );
  } 

  public boolean open ( String datafilename )
  {
    System.out.println ( "Open Rolodex" );

    FileInputStream inputfile = null;
    ObjectInputStream ois = null;

    File f = new File ( datafilename );
    if ( f.exists() )
    {
      // open the input file stream
      if ( f.canRead() )
      {
        try
        {
          inputfile = new FileInputStream ( f );
        }
        catch ( Exception e )
        {
         System.err.println ( "Cannot Open or Currupted File: " + datafilename );
         return(false);            
        }
      }
      else
      {
        System.err.println ( "Cannot Read From File: " + datafilename );
        return(false);
      }
      
      // read from the file to the list
      try
      {
        ois = new ObjectInputStream ( inputfile );
      }
      catch ( Exception e )
      {
        System.err.println ( "Cannot open input stream for object read." );
        return(false);       
      }

      Object testo = null;
      try 
      {
        testo = ois.readObject();
      }
      catch ( Exception e )
      {
        System.err.println ( "Cannot read Rolodex List" );
        return(false);       
      }

      if ( testo instanceof LinkedList )
      {
        rololist = (LinkedList)testo;
      }
      System.out.println ( "Rolodex " + datafilename + " Opened" );
    }    
    return(true);
  }

  public boolean close( String datafilename )
  {
    System.out.println ( "Close Rolodex" );

    FileOutputStream outputfile = null;
    ObjectOutputStream oos = null;

    File f = new File ( datafilename );
    try
    {
      outputfile = new FileOutputStream ( f );
    }
    catch ( Exception e )
    {
      System.err.println ( "Cannot Create File: " + datafilename );
      return(false);            
    }

    // write list
    try
    {
      oos = new ObjectOutputStream ( outputfile );
    }
    catch ( Exception e )
    {
      System.err.println ( "Cannot open output stream for object write." );
      return(false);       
    }

    try 
    {
      oos.writeObject( (Object)rololist );
    }
    catch ( Exception e )
    {
      System.err.println ( "Cannot write Rolodex List" );
      return(false);       
    }
    System.out.println ( "Rolodex " + datafilename + " Closed" );
    return(true);
  }

  public void add(Contact c)
  {
    rololist.add(c);
  }

  public int addContacts()
  {
    int newcontacts = 0;
    while (true)
    {
      Contact newc = new Contact();
      if ( newc.getName().length() == 0 )
      {
        break;
      }
      else
      {
        add(newc);
        newcontacts++;
      }
    }
    return(newcontacts);
  }

  public void show()
  {
    for ( int i=0; i<rololist.size(); i++ )
    {
      ((Contact)rololist.get(i)).show();
    }
  }

  static public void main ( String args[] )
  {
    Rolodex rolo = new Rolodex();

    if ( args.length < 1 )
    {
      System.err.println ( "Usage: java rolodex.Rolodex datafile" );
      System.exit(1);
    }
    else
    {
      if ( rolo.open(args[0]) == false )
      {
        System.err.println ( "Error: Failed to open Rolodex" );  
        System.exit(1);
      }
    }

    rolo.show();
    rolo.addContacts();
    rolo.show();
    rolo.close(args[0]);

  }
}


