#!/usr/local/bin/tclsh
puts "WWWserver.tcl 0.1 (C) 1998, V. Ziemann, ABSOLUTELY NO WARRANTY"
#................................................................
proc serverAccept { sock addr port } {
    global echo
    puts "Accept $sock from $addr at port $port"
    set echo(addr,$sock) [list $addr $port]
    fconfigure $sock -buffering line
    fileevent $sock readable [list serverProcess $sock]
}
#................................................................
proc serverProcess { sock } {
    global echo env
    while {![eof $sock]} {
	if { [eof $sock] || [ catch { set line [ gets $sock ] } ] } {
	    catch { close $sock }
	    puts "Close $echo(addr,$sock)"
	    unset echo(addr,$sock)
	} else {
	    if { [ regexp {^(GET)|^(POST)} $line ] } {
		set FILNAM [ string trim [ lindex $line 1 ] / ]
		set iscgi [ regexp {^cgi-bin/([^\?]+)(.*)}\
			$FILNAM match sub1 query ]
		if { $iscgi } { set FILNAM cgi-bin/$sub1 }
		puts "$echo(addr,$sock) : $FILNAM : $iscgi"
 		if {[regexp {\.\.|\&|\?|\*|\(|\)|\$|;|\#|\|} $FILNAM ]} { 
		    puts $sock "Forbidden (Error 403)"
		} elseif { $iscgi } {
		    if { [ file exists $FILNAM ] } {
			if { [ regexp {^(POST)} $line ] } {
			    set line "--empty--"
			    while {$line != ""} {
				set line [ gets $sock ]
 				if [regexp -nocase {^CONTENT-LENGTH} $line] {
 				    set env(CONTENT_LENGTH) [lindex $line 1]
 				}
			    }
			    if { [catch {set f [ open "|$FILNAM" r+ ]}]} {
				puts $sock "Not Found (Error 404)"
			    } else {
				if {[ catch { puts $f [gets $sock ] ; flush $f; \
					puts $sock [ read $f ] ; close $f } ]} {
				    puts $sock "Internal Server Error (Error 505)"
				}
			    }   
		        } else {
			    set env(QUERY_STRING) [ string trim $query \? ]
			    if { [catch { puts $sock [exec $FILNAM]}]} { 
				puts $sock "Internal Server Error (Error 505)"
			    }
			}
		    } else { puts $sock "Not Found (Error 404)" }
		} else {
		    if { $FILNAM == "" } { set FILNAM welcome.html }
		    if { [ catch { set f [ open $FILNAM r ] } ] } { 
			puts $sock "Not Found (Error 404)"
		    } else {
			puts $sock "HTTP/1.0 200 OK"
			puts $sock [ read $f ]
			close $f
		    }
		}
		break 
	    }
	}
    }
    catch { close $sock }
    puts "Close $echo(addr,$sock)"
    return
}
#................................................................
if {[catch {set echo(main) [socket -server serverAccept [lindex $argv 0]]}]} {
    puts "Please choose another port number"; exit
}
vwait forever


