#!/usr/local/bin/tclsh
puts "SearchServer.tcl 0.1 (C) 1998, V. Ziemann, ABSOLUTELY NO WARRANTY"
#................................................................
proc serverAccept { sock addr port } {
    global echo
    puts "Accept $sock from $addr at port $port"
    set echo(addr,$sock) [list $addr $port]
    fconfigure $sock -buffering line
    fileevent $sock readable [list serverProcess $sock]
}
#............................................from B. Welch's Book
proc Url_Decode {url} {
    regsub -all {\+} $url { } url
    regsub -all {%([0-9a-hA-H][0-9a-hA-H])} $url \
	    {[format %c 0x\1]} url
    return [subst $url]
}
#................................................................
proc file_search { sock {DIR "."} } {
    global SEARCH_STRING LBASE
    set home [pwd]
    if {$DIR == "."} {set LBASE [string length $home]}
     catch {
	cd $DIR
	foreach f [lsort [glob *]] {
	    if {[file isdirectory $f]} { 
		file_search $sock $f
	    } elseif { [ regexp {\.txt$|\.html$} $f ]} {
		set s [open $f r]; set t [read $s]; close $s
		if {[regexp -nocase $SEARCH_STRING(0) $t]&&\
			[regexp -nocase $SEARCH_STRING(1) $t]&&\
			[regexp -nocase $SEARCH_STRING(2) $t]} {
		    set pwd [pwd]
		    set found [string trimleft [string range $pwd $LBASE\
			    [string length $pwd]]/$f /]
		    puts $sock "<A HREF=$found> $found </A><BR>"
		}
	    }
	}
	cd $home
     }
}    
#................................................................
proc serverProcess { sock } {
    global echo env SEARCH_STRING
    while {![eof $sock]} {
	if { [eof $sock] || [ catch { set line [ gets $sock ] } ] } {
	    catch { close $sock }
	    puts "Close $echo(addr,$sock)"
	    unset echo(addr,$sock)
	} else {
	    if { [ regexp {^(GET)} $line ] } {
		set FILNAM [ string trim [ lindex $line 1 ] / ]
		set iscgi [ regexp {(^SEARCH.STRINGS)\?(.*)}\
			$FILNAM match sub1 query ]
		if { $iscgi } { set FILNAM $sub1 }
		puts "$echo(addr,$sock) : $FILNAM : $iscgi"
 		if {[regexp {\.\.|\&|\?|\*|\(|\)|\$|;|\#|\|} $FILNAM ]} { 
		    puts $sock "Forbidden (Error 403)"
		} elseif { $iscgi } {
		    set I 0
		    foreach {name value} [split $query &=] {
			set SEARCH_STRING($I) [Url_Decode $value]
			incr I
		    }
		    puts $sock " Search Results:<BR>"
 		    file_search $sock . 
		} else {
		    if { $FILNAM == "" } { set FILNAM search.html }
		    if { [ catch { set f [ open $FILNAM r ] } ] } { 
			puts $sock "Not Found (Error 404)"
		    } else {
			if [regexp {\.txt$} $FILNAM] {puts $sock "Content-Type: text/plain\n\n"}
			puts $sock [ read $f ]
			close $f
		    }
		}
		break 
	    }
	    
	}
    }
    catch { close $sock }
    puts "Close $echo(addr,$sock)"
    return
}

#.......................................................Main program
if {[catch {set echo(main) [ socket -server serverAccept [lindex $argv 0]]}]} {
    puts "Please choose another port number"; exit
}
vwait forever





