# 
# Copyright (C) 1996 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb Guest Book.
#
# Qddb Guest Book is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb Guest Book is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb Guest Book; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#

proc Usage {} {
	puts -nonewline \
"Content-type: text/html

<html>
<head><title>New User Input Form Error</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>You must specify at least the username, first and last name!</h2>

</body>
</html>
"
}

proc BadName {} {
	puts -nonewline \
"Content-type: text/html

<html>
<head><title>Bad Username</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>The username selected is not available. Try a different  username.</h2>

</body>
</html>
"
}


proc FailedMakeuser {} {
	puts -nonewline \
"<html>
<head><title>User Creation Failed</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>The user creation process failed.</h2>
This may result in a partially-created user but probably not a useable
one.
</body>
</html>
"
}


proc StatusLocked {} {
	puts -nonewline \
"Content-type: text/html

<html>
<head><title>Status Record Locked</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>The status record is locked, I cannot determine next ID to use.</h2>
</body>
</html>
"
}


proc nextClient {} {
	global gv_tmpattr
	set S [qddb_schema open /var/lib/ISPutil/qdDBs/Setup]
	set K [qddb_search $S -prunebyattr ClientID r .*]
	set T {}
	foreach i [qddb_keylist get $K] {
	    set T [qddb_tuple read $S $i]
	    if {[llength $T] > 0} {
		break
	    }
	}
	if {[string compare $T {}] == 0} {
	    puts "You must set up fields in the Setup screen first"
	    return
	}
	qddb_keylist delete $K
	if {[qddb_tuple lock $T] == 0} {
	    exec sleep 1
	}
	if {[qddb_tuple lock $T] == 0} {
	    exec sleep 1
	}
	if {[qddb_tuple lock $T] == 0} {
	    exec sleep 1
	}
	if {[qddb_tuple lock $T] == 0} {
	    exec sleep 1
	}
	if {[qddb_tuple lock $T] == 0} {
	    StatusLocked
	    exit 0
	}
	set V [qddb_view define $T {
	    {ClientID gv_tmpattr(clid)}
	}]
	set cid $gv_tmpattr(clid)
	incr gv_tmpattr(clid)
	qddb_tuple write $T
	catch "qddb_tuple delete $T"
	qddb_schema close $S
	return $cid
}
