# 
# Copyright (C) 1996 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb Guest Book.
#
# Qddb Guest Book is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb Guest Book is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb Guest Book; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#

proc GuestBookTable {tbl} {
    global page_title

    puts -nonewline \
"Content-type: text/html

<html>
<head><title>$page_title</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>Thanks for searching our database!<br>
Here are the results of your search.</h2>
<table border>
[Hx:FormatTable $tbl]
</table>
<br>
"
}

proc GuestBookListing {tbl} {
    global page_title listing_format tablevar s

    puts "Content-type: text/html

<html>
<head><title>$page_title</title></head>
<body bgcolor=#F0F0F0 text=#222222 link=#1B3E62 vlink=#962835 alink=#EE0000>
<h2>Thanks for searching our database!<br>
Here are the results of your search.</h2>
<br>
[Hx:DefinedListing $s $tbl $listing_format]
"
}

proc GuestBookSearch {} {
    global env nfirstrow nlastrow firstrow lastrow \
	    rowincr search tablevar s page_title \
	    mypath maxrows myhost

    set nfirstrow [expr $firstrow + $rowincr]
    set nlastrow [expr $lastrow + $rowincr]
    set pfirstrow [expr $firstrow - $rowincr]
    set plastrow [expr $lastrow - $rowincr]
    set env(QUERY_STRING) {}
    lappend env(QUERY_STRING) $nfirstrow $nlastrow
    if {[info exists search]} {
	lappend env(QUERY_STRING) $search
	set l1 $search
    } else {
	set l1 [Hx:GetPostedData]
	set search $l1
	lappend env(QUERY_STRING) $l1
    }
    regsub -all {[ 	]+} $env(QUERY_STRING) "\{\}" env(QUERY_STRING)
    set format Table
    foreach i $l1 {
	set attr [lindex $i 0]
	if {[GuestBookCheckPriv $attr] != 0} {
	    Hx:ParseError
	    exit 0
	}
	if {[string compare $attr \$format\$] == 0} {
	    set format [lindex $i 1]
	}
    }
    if {[catch [list Hx:Search $s $l1] k] != 0} {
	Hx:ParseError
	exit 0
    }
    if {[string length $k] == 0} {
	Hx:NoSearch
	exit 0
    }
    foreach i $l1 {
	if {[string compare [lindex $i 0] hx-columns] == 0} {
	    lappend columns [lindex $i 1]
	}
	if {[string compare [string range [lindex $i 0] 0 6] hx-sort] \
		== 0} {
	    set sortattrs([string range [lindex $i 0] 8 end]) \
		    [lindex $i 1]
	}
    }
    if {![info exists columns]} {
	set columns $default_columns
    } else {
	foreach i $columns {
	    if {[GuestBookCheckPriv $i] != 0} {
		Hx:ParseError
		exit 0
	    }
	}
    }
    set sortby {}
    foreach i [lsort -integer -increasing [array names sortattrs]] {
	lappend sortby $sortattrs($i)
    }
    set k [qddb_keylist range $k 0 $maxrows]
    if {[string length $k] == 0} {
	Hx:NoMatches
	exit 0
    }
    set tbl [qddb_rows select -format table -rowdescs off \
	    -flush on -print $columns -sortby $sortby -ascending $sortby $k]
    if {[string length $tbl] == 0} {
	Hx:NoMatches
	exit 0
    }
    # Put hrefs in place for e-mail addrs and home pages
    set maxrow [qddb_table row maxnum $tbl]
    Hx:PruneTable $tbl $firstrow $lastrow
    if {$lastrow > $maxrow} {
	set env(QUERY_STRING) "" ;# kill the next page button
    }
    qddb_table configure $tbl -variable tablevar
    set maxrows [qddb_table row maxnum $tbl]
    for {set i 1} {$i <= $maxrows} {incr i} {
	if {[info exists tablevar($i,email)]} {
	    set trim [string trim $tablevar($i,email)]
	    if {[string length $trim] != 0} {
		set tablevar($i,email) \
			"<a href=mailto:\"$trim\">$trim</a>"
	    }
	}
	if {[info exists tablevar($i,homepage)]} {
	    set trim [string trim $tablevar($i,homepage)]
	    if {[string length $trim] != 0} {
		if {[string compare \
			[string range $trim 0 6] \
			"http://"] != 0} {
		    set trim http://$tablevar($i,homepage)
		}
		set tablevar($i,homepage) \
			"<a href=\"$trim\">$trim</a>"
	    }
	}
    }
    if {[string compare $format Listing] == 0} {
	GuestBookListing $tbl
    } else {
	GuestBookTable $tbl
    }
    if {[string length $env(QUERY_STRING)] == 0 && $pfirstrow >= 1} {
	set env(QUERY_STRING) [list $pfirstrow $plastrow $search]
	regsub -all {[ 	]+} $env(QUERY_STRING) "\{\}" env(QUERY_STRING)
        puts "
<form method=POST ACTION=${mypath}?$env(QUERY_STRING)>
<input type=submit value=\"Previous page\">
</form>
<br>
<a href=http://${myhost}${mypath}>Back to search form</a>
</body></html>"
    } elseif {$pfirstrow >= 1} {
	set prev [list $pfirstrow $plastrow $search]
	regsub -all {[ 	]+} $prev "\{\}" prev
	puts "
<form method=POST ACTION=${mypath}?${prev}>
<input type=submit value=\"Previous page\">
</form>
<form method=POST ACTION=${mypath}?$env(QUERY_STRING)>
<input type=submit value=\"Next page\">
</form>
<br>
<a href=http://${myhost}${mypath}>Back to search form</a>
</body></html>"
    } elseif {[string length $env(QUERY_STRING)] > 0} {
	puts "
<form method=POST ACTION=${mypath}?$env(QUERY_STRING)>
<input type=submit value=\"Next page\">
</form>
<br>
<a href=http://${myhost}${mypath}>Back to search form</a>
</body></html>"
    } else {
	puts "
<br>
<a href=http://${myhost}${mypath}>Back to search form</a>
</body></html>"
    }
    return
}
