#!/bin/sh
#
# wwwutils.sh - menu for administrating WWWutil system
#
#		This menu is intended to be run with root privileges
#
WWWUTIL="/var/lib/WWWutil"
ISPUTIL="/var/lib/ISPutil"
BBSUTIL="/var/lib/BBSutil"
hostname=`hostname`
dnsdomainname=`dnsdomainname`
TITLE="$hostname.$dnsdomainname WWWutil"
export EDITOR="/usr/local/bin/pico -t"
export VISUAL=$EDITOR

umodify()
{
MDONE=
while [ -z $MDONE ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Seteup Online Database" 16 50 9 \
	"ADD"	 "Add a Database" \
	"BACK"   "Back from menu" \
	"LIST"   "List Online Databases" \
        "X=EXIT" "Exit Menu" 2> /tmp/uch.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/uch.tmp.$$
                exit
        fi
	mchoice=`cat /tmp/wwwutil.tmp.$$`
        /bin/rm -f /tmp/wwwutil.tmp.$$

        if [ "$mchoice" = "ADD" ]; then
        $WWWUTIL/util/addDB.sh
        fi
        if [ "$mchoice" = "BACK" ]; then
          MDONE=DONE
        fi
        if [ "$mchoice" = "X=EXIT" ]; then
          MDONE=DONE
        fi
done
}
