#!/bin/sh
#
# sac.sh -	Generate sac reports.
#
#	This script is part of WWWutils, copyright 1996 Mark Metson
#	Placed under the GNU General Public License version 2.
#		(See the file COPYING for license details).
#

 MODEMS="ttyS0 ttyS1 ttyS2 ttyS3"
 MODEMS="$MODEMS ttySA ttySB ttySC ttySD ttySE ttySF ttySG ttySH"
 MODEMS="$MODEMS ttySI ttySJ ttySK ttySL ttySM ttySN ttySO ttySP"

PUBHTML="public_html"

WWWUTIL="/var/lib/WWWutil"
WWWSAC=$WWWUTIL/util/sac
ACCOUNTINGHTDOCS="/var/lib/www/staff/accounting/reports"
MODEMWTMP="/cindial1/var/adm/wtmp"
COPYMODEMWTMP="YES"
SAC=/usr/local/bin/sac

#
# the rest should be boilerplate...
#

START=`date +%m/01/%y`

tmpfile=/tmp/WWWSacMidnite.$$

if [ "$COPYMODEMWTMP" = "YES" ]; then
  wtmp=/tmp/modemwtmp.$$
  cp -a $MODEMWTMP $wtmp
else
  exit
  wtmp=$MODEMWTMP
fi

echo "<WWWUTIL>" > $tmpfile
echo "<INSERT NAME=HEAD TITEL=\"M.T.D. Modem Usage\">" >> $tmpfile
echo "<FONT SIZE=+2>Report Date: `date`<P></FONT>" >> $tmpfile
$SAC -w $wtmp -p -s $START -T $MODEMS | awk -f $WWWSAC/sac-p.awk \
			>> $tmpfile
echo "<INSERT NAME=END>" >> $tmpfile
mv -f $tmpfile $ACCOUNTINGHTDOCS/MTDhours.spider

#cd /home
#for u in * ; do
#  if [ -f $u/$PUBHTML/index.spider -o -f $u/$PUBHTML/index.html ]; then
#    echo "<WWWUTIL>" > $tmpfile
#    echo "<INSERT NAME=HEAD TITEL=\"$u M.T.D. Modem Usage\">" >> $tmpfile
#    echo "<FONT SIZE=+2>Report Date: `date`<P></FONT>" >> $tmpfile
#    $SAC -w $wtmp -u $u -d -s $START -T $MODEMS | awk -f $WWWSAC/sac-d.awk \
#		>> $tmpfile
#    echo "<INSERT NAME=END>" >> $tmpfile
#    mv -f $tmpfile $u/$PUBHTML/MTDhours.spider
#  fi
#done

if [ "$COPYMODEMWTMP" = "YES" ]; then
  rm -f $wtmp
fi

