#!/bin/sh
#
# config.sh -	Configure WWWutil package makefiles from paths.dat file
#
#		Assumes pwd is the WWWutil directory.
#
#		Rewrites the Makefiles and shell scripts with path info.
#

if [ ! -f ./paths.dat ]; then
  echo "$0: paths.dat not found."
  exit 1
fi

. ./paths.dat

for d in indexes pagemake util pubcgi membercgi staffcgi util/sac \
	root root/cmds.mainhost root/cmds.modemhost  ; do
  if [ -d $d ]; then
    pushd $d
    for f in * ; do
      if [ -f $f ]; then
 	sed $f -e "s@^WWWUTIL=.*@WWWUTIL=\"$WWWUTIL\"@" \
		-e "s@^ISPUTIL=.*@ISPUTIL=\"$ISPUTIL\"@" \
		-e "s@^BBSUTIL=.*@BBSUTIL=\"$BBSUTIL\"@" \
		-e "s@^ISPDBS=.*@ISPDBS=\"$ISPDBS\"@" \
		-e "s@^WWWDBS=.*@WWWDBS=\"$WWWDBS\"@" \
		-e "s@^WWWGROUP=.*@WWWGROUP=\"$WWWGROUP\"@" \
		-e "s@^WWWLOGDIR=.*@WWWLOGDIR=\"$WWWLOGDIR\"@" \
		-e "s@^WWWLOGNAME=.*@WWWLOGNAME=\"$WWWLOGNAME\"@" \
		-e "s@^MAILHOST=.*@MAILHOST=\"$MAILHOST\"@" \
		-e "s@^WEBSERVER=.*@WEBSERVER=\"$WEBSERVER\"@" \
		-e "s@^MODEMHOST=.*@MODEMHOST=\"$MODEMHOST\"@" \
		-e "s@^LOCALDOMAIN1=.*@LOCALDOMAIN1=\"$LOCALDOMAIN1\"@" \
		-e "s@^LOCALDOMAIN2=.*@LOCALDOMAIN2=\"$LOCALDOMAIN2\"@" \
		-e "s@^ACCOUNTINGHTDOCS=.*@ACCOUNTINGHTDOCS=\"$ACCOUNTINGHTDOCS\"@" \
		-e "s@^MODEMWTMP=.*@MODEMWTMP=\"$MODEMWTMP\"@" \
		-e "s@^COPYMODEMWTMP=.*@COPYMODEMWTMP=\"$COPYMODEMWTMP\"@" \
		-e "s@^PUBHTML=.*@PUBHTML=\"$PUBHTML\"@" \
		-e "s@^QBIN=.*@QBIN=\"$QBIN\"@" \
		-e "s@^EDITOR=.*@EDITOR=\"$EDITOR\"@" \
		-e "s@^SYSOPEDITOR=.*@SYSOPEDITOR=\"$SYSOPEDITOR\"@" \
		-e "s@^DOAS=.*@DOAS=\"$DOAS\"@" \
		-e "s@^MAKE=.*@MAKE=\"$MAKE\"@" \
		-e "s@^MAKEPKG=.*@MAKEPKG=\"$MAKEPKG\"@" \
		-e "s@^SORT=.*@SORT=\"$SORT\"@" \
		-e "s@^DATE=.*@DATE=\"$DATE\"@" \
		-e "s@^AWK=.*@AWK=\"$AWK\"@" \
		-e "s@^QUOTA=.*@QUOTA=\"$QUOTA\"@" \
		-e "s@^REPQUOTA=.*@REPQUOTA=\"$REPQUOTA\"@" \
		-e "s@^SUPER=.*@SUPER=\"$SUPER\"@" \
		> $f.new
        cp $f.new $f
        rm $f.new
      fi
    done
    popd
  fi
done

