# 
# Copyright (C) 1996 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb Guest Book.
#
# Qddb Guest Book is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb Guest Book is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb Guest Book; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#

set firstrow 1                          ;# initial first row (starts at zero)
set lastrow 10                          ;# initial last row
set rowincr 10                          ;# maximum number of hits per page
set maxrows 100                         ;# maximum number of total hits allowed
set dir "/var/lib/www/staffcgi/qddb/clients" ;# Full path containing this stuff
set cgidir "/staff/cgi-bin/qddb/clients"    ;# CGI path containing guest book
set DBname Clients                    ;# Relation name (must be in $dir)
set myhost www.kayhay.com             ;# Your WWW server's name

# the following columns will be checked by default (for searching)
set default_columns {\
	Company.Contact.Username \
	Company.Name \
	Company.Contact.First \
	Company.Contact.Last
	}

# postform instructions:
#
# You should modify your schema (verbosenames and such) to your
# liking, then add or change any attribute names below.
# See Hx(n) for more information on this list's format.
#
# Each element has the form:
#    {attribute label-width type entry-width ?values?}
# REMEMBER: lines are important in these lists!
set postform {
    {<html> <h2>Company (optional)</H2>}
    {Company.Name 12 text 40}
    {Company.Contact.JobTitle 12 text 40}
    {ReferredBy 12 text 40}
    {<html> <hr><h2>Contact</H2>}
    {Company.Contact.Title 12 text 5} {Company.Contact.First 6 text 15} {Company.Contact.Last 5 text 20}
    {Company.Contact.Username 12 text 10} {Company.Contact.PIN 7 text 10} {CreditLimit 13 text 8}
    {<html> <BR><BLOCKQUOTE><P>}
    {<html> Each month a fixed number of hours is taken from HoursPool}
    {<html> (if any are IN HoursPool) for use in the new month...</BLOCKQUOTE>}
    {Company.Contact.Hours 12 text 4} {Company.Contact.Shell 0 label 0} {Company.Contact.Shell 2 radio 0 0 /shells/notyet} {Company.Contact.Shell 2 radio 0 0 /shells/pppin} {Company.Contact.Shell 2 radio 0 0 /shells/slipin}
    {<html> <hr><h2>Address</h2>}
    {Company.Address.Desc 12 text 40}
    {Company.Address.Street 12 text 40}
    {Company.Address.City 12 text 40}
    {Company.Address.State 12 text 12} {Company.Address.Zip 12 text 12}
    {<html> <hr><h2>Telephone</h2>}
    {Company.Contact.Phone.Desc 12 text 40}
    {Company.Contact.Phone.Area 12 text 4} {Company.Contact.Phone.Number 6 text 20}
    {<html> <hr>}
    {Comments 12 textarea 60 5}
    {<html> <hr>}
}

# listing_format instructions:
#
# For the "Listing" format, the following list is
# passed to Hx:DefinedListing to build each entry
# in the search results.
#
# Each element has the form:
#    {attribute type width}
# REMEMBER: lines are important in these lists!
set listing_format {
    {<html> <h2><font face="arial" color=#1F7F1F>}
    {<html> Company</font></h2><ul>}
    {<html> <font face="arial" size="4">} {Company.Name text 30}
    {<html> <h3><font face="arial" color=#1F7F1F>}
    {<html> Contact</font></h3><ul>}
    {Company.Contact.Title text 6} {Company.Contact.First text 20} {Company.Contact.Last text 20}
    {<html> Username: } {Company.Contact.Username text 12}
    {<html> ID: } {Company.Contact.ID text 5} {<html> UID: } {Company.Contact.UID text 5} {<html> GID: } {Company.Contact.GID text 5}
    {<html> Email:<a href=mailto:} {Company.Contact.Email text 0} {<html> >} {Company.Contact.Email text 20} {<html> </a>}
    {<html> <h4><font face="arial" color=#1F7F1F size="4">}
    {<html> WebProject</font></h4><ul>}
    {Company.Contact.WebProject.Title text 30} {<html> <a href=} {Company.Contact.WebProject.Path text 30} {<html> >} {Company.Contact.WebProject.Path text 30} {<html> </a>}
    {<html> </font></ul></ul>}
}

# privfields is a list of attributes that should never be shown in
# the search form.
set privfields { Company.Contact.PIN \
	Company.Contact.Pending \
	Company.Contact.MonthlyRate \
	Company.Contact.Spare1 \
	Company.Contact.Spare2 \
	Company.Contact.Spare3 \
	Company.Contact.Spare4 \
	Company.Contact.Sparelist \
	Company.Contact.WebProject.DBs.Schema \
	Company.Contact.WebProject.DBs.Path \
	Company.Contact.WebProject.DBs.Infile \
	Company.Contact.WebProject.DBs.ImportCmd \
	Company.Contact.WebProject.DBs.StallFreq \
	Company.Contact.WebProject.DBs.URL \
	Company.Contact.WebProject.DBs.Comments \
	Company.Contact.WebProject.Background \
	Company.Contact.WebProject.BGcolor \
	Company.Contact.WebProject.Textcolor \
	Company.Contact.WebProject.Linkcolor \
	Company.Contact.WebProject.Vlinkcolor \
	Company.Contact.WebProject.Header \
	Company.Contact.WebProject.Footer \
	Company.Contact.WebProject.Bullet1 \
	Company.Contact.WebProject.Bullet2 \
	Company.Contact.WebProject.Divider1 \
	Company.Contact.WebProject.Divider2 \
	Company.Contact.WebProject.Image1 \
	Company.Contact.WebProject.Iurl1 \
	Company.Contact.WebProject.Image2 \
	Company.Contact.WebProject.Iurl2 \
	Company.Contact.WebProject.Image3 \
	Company.Contact.WebProject.Iurl3 \
	Company.Contact.WebProject.Image4 \
	Company.Contact.WebProject.Iurl4 \
	Company.Contact.WebProject.Image5 \
	Company.Contact.WebProject.Iurl5 \
	Company.Contact.WebProject.Image5 \
	Company.Contact.WebProject.Iurl5 \
	Company.Contact.WebProject.Image6 \
	Company.Contact.WebProject.Iurl6 \
	Company.Contact.WebProject.Image7 \
	Company.Contact.WebProject.Iurl7 \
	Company.Contact.WebProject.Image8 \
	Company.Contact.WebProject.Iurl8 \
	Company.Contact.WebProject.Anchor1 \
	Company.Contact.WebProject.URL1 \
	Company.Contact.WebProject.Anchor2 \
	Company.Contact.WebProject.URL2 \
	Company.Contact.WebProject.Anchor3 \
	Company.Contact.WebProject.URL3 \
	Company.Contact.WebProject.Anchor4 \
	Company.Contact.WebProject.URL4 \
	Company.Contact.WebProject.Anchor5 \
	Company.Contact.WebProject.URL5 \
	Company.Contact.WebProject.Anchor6 \
	Company.Contact.WebProject.URL6 \
	Company.Contact.WebProject.Anchor7 \
	Company.Contact.WebProject.URL7 \
	Company.Contact.WebProject.Anchor8 \
	Company.Contact.WebProject.URL8 \
	Company.Contact.WebProject.Anchor9 \
	Company.Contact.WebProject.URL9 \
	Company.Contact.WebProject.Anchor10 \
	Company.Contact.WebProject.URL10 \
	Company.Contact.WebProject.Anchor11 \
	Company.Contact.WebProject.URL11 \
	Company.Contact.WebProject.Anchor12 \
	Company.Contact.WebProject.URL12 \
	Company.Contact.WebProject.Anchor13 \
	Company.Contact.WebProject.URL13 \
	Company.Contact.WebProject.Anchor14 \
	Company.Contact.WebProject.URL14 \
	Company.Contact.WebProject.Anchor15 \
	Company.Contact.WebProject.URL15 \
	Company.Contact.WebProject.Anchor16 \
	Company.Contact.WebProject.URL16 \
	Company.Contact.WebProject.Field1 \
	Company.Contact.WebProject.Field2 \
	Company.Contact.WebProject.Field3 \
	Company.Contact.WebProject.Field4 \
	Company.Contact.WebProject.Field5 \
	Company.Contact.WebProject.Field6 \
	Company.Contact.WebProject.Field7 \
	Company.Contact.WebProject.Field8 \
	Company.Contact.WebProject.Field9 \
	Company.Contact.WebProject.Field10 \
	Company.Contact.WebProject.Field11 \
	Company.Contact.WebProject.Field12 \
	Company.Contact.WebProject.Field13 \
	Company.Contact.WebProject.Field14 \
	Company.Contact.WebProject.Field15 \
	Company.Contact.WebProject.Field16 \
	Company.Contact.WebProject.Comments \
	Company.Contact.WebProject.Notes \
	ResellerNumber \
	SSN \
	CreditCard \
	}

