# 
# Copyright (C) 1996 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb Guest Book.
#
# Qddb Guest Book is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb Guest Book is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb Guest Book; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#

set firstrow 1                          ;# initial first row (starts at zero)
set lastrow 10                          ;# initial last row
set rowincr 10                          ;# maximum number of hits per page
set maxrows 100                         ;# maximum number of total hits allowed
set dir "/var/lib/www/pubcgi/qddb/inventory";
# Full path containing guest book
set cgidir /cgi-bin/qddb/inventory	;# CGI path containing guest book
set DBname Inventory			;# Relation name (must be in $dir)
set myhost www.kayhay.com		;# Your WWW server's name

set page_signature ""			;# optional signature for headers

# the following columns will be checked by default (for searching)
set default_columns {Mfr,PartNumber,Description,Price.SuggestedRetail}

# postform instructions:
#
# You should modify your schema (verbosenames and such) to your
# liking, then add or change any attribute names below.
# See Hx(n) for more information on this list's format.
#
# Each element has the form:
#    {attribute label-width type entry-width ?values?}
# REMEMBER: lines are important in these lists!
set postform {
    {<html> <h2>Inventory</H2>}
    {Mfr 15 text 25}
    {PartNumber 15 text 16}
    {Description 15 text 50}
    {URL 15 text 50}
    {Price.SuggestedRetail 15 text 40}
    {Comments 15 textarea 50 4}
}

# listing_format instructions:
#
# For the "Listing" format, the following list is
# passed to Hx:DefinedListing to build each entry
# in the search results.
#
# Each element has the form:
#    {attribute type width}
# REMEMBER: lines are important in these lists!
set listing_format {
    {<html> <h2><hr><font face="arial" color=#1F7F1F>}
    {Description text 50} {<html> </font><hr></h2><ul><font face="arial">}
    {<html> <table> <tr><p><td>}
    {<html> Description: </td><td> } {Description text 50}
    {<html> </td></tr><tr><p><td>}
    {<html> Manufacturer: </td><td> } {Mfr text 25}
    {<html> </td></tr><tr><p><td>}
    {<html> Part: </td><td> } {PartNumber text 16}
    {<html> </td></tr><tr><p><td>}
    {<html> URL: </td><td> } {URL text 50}
    {<html> </td></tr><tr><p><td>}
    {<html> Retail: </td><td> } {Price.SuggestedRetail text 40}
    {<html> </td></tr><tr><p><td>}
    {<html> Comments: </td><td> } {Comments textarea 50 4}
    {<html> </td></tr></table>}
    {<html> </ul>}
}

# privfields is a list of attributes that should never be shown in
# the search form.
set privfields {}

set body "<BODY BACKGROUND=/images/tiles/stdtile1.jpg BGCOLOR=#FFFFFF TEXT=#000000>"
