
/* qddb/Utils/qedit.c
 * Edit a selected set of records (one at a time) given several
 * sets manipulated by the set operations union, intersection and
 * exclusion.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

int PrintKeyList _ANSI_ARGS_((Schema *, KeyList *));
void EditKeyList _ANSI_ARGS_((Schema *, KeyList *));

#define	USAGE_STRING	"Usage: qedit l|e RelationDir SearchString [-a SearchString] [-o SearchString] [-r RegExp] [-n Number] [-nr Number-Number] [-sr SearchString-SearchString]\n"

void main(argc, argv)
    int			argc;
    char		*argv[];
{
    Schema		*schema;
    char		Relation[BUFSIZ], *ch;
    KeyList		*list, *LastList = NULL;
    size_t		Length;
    int			i;
    enum {
	EDIT, LIST
    }			EditOrList;
    Qddb_SearchArg	arg;
    int			startit;
    
    if (argc < 4) {
	fprintf(stderr, USAGE_STRING);
	fflush(stderr);
	exit(1);
    }
    if (argv[1][0] == 'l')
	EditOrList = LIST;
    else if (argv[1][0] == 'e')
	EditOrList = EDIT;
    else {
	fprintf(stderr, USAGE_STRING);
	fflush(stderr);
	exit(1);
    }
    Qddb_Init();
    
    if ((ch=Qddb_FindRelation(argv[2])) == NULL) {
	fprintf(stderr, "Cannot open relation %s\nPlease set QDDBDIRS.\n", argv[2]);
	fflush(stderr);
	exit(1);
    }
    strcpy(Relation, ch);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    if (strcmp(argv[3], "-r") != 0 && strcmp(argv[3], "-n") != 0 &&
	strcmp(argv[3], "-sr") != 0 && strcmp(argv[3], "-nr") != 0) {
	arg.Type = ALPHA;
	arg.Alpha = argv[3];
	list = Qddb_Search(schema, &arg, &Length, -1);
	LastList = list;
	startit = 4;
    } else
	startit = 3;
    for (i = startit; i < argc; i+=2) {
	char		ch;
	
	ch = argv[i][1];
	if (argv[i][0] != '-') {
	    i--;
	    /* default to intersection, at Raphie's 
	     * request.
	     */
	    ch = 'a';
	}
	switch(ch) {
	case 'a':
	    arg.Type = ALPHA;
	    arg.Alpha = argv[i+1];
	    list = Qddb_Search(schema, &arg, &Length, -1);
	    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_INTERSECTION,
				 QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
	    break;
	case 'o':
	    arg.Type = ALPHA;
	    arg.Alpha = argv[i+1];
	    list = Qddb_Search(schema, &arg, &Length, -1);
	    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION,
				 QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
	    break;
	case 'r':
	    arg.Type = REGEXP_V8;
	    arg.Alpha = argv[i+1];
	    list = Qddb_Search(schema, &arg, &Length, -1);
	    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION,
				 QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
	    break;
	case 'n':
	    if (argv[i][2] == 'r') {
		char		*range;
		
		arg.LowerExists = (argv[i+1][0] != '-');
		arg.UpperExists = (argv[i+1][strlen(argv[i+1])-1] != '-');
		range = argv[i+1];
		if (arg.LowerExists == True) {
		    int		index, len;
		    
		    len = strlen(argv[i+1]);
		    for (index = 0; index < len; index++)
			if (argv[i+1][index] == '-')
			    break;
		    argv[i+1][index] = '\0';
		    arg.LowerNum = strtod(argv[i+1], NULL);
		    range = argv[i+1]+index+1;
		} else {
		    arg.LowerNum = 0.0;
		    range++;
		}
		if (arg.UpperExists == True)
		    arg.UpperNum = strtod(range, NULL);
		else
		    arg.UpperNum = 0.0;
		arg.Type = NUMERICRANGE;
	    } else {
		arg.Type = NUMERIC;
		arg.Number = strtod(argv[i+1], NULL);
	    }
	    list = Qddb_Search(schema, &arg, &Length, -1);
	    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION,
				 QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
	    break;
	case 's':
	    if (argv[i][2] == 'r') {
		char		*range, *tmpstr;
		unsigned int	z, len;
		
		len = strlen(argv[i+1]);
		tmpstr = Malloc(len);
		strcpy(tmpstr, argv[i+1]);
		for (z = 0; z < len; z++)
		    if (_isupper(tmpstr[z]))
			tmpstr[z] = _tolower(tmpstr[z]);
		arg.LowerExists = (tmpstr[0] != '-');
		arg.UpperExists = (tmpstr[len-1] != '-');
		range = tmpstr;
		if (arg.LowerExists == True) {
		    int		index, len;
		    
		    len = strlen(tmpstr);
		    for (index = 0; index < len; index++)
			if (tmpstr[index] == '-')
			    break;
		    tmpstr[index] = '\0';
		    arg.LowerStr = tmpstr;
		    range = tmpstr+index+1;
		} else {
		    arg.LowerStr = NULL;
		    range++;
		}
		if (arg.UpperExists == True)
		    arg.UpperStr = range;
		else
		    arg.UpperStr = NULL;
		list = Qddb_Search(schema, &arg, &Length, -1);
		LastList = Qddb_KeyListOp(schema, list, LastList,QDDB_KEYLIST_OP_UNION,
			QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
	    } else
		PANIC("Bad option -s");
	    break;
	default:
	    fprintf(stderr, "Unknown option: %s\n", argv[i]);
	    PANIC("Cannot handle option");
	}
    }
    LastList = Qddb_KeyListProcess(schema, LastList, NULL, QDDB_KEYLIST_PROC_NULLOP,
				 QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
    if (EditOrList == LIST)
	PrintKeyList(schema, LastList);
    else {
	EditKeyList(schema, LastList);
    }
    exit(0);
}

int PrintKeyList(schema, list)
    Schema		*schema;
    KeyList		*list;
{
    char		*RelationFN = schema->RelationName, *output;
    Entry		ThisEntry;
    int			DBFile;

    DBFile = OpenDatabase(RelationFN, 0);
    ThisEntry = NULL;
    while (list != NULL) {
	if (Qddb_ReadEntryByKeyList(DBFile, RelationFN, &ThisEntry, list, True) == -1) {
	    list = list->next;
	    continue;
	}
	Qddb_ReducedAttrToFullAttr(schema, ThisEntry);
	output = (char *)Qddb_Convert(schema, QDDB_ENTRYTYPE_EXTERNAL, ThisEntry, QDDB_ENTRYTYPE_HTML);
	fprintf(stdout, "%s\n", output);
	list = list->next;
    }
    close(DBFile);
    return 0;
}
