#!/bin/sh
#
# updthome.sh -	span /home dir creating default homepages
#
#	Usage: updthome.sh TEMPLATE
#
#	This script removes any autogenerated homepages so that they
#	get replaced with the new ones. The TEMPLATE is a qsub template;
#	qsub is used to put actual values from the Clients database into
#	the indicated places in the template.
#

#
# paths etc:
#
WWWGROUP="www"
WWWUTIL="/var/lib/WWWutil"
PAGEMAKE=$WWWUTIL/pagemake
HOMEBASE=/home
PUBHTML="public_html"
HOMEPAGE=$PUBHTML/index.spider
ALTHOMEPAGE=$PUBHTML/index.html

 RELATION=Clients
 KEYFIELD=Company.Contact.UID

 tmpfile=/tmp/updthome.$$

#
# do it
#


 STYLE=$1
if [ -z $STYLE ]; then
  echo "Usage: updthome.sh <template>"
  exit 1
fi

cd /home
for u in * ; do
  if [ -d $u ]; then
    if [ ! -d $u/public_html ]; then
      mkdir $u/public_html
      chown $u.$WWWGROUP $u/$PUBHTML
      chmod g+w $u/$PUBHTML
    fi
    if [ -f $u/$HOMEPAGE ]; then
      # if old page was autogenerated, remove it
      grep "<!-- Autogenerated" $u/$HOMEPAGE && rm $u/$HOMEPAGE
    fi
    if [ ! -f $u/$HOMEPAGE -a ! -f $u/$ALTHOMEPAGE ]; then
      echo $u
      KEY=`id -u $u`
      $PAGEMAKE/qsub $RELATION $KEYFIELD $KEY $PAGEMAKE/$STYLE > $tmpfile
      cp $tmpfile $u/$HOMEPAGE
      chown $u.$WWWGROUP $u/$HOMEPAGE
      chmod g+w $u/$HOMEPAGE
      rm -f $tmpfile
    fi
  fi
done
