#!/usr/bin/perl -s

# PFind Copyright (C) 1996 Dale Bewley <dbewley@iupui.edu>
#
# Heavily modified by MarkM - markm@knotwork.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#######################################################################


#- User Configurable Variables -----------------------------------------#
$ENV{'PATH'} = '/usr/bin';	# where grep, awk, and finger are located
$WEBSERVER = "www";		# local web server
$WEBDIR = "public_html";		# default HTML directory
	# URL location of PTFIND HTML (output)
$PTFIND_HTML = "/users/homepageu.spider";
	# index in sorted order, can include upper case and numbers
$SORTKEYS = "abcdefghijklmnopqrstuvwxyz";
$ULIMIT = -1;			# maximum users from passwd -1 for all
$MAX_WIDTH = 70;		# more than this starts new line.
$AWK = "awk";			# Specify awk, gawk, nawk ...
#-----------------------------------------------------------------------#
#- Main Program --------------------------------------------------------#
#-----------------------------------------------------------------------#

($sec, $min, $hour, $mday, $mon, $year) = localtime($^T);
$mon++;		#the month is one behind

&findPages;

# default HTML output
&introHTML;
# customize these lines and corresponding lines in printTable routine
&printTable(*studentPages, "User Pages");
#&printTable(*facultyPages, "Business Pages");
&printTable(*staffPages, "Staff Pages");
&summary;
&finalHTML;

#- Print Introductory Information ---------------------------------------#
sub introHTML {
	print "<INSERT FILE=/macros.inc>\n";
	print "<INSERT NAME=HEAD TITEL=\"Homepages on $WEBSERVER\">\n\n";
	print "  Of $uCount user logins, $lCount have readable\n";
	print " index.spider or index.html homepages.\n";
	print "  </P>\n  <HR>\n";
# customize these lines and corresponding lines in printTable routine
	print "  User pages: \n";
	print "  <A HREF=\"$PTFIND_HTML#a_student\">A</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#b_student\">B</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#c_student\">C</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#d_student\">D</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#e_student\">E</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#f_student\">F</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#g_student\">G</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#h_student\">H</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#i_student\">I</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#j_student\">J</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#k_student\">K</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#l_student\">L</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#m_student\">M</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#n_student\">N</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#o_student\">O</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#p_student\">P</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#q_student\">Q</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#r_student\">R</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#s_student\">S</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#t_student\">T</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#u_student\">U</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#v_student\">V</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#w_student\">W</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#x_student\">X</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#y_student\">Y</A>\n";
	print "  <A HREF=\"$PTFIND_HTML#z_student\">Z</A><P>\n";
	print "  <A HREF=\"$PTFIND_HTML#faculty\">\n";
#	print "  <FONT SIZE=+1><STRONG>Business Pages</STRONG></FONT></A>\n";
#	print "  <P>\n";
	print "  <A HREF=\"$PTFIND_HTML#staff\">\n";
	print "  <FONT SIZE=+1><STRONG>Staff Pages</STRONG></FONT></A><BR>\n";
	print "  <HR SIZE=4>\n";
}	

#- Find User Pages -------------------------------------------------------#
sub findPages {
	setpwent;
	while ((@list = getpwent) && ($uCount != $ULIMIT)) {
      	$uCount++;
      	($login, $gid, $realName, $home) = @list[0,3,6,7];
# customize these lines according your sites default HTML doc names
		if ((-d "$home/$WEBDIR") && (-x 
		 "$home/$WEBDIR") && ((-e
		 	"$home/$WEBDIR/index.spider") && (-T 
		 	"$home/$WEBDIR/index.spider") && (-r 
		 	"$home/$WEBDIR/index.spider") && (-s
		 	"$home/$WEBDIR/index.spider")) 
		 || ((-e "$home/$WEBDIR/index.html") && (-T 
		 	"$home/$WEBDIR/index.html") && (-r 
		 	"$home/$WEBDIR/index.html") && (-s
		 	"$home/$WEBDIR/index.html"))
		)
		{
# customize these lines according your sites default HTML doc names
			if (-e "$home/$WEBDIR/index.spider") {
				$homePage = "$home/$WEBDIR/index.spider";
			}
			else {$homePage = "$home/$WEBDIR/index.html"};
# {
#				if (-e "$home/$WEBDIR/index.html") {
#					$homePage = "$home/$WEBDIR/index.html";
#				}
#			}
			$lCount++;
# customize these lines and corresponding lines in printTable routine
			$anchorText = "$realName";
			$pageList{$login} = $anchortext;
			$GRPS = `id -Gn $login`;
			$staffPages{$login} = $anchorText if (index($GRPS,"sales") >0);
			$staffPages{$login} = $anchorText if (index($GRPS,"staff") >0);
			$staffPages{$login} = $anchorText if (index($GRPS,"sysop") >0);
			$facultyPages{$login} = $anchorText if ($home =~ /business/);
			$studentPages{$login} =  $anchorText if ($home =~ /home/);

		}
	}
	endpwent;
}


#- Print Results in Table Format ---------------------------------------------#
sub printTable {
	# Arguments passed are an associative array of pages and a caption.
	local(*pageList, $tableTitle) = @_;
	local($widthCount) = 0;
	$pageCount = keys %pageList;
	local($sortKeyIndex) = 0;

# customize these lines and corresponding lines in printTable routine
	if ($tableTitle eq "User Pages") {
		$section = substr($SORTKEYS,$sortKeyIndex,1);
		print "  <H2>$tableTitle</H2>\n";
		print "<TABLE CELLPADDING=4>\n";
		print "<TR><P><TD COLSPAN=2>\n";
		print "<A NAME=\"$section";
		print "_student\">".uc($section);
		print "</A></TD></TR>\n";
	}
	if ($tableTitle eq "Business Pages") {
		print "  <H2><A NAME=\"faculty\">$tableTitle</A></H2>\n";
		print "<TABLE CELLPADDING=4>\n";
	}
	if ($tableTitle eq "Staff Pages") {
		print "  <H2><A NAME=\"staff\">$tableTitle</A></H2>\n";
		print "<TABLE CELLPADDING=4>\n";
	}
	foreach $login (sort keys %pageList) {
		if ($tableTitle eq "User Pages") {
			while ($section lt substr($login,0,1)) {
				++$sortKeyIndex;
				$section = substr($SORTKEYS,$sortKeyIndex,1);
				print "</TABLE><TABLE CELLPADDING=4>\n";
				print "<TR><P><TD COLSPAN=2>\n";
				print "<A NAME=\"$section";
				print "_student\">".uc($section);
				print "</A></TD></TR>\n";
			}
		}
# Following line may have to be customized
		print "<TR><P><TD> <A HREF=\"/~$login/\">$login</A></TD>\n";
		print "<TD> <A HREF=\"/~$login/\">$pageList{$login}</A></TD></TR>\n";
	}
	print "</TABLE>\n";
	print "\n  <P>$pageCount $tableTitle</P><HR SIZE=4>\n";
}

#- Print Summary Information -------------------------------------------------#
sub summary {

	($fsec, $fmin, $fhour, $mday, $mon, $year) = localtime(time);
	$mon++;

	print "</P>\n";
}

#- Print Final HTML Tags ----------------------------------------------------#
sub finalHTML {
	printf ("<P><FONT SIZE=-1>Begun @ %02d/%02d/%02d %02d:%02d:%02d\n", 
                $mday, $mon, $year, $hour, $min, $sec);
	printf ("  Finished @ %02d/%02d/%02d %02d:%02d:%02d</FONT>\n", 
                $mday, $mon, $year, $fhour, $fmin, $fsec);
	print "<INSERT NAME=END>\n";
}
