#!/bin/sh
#
# gwstat.sh -	Run gwstat for virtual server specified
#
#	Usage:	gwstat.sh <server>
#
#	NOTE: set up for roxen server with site in /var/lib/www/pub
#


# where to search 'gs'
PATH=/bin:/usr/bin:/usr/local/bin
export PATH

if [ "$1" = "" ]; then
  server=public
else
  server=$1
fi

pidfile=/var/run/roxen_pid:0
logdir=/usr/local/roxen/logs/$server

if [ "$server" = "public" ]; then
  statsdir=/var/lib/www/pub/stats
else
  statsdir=/var/lib/www/$server/pub/stats
fi

gwstat=/usr/local/bin/gwstat

#
# should be boilerplate from here on down
#

# $oldresult is the stats up to the beginning of the month
# this file is used as the base to compute $wwwresult
# and is updated at the beginning of each month

oldresult=$statsdir/oldwwwstats.html

# $wwwresult is updated every hour
# will use $oldresult as the base

wwwresult=$statsdir/wwwstats.html


# the day of today
day="`/bin/date +'%d'`"
time="`/bin/date +'%H'`"

# log files
access=$logdir/Log
#error=$logdir/error_log

# backup files to store all the accesses
oldaccess=$logdir/Log_archive
#olderror=$logdir/error_archive

# stop httpd first if it is at the beginning of the month, then
# append log files to the corresponding backup files

#if  [ "$day" -eq 1 -a "$time" -eq 0 ]; then
if  [ "$day" -eq 1 ]; then
	/bin/kill -9 `/bin/cat $pidfile`
	/bin/cat $access  >>$oldaccess	
#	/bin/cat $error >>$olderror
fi

# get the current $wwwresult incrementally from the $oldresult
/usr/local/bin/wwwstat -R $access>/tmp/wwwstats.html
mv -f /tmp/wwwstats.html $wwwresult


# if it is at the beginning of the month, use the current $wwwresult
# to update $oldresult,  delete $access, $error (since they have been
# appended to the backup files) , restart httpd

if [ "$day" -eq 1 -a  "$time" -eq 0 ]; then
	cp $wwwresult $oldresult
#	cp /tmp/htmls.html $oldhtmls
	rm -f $access $error
	pushd /usr/local/roxen/server
	./start
	popd
fi


# use the current wwwstat file to generate all the gifs
$gwstat -i $wwwresult -d $statsdir -R recent -b blue -f yellow
$gwstat -i $wwwresult -d $statsdir -D daily -b RosyBrown -f brown -o RosyBrown
$gwstat -i $wwwresult -d $statsdir -H hourly -b gray -f brown -o brown
$gwstat -i $wwwresult -d $statsdir -W weekly -b turquoise -f DarkViolet
$gwstat -i $wwwresult -d $statsdir -M monthly -b gray -f blue
$gwstat -i $wwwresult -d $statsdir -Y yearly -f "red blue"
$gwstat -i $wwwresult -d $statsdir -C country -n 
$gwstat -i $wwwresult -d $statsdir -n -A archive -b blue -f white -o blue 

### compose (from ImageMagick) the chip files into stats.gif (for imagemap)
### 
all=/tmp/all.gif

cd $statsdir

/usr/bin/combine +display -geometry +32+97 -size 100x100 \
-compose replace archive-chip.gif base.gif $all

/usr/bin/combine +display -geometry +196+97 -size 100x100 \
-compose replace country-chip.gif $all $all

/usr/bin/combine +display -geometry +360+97 -size 100x100  \
-compose replace hourly-chip.gif  $all $all

/usr/bin/combine +display -geometry +32+281 -size 100x100  \
-compose replace daily-chip.gif  $all $all

/usr/bin/combine +display -geometry +196+281 -size 100x100  \
-compose replace weekly-chip.gif $all $all

/usr/bin/combine +display -geometry +360+281 -size 100x100  \
-compose replace monthly-chip.gif $all $all

/usr/bin/combine +display -geometry +32+465 -size 100x100  \
-compose replace yearly-chip.gif $all $all

/usr/bin/combine +display -geometry +196+465 -size 100x100  \
-compose replace recent-chip.gif $all $all

mv $all stats.gif

exit
