#!/usr/bin/perl
###########################################################################
#    WWWThreads  - Interactive Discussion Forum
#    Copyright (C) 1998  Rick Baker	rbaker@techline.com
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
########################################################################### 
require 'wwwthread_variables.pl';
require 'wwwthread_utilities.pl';

#***********************************************************************
# Call the Main Routines
#***********************************************************************

&get_input;			# Get the Input
&assign_query;			# Assign Query String to variables
&determine;			# Determine what the user is tryint to do

exit;				# End of Program

#***********************************************************************
# Assign_Query; Assign query String to Variables
#***********************************************************************

sub assign_query{

   $action=$FORM{'action'};
   $admin=$FORM{'admin'};

}

#***********************************************************************
# Determine; Determine what the user is trying to do
#***********************************************************************

sub determine{

   if($action eq ""){
      &log_on;
   }
   if($action eq "verify"){
      &verify;
   }
   if($action eq "editadmin"){
      &edit_admin;
   }
   if($action eq "updateadmin"){
      &update_admin;
   }
   if($action eq "createboard"){
      &create_board;
   }
   if($action eq "insertboard"){
      &insert_board;
   }
   if($action eq "deleteboard"){
      &delete_board;
   }
   if($action eq "removeboard"){
      &remove_board;
   }
   if($action eq "editboard"){
      &edit_board;
   }
   if($action eq "alterposts"){
      &alter_posts;
   }
   if($action eq "removeposts"){
      &remove_posts;
   }
   if($action eq "modifyposts"){
      &modify_posts;
   }
   if($action eq "makechange"){
      &make_change;
   }
   if($action eq "archiveboard"){
      &archive_board;
   }
   if($action eq "doarchive"){
      &do_archive;
   }
   if($action eq "editprop"){
      &edit_prop;
   }
   if($action eq "do_prop"){
      &do_prop;
   }
   if($action eq "changeprop"){
      &change_prop;
   }
   if($action eq "edituser"){
      &edit_user;
   }
   if($action eq "list_user"){
      &list_user;
   }
   if($action eq "change_user"){
      &change_user;
   }
   if($action eq "do_user"){
      &do_user;
   }
}

#***********************************************************************
# Show_Index; Show all the boards
#***********************************************************************

sub log_on{

   $whichmenu="top_admin";
   &admin_header;
   &get_cookie;
   print"<FORM METHOD=post action=\"$cgiurl/wwwthread_admin.cgi\">";
   print"<input type=hidden name=action value=verify>\n";

print<<STUFF;
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 WIDTH=100%>
   <TR>
      <TD class=dark>
         <P>This area is open to Administrators only. If you have a
         valid Username and Password to enter this area please enter
         it below to log on.
      </TD></TR>
   <TR>
      <TD class=light>
         <P>Username <INPUT TYPE="text" NAME="admin"
VALUE="$cookie{'adminname'}" SIZE=30>
         </P>

         <P>Password <INPUT TYPE="password" NAME="password"
VALUE="$cookie{'adminpass'}"
         SIZE=30></P>

         <P><INPUT TYPE="submit" NAME="Submit"
         VALUE="Submit"><INPUT TYPE="reset" VALUE="Reset">
      </TD></TR>  
STUFF
   &index_footer;

}

#***********************************************************************
# Verify
#***********************************************************************

sub verify{

   dbmopen(%DB,$board_db,0666)||&not_right_info($info = "Couldn't open the
database '$board_db'");

   if($FORM{'admin'} ne $DB{'USER'}){

      $info="Invalid Username for this area.";
      &not_right_info;
   }
   if($FORM{'password'} ne $DB{'PASSWORD'}){

      $info="Invalid Password for that UserId.";
      &not_right_info;

   }
   dbmclose(%DB);

   $Cookie_Exp_Date="";

&set_cookie("adminname","$FORM{'admin'}","adminpass","$FORM{'password'}");

   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;

print<<STUFF;

<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 WIDTH=100%>
<TR>
<TD class=dark colspan=2>
<B><FONT SIZE="-1">Welcome to the WWWThread Administration Package. By
using the links below you can administer your forums. There is a brief
explanation next to each administration feature.</FONT></B>
</TD></TR>
<TR>
<TD class=light valign=top>

<a href="$cgiurl/wwwthread_admin.cgi?action=editadmin&admin=$admin"> 
Edit Admin</a>
</TD><TD class=light>
This will let you change the current Administrator name or
password.
<br><br>
</td></tr><tr><td class=light valign=top> 
<a href="$cgiurl/wwwthread_admin.cgi?action=createboard&admin=$admin"> 
Create Board</a>
</td><td class=light>
This will let you set up another discussion board.<br><br>
</td></tr><tr><td class=light valign=top>
<a href="$cgiurl/wwwthread_admin.cgi?action=editboard&admin=$admin"> 
Edit Posts</a>
</td><td class=light>
This will let you edit or delete posts, etc.<br><br>
</td></tr><tr><td class=light valign=top>
<a href="$cgiurl/wwwthread_admin.cgi?action=editprop&admin=$admin">
Edit Board Properties
</td><td class=light>
This will let you change the title or description of a board. You can
also disable or enable HTML in posts.<br><br>
</td></tr><tr><td class=light valign=top>
<a href="$cgiurl/wwwthread_admin.cgi?action=archiveboard&admin=$admin">
Archive Board
</td><td class=light>
This will let you move all of the current posts on a board to an
archive. All archives for a particular forum will be listed at the bottom
of that forum's index.<br><br>
</td></tr><tr><td class=light valign=top>
<a href="$cgiurl/wwwthread_admin.cgi?action=deleteboard&admin=$admin"> 
Delete Board</a>
</td><td class=light>
This will let you delete an entire board.<br><br>
</td></tr><tr><td class=light valign=top>
<a href="$cgiurl/wwwthread_admin.cgi?action=edituser&admin=$admin">
Edit Users</a>
</td><td class=light>
This will let you view, edit or delete registered users
<br><br>
         
<P>&nbsp;
</TD></TR>
</TABLE><TABLE BORDER=0 WIDTH=100%>
   <TR>
      <TD>
         <CENTER><B><FONT
         SIZE="-2"><A
HREF="http://www.screamingweb.com/wwwthreads">WWWThreads
         Version 2.7.1</A></FONT><FONT SIZE="-2"><BR>
         
      </TD></TR>
</TABLE></P>
</BODY>
</HTML>

STUFF
}

#***********************************************************************
# Edit_admin
#***********************************************************************

sub edit_admin{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   
   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");
   
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="updateadmin">
   <input type=hidden name=admin value="$admin">
   <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   Below is the current username - password for the administrator. You may
change this if you want.
   </td></tr><tr><td class=light>
   Username 
   </td><td class=light>
   <input type=text name=name value="$DB{'USER'}">
   </td></tr><tr><td class=light>
   Password 
   </td><td class=light>
   <input type=password name=password value="$DB{'PASSWORD'}">
   </td></tr><tr><td class=light>
   Verify 
   </td><td class=light>
   <input type=password name=verify value="$DB{'PASSWORD'}"><br>
   </td></tr><tr><td class=light colspan=2>
   <input type=submit value=submit>
   </td></tr>

STUFF
dbmclose(%DB);
&index_footer;

}

#***********************************************************************
# Create_Board
#***********************************************************************

sub create_board{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   $name=$FORM{'name'};
   &admin_header;
   
   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");
   
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="insertboard">
   <input type=hidden name=admin value="$admin">
   <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   Fill in the fields below to create a new discussion board.
   </td></tr><tr><td class=light>
   Title
   </td><td class=light>
   <input type=text name=title value="">
   </td></tr><tr><td class=light>
   Description
   </td><td class=light>
   <input type=text name=description value="">
   </td></tr><tr><td class=light>
   Keyword
   </td><td class=light>
   <input type=text name=keyword value=""><br>
   </td></tr><tr><td class=light colspan=2>
   <input type=submit value=submit>
   </td></tr>

STUFF

&index_footer;

}

#***********************************************************************
# Delete_Board
#***********************************************************************

sub delete_board{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   
   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");
    
  
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="removeboard">
   <input type=hidden name=admin value="$admin">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   By placing a checkmark by the boards below you will be marking them for
deletion. Make sure this is what you want to to. Once deleted there is no
way to recover the information.
   </td></tr><tr><td class=light>

STUFF

   $total=$DB{'BOARDS'};
   for($i=1;$i<=$total;$i++){
      $bname="BOARD"."$i";
      if($DB{$bname}){
      @bstuff=split(/\t/,$DB{$bname});
      print"<input type=radio name=board value=$bname>
@bstuff['1']<br>\n"; 
         if(@bstuff['3']){
            for($a=1;$a<=@bstuff['3'];$a++){
               $arch="@bstuff['0']".".archive"."$a";
               if($DB{$arch}){
                  print"<input type=radio name=board value=$arch>@bstuff['1'] archive $a<br>\n";
               }
            }
         }

   } }

print<<STUFF;
   <input type=hidden name=total value=$total>
   </td></tr><tr><td class=light colspan=2>
   <input type=submit value=submit>
   </td></tr>

STUFF

&index_footer;

}

#***********************************************************************
# Remove Board
#***********************************************************************

sub remove_board{

   &verify_admin;

   dbmopen(%DB,$board_db,0666)||&not_right_info($info = "Couldn't open the
database '$board_db'");

   &Lock_File("$board_db"); 
   $which=$FORM{'board'};
   if($which=~/.archive/){

      opendir(DIR,"$data_db/$which")||&not_right_info($info = "Couldn't
open the directory '$data_db/$which'");

      @files=readdir(DIR);
      closedir(DIR);
      chdir("$data_db/$which");
      unlink(@files);
      chdir("$data_db");
      rmdir("$data_db/$which");
      delete($DB{$which});
      chdir("$cgipath");
   }else{
      @whichb=split(/\t/,$DB{$which});
      $bname="@whichb['0']";
      $num=$which;
      $num=~s/BOARD//g;     
      $bdate="DATE"."$num";

      opendir(DIR,"$data_db/$bname")||&not_right_info($info = "Couldn't
open the directory '$data_db/$bname'");

      @files=readdir(DIR);
      closedir(DIR);
      chdir("$data_db/$bname");
      unlink(@files);
      chdir("$data_db");
      rmdir("$data_db/$bname");
      unlink("$bname.db");
      unlink("$bname.dir");
      unlink("$bname.pag");
      chdir("$cgipath");
      delete($DB{$which});
      delete($DB{$bdate});
 
  }
  &Unlock_File("$board_db");
  dbmclose(%DB);

   &admin_thanks;
   open(FILE,"adminthanks.html");

   while(<FILE>){
      print "$_";
   } 
   &index_footer;
}

#***********************************************************************
# Insert Board
#***********************************************************************

sub insert_board{

   &verify_admin;
   &get_date;

   dbmopen(%DB,$board_db,0666)||&not_right_info($info = "Couldn't open the
database '$board_db'");

   $DB{'BOARDS'}++;
   $bonum="BOARD"."$DB{'BOARDS'}";
   $bodate="DATE"."$DB{'BOARDS'}";
   $line="$FORM{'keyword'}"."\t"."$FORM{'title'}"."\t"."$FORM{'description'}";
   $DB{$bonum}=$line;
   $DB{$bodate}=$fulldate;
   dbmclose(%DB);

   $keyword=$FORM{'keyword'};
   $message_db="$data_db/$keyword";
   dbmopen(%DB,$message_db,0666)||&not_right_info($info = "Couldn't open
the database '$message_db'");

   $DB{'TOTAL'}=0;
   $DB{'POSTS'}=0;
   dbmclose(%DB);

   mkdir("$data_db/$keyword$ext",0775)||&not_right_info($info ="Couldn't
make the directory '$data_db/$keyword$ext'");

   &admin_thanks;
   open(FILE,"adminthanks.html")||&not_right($info = "Couldn't open the
file 'adminthanks.html'");

   while(<FILE>){
      print "$_";
   }
   &index_footer;
}   

#***********************************************************************
# Edit_Board
#***********************************************************************

sub edit_board{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   
   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");
    
  
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="alterposts">
   <input type=hidden name=admin value="$admin">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   Place a checkmark by the board you wish to edit and then check if you
wish to delete or edit posts.
   </td></tr><tr><td class=light>

STUFF

   $total=$DB{'BOARDS'};
   for($i=1;$i<=$total;$i++){
      $bname="BOARD"."$i";
      if($DB{$bname}){
         @bstuff=split(/\t/,$DB{$bname});
         print"<input type=radio name=board value=$bname>@bstuff['1']<br>\n"; 
         if(@bstuff['3']){
            for($a=1;$a<=@bstuff['3'];$a++){
               $arch="@bstuff['0']".".archive"."$a";
               if($DB{$arch}){
                  print"<input type=radio name=board value=$arch>@bstuff['1'] archive $a<br>\n";
               }
            }
         }
      }

       
   }

print<<STUFF;
   </td></tr><tr><td class=light colspan=2><br><br>
   <input type=radio name=whichedit value=deleteposts> Delete Posts<br>
   <input type=radio name=whichedit value=editposts> Edit Posts
   </td></tr><tr><td class=light colspan=2>
   <input type=submit value=submit>

   </td></tr>

STUFF

&index_footer;

}


#***********************************************************************
# Delete_posts
#***********************************************************************

sub alter_posts{

   if(!($FORM{'board'})){
      $info="You must check a board to edit.";
      &not_right_info;
   }
   if($FORM{'whichedit'} eq "deleteposts"){
      &delete_posts;
   }
   elsif($FORM{'whichedit'} eq "editposts"){
      &edit_posts;
   }
   else{
      $info="You must check edit or delete posts";
      &not_right_info;
   }

}


#***********************************************************************
# Delete_posts
#***********************************************************************

sub delete_posts{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;

   if(!($FORM{'board'})){
      $info="You must select a board to edit";
      &not_right_info;
   }

print<<STUFF;

   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="removeposts">
   <input type=hidden name=admin value="$admin">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   Place a checkmark by the posts you wish to delete and then click the
delete button to remove them from the board. All replies to a marked
message will be deleted as well.
   </td></tr><tr><td class=light>

STUFF

   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
databasae '$board_db'");

   @bstuff=split(/\t/,$DB{$FORM{'board'}});
   dbmclose(%DB);

   if($FORM{'board'}=~/.archive/){
      $bo_db="$data_db/$FORM{'board'}";
      $bo_name=$FORM{'board'};
   }else{
      $bo_db="$data_db"."/"."@bstuff['0']";
      $bo_name="@bstuff['0']";
   }
   dbmopen(%DB,$bo_db,0666)||&not_right($info = "Couldn't open the
databasae '$bo_db'");

   $total=$DB{'TOTAL'};
   print"<input type=hidden name=total value=$total>";
   print"<input type=hidden name=board value=\"$bo_name\">\n";
print"<UL>";
   for($i=$total;$i>=0;$i--){

      if($DB{$i}){

         @stuff=split(/\t/,$DB{$i});
         if((@stuff['0'] eq "Main")){
            $pnum="post"."$i"; 
            print"<li><input type=checkbox name=$pnum>\n";
            print"@stuff['5']";
            print"<font size=-2> post by</font>\n";
            print"@stuff['4']";
            print"<font size=-2> on @stuff['3']</font>\n";
   
            if(@stuff['2']){
               &list_replies;
            }
         }
     }
   }
print"</ul>";
print"</td></tr><tr><td class=light>";

print"<input type=submit value=submit><input type=reset value=reset>";
print"</td></tr>\n";

&index_footer;
dbmclose(%DB);            

}


#***********************************************************************
# List_replies
#***********************************************************************

sub list_replies{

   print"<ul>";
   local(@replies)=split(/,/,@stuff['2']);
   local($i);
   $size=@replies-1;
   for($i=$size;$i>=0;$i--){
       @stuff=split(/\t/,$DB{@replies[$i]});
       $pnum="post"."@replies[$i]";
       print"<li><input type=checkbox name=$pnum>\n";
       print"@stuff['5']";
       print"<font size=-2> post by</font>\n";
       print"@stuff['4']";
       print"<font size=-2> on @stuff['3']</font>\n";
       
       if(@stuff['2']){
          &list_replies;
       }
   }

print"</ul>";
}

#***********************************************************************
# remove_posts
#***********************************************************************

sub remove_posts{

   $board=$FORM{'board'};
   $total=$FORM{'total'};
   $bname="$data_db"."/"."$board";
   dbmopen(%DB,$bname,0666)||&not_right_info($info = "Couldn't open the
database '$bname'");

   &Lock_File("$bname");
   for($i=0;$i<=$total;$i++){
      $yes="post"."$i";
      if($FORM{$yes}){
      $yes=~s/post//;
    if($DB{$yes}){
      @pstuff=split(/\t/,$DB{$yes});
      if(@pstuff['2']){
         &remove_replies;
      }
      @stuff=split(/\t/,$DB{$i});
      $parent=@stuff['1'];
      @stuff=split(/\t/,$DB{$parent});
      $old="$i".",";
      @stuff['2']=~s/$old//;
      $newline=join("\t",@stuff);
      $DB{$parent}=$newline;

      delete($DB{$i});
      # Windows Change
      unlink("$data_db/$board/$i");
      $DB{'POSTS'}--;
      }   
    }
   }
   &Unlock_File("$bname");
   dbmclose(%DB);

   &admin_thanks;
   open(FILE,"adminthanks.html")||&not_right($info = "Couldn't open the
file 'adminthanks.html'");

   while(<FILE>){
      print "$_";
   }
   &index_footer;
}

sub remove_replies{

   local(@replies)=split(/,/,@pstuff['2']);
   local($i);
   $size=@replies-1;
   for($i=$size;$i>=0;$i--){
      @pstuff=split(/\t/,$DB{@replies[$i]});
      delete($DB{@replies[$i]});
      # Windows Change
      unlink("$data_db/$board/@replies[$i]");
      $DB{'POSTS'}--;
      if(@pstuff['2']){
         &remove_replies;
      }
   }
}
#***********************************************************************
# Edit_posts
#***********************************************************************

sub edit_posts{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;

   if(!($FORM{'board'})){
      $info="You must select a board to edit";
      &not_right_info;
   }

print<<STUFF;

   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="modifyposts">
   <input type=hidden name=admin value="$admin">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   Select the post you would like to edit and then press submit.
   </td></tr><tr><td class=light>

STUFF

   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");
   
   @bstuff=split(/\t/,$DB{$FORM{'board'}});
   dbmclose(%DB);
   if($FORM{'board'}=~/.archive/){
      # Windows Change
      $bo_db="$data_db"."/"."$FORM{'board'}";
      $bo_name=$FORM{'board'};
   }else{
      # Windows Change
      $bo_db="$data_db"."/"."@bstuff['0']";
      $bo_name="@bstuff['0']";
   }
   dbmopen(%DB,$bo_db,0666)||&not_right($info = "Couldn't open the
database '$bo_db'");

   $total=$DB{'TOTAL'};
   print"<input type=hidden name=total value=$total>";
   print"<input type=hidden name=board value=\"$bo_name\">\n";
print"<UL>";
   for($i=$total;$i>=0;$i--){

      if($DB{$i}){

         @stuff=split(/\t/,$DB{$i});
         if((@stuff['0'] eq "Main")){
            print"<li><input type=radio name=post value=$i>\n";
            print"@stuff['5']";
            print"<font size=-2> post by</font>\n";
            print"@stuff['4']";
            print"<font size=-2> on @stuff['3']</font>\n";
   
            if(@stuff['2']){
               &list_edit_replies;
            }
         }
     }
   }
print"</ul>";
print"</td></tr><tr><td class=light>";

print"<input type=submit value=submit><input type=reset value=reset>";
print"</td></tr>\n";

&index_footer;
dbmclose(%DB);            

}

sub list_edit_replies{

   print"<ul>";
   local(@replies)=split(/,/,@stuff['2']);
   local($i);
   $size=@replies-1;
   for($i=$size;$i>=0;$i--){
       @stuff=split(/\t/,$DB{@replies[$i]});
       $pnum="post"."@replies[$i]";
       print"<li><input type=radio name=post value=\"@replies[$i]\">\n";
       print"@stuff['5']";
       print"<font size=-2> post by</font>\n";
       print"@stuff['4']";
       print"<font size=-2> on @stuff['3']</font>\n";
       
       if(@stuff['2']){
          &list_edit_replies;
       }
   }

print"</ul>";
}


#***********************************************************************
# Modify_Posts
#***********************************************************************

sub modify_posts{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   $which_db="$data_db/"."$FORM{'board'}";
   dbmopen(%DB,$which_db,0666)||&not_right($info = "Couldn't open the
database '$which_db'");

   @bstuff=split(/\t/,$DB{$FORM{'post'}});

open(FILE,"$data_db/$FORM{'board'}/$FORM{'post'}$ext")||&not_right($info
= "Couldn't open the file '$data_db/$FORM{'board'}$FORM{'post'}$ext'");

   @post=<FILE>;
   close(FILE);
   $post=join(/ /,@post);
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="makechange">
   <input type=hidden name=board value="$FORM{'board'}">
   <input type=hidden name=postnum value="$FORM{'post'}">
   <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   Subject <input type=text name=subject value="@bstuff['5']">
   </td></tr><tr><td class=light>
   <p>Post:
   <p><TEXTAREA NAME="post" ROWS=10 COLS=60
wrap=soft>$post</TEXTAREA>
   <p><input type=submit value=submit>
   </td></tr>

STUFF
dbmclose(%DB);
&index_footer;

}

#***********************************************************************
# Make_Change
#***********************************************************************

sub make_change{

   dbmopen(%DB,"$data_db/$FORM{'board'}",0666)||&not_right_info($info =
"Couldn't open the database '$data_db/$FORM{'board'}'");

   @stuff=split(/\t/,$DB{$FORM{'postnum'}});
   @stuff['5']=$FORM{'subject'};
   $line=join("\t",@stuff);
   $DB{$FORM{'postnum'}}=$line;
   dbmclose(%DB);

open(FILE,">$data_db/$FORM{'board'}/$FORM{'postnum'}$ext")||&not_right_info($info 
= "Couldn't open the file '$data_db/$FORM{'board'}/$FORM{'postnum'}$ext'");

   print FILE"$FORM{'post'}";
   close(FILE);
   &admin_thanks;
   open(FILE,"adminthanks.html")||&not_right($info = "Couldn't open the
file 'adminthanks.html'");

   while(<FILE>){
      print "$_";
   }
   &index_footer;

}

#***********************************************************************
# Update_admin
#***********************************************************************

sub update_admin{

   if(!($FORM{'name'})){
      $info = "You have to choose a username";
      &not_right_info;
   }
   if(($FORM{'password'})ne($FORM{'verify'})){
      $info="Password was not typed the same both times.";
      &not_right_info;
   }

   dbmopen(%DB,$board_db,0666)||&not_right_info($info = "Couldn't open the
database '$board_db'");

   $DB{'USER'}=$FORM{'name'};
   $DB{'PASSWORD'}=$FORM{'password'};
   dbmclose(%DB);

   &admin_thanks;
   open(FILE,"adminthanks.html")||&not_right($info = "Couldn't open the
file 'adminthanks.html'");

   while(<FILE>){
      print "$_";
   }
   &index_footer;
}

#***********************************************************************
# Verify_admin
#***********************************************************************

sub verify_admin{

   dbmopen(%DB,$board_db,0666)||&not_right_info($info = "Couldn't open the
database '$board_db'");

   if($admin ne $DB{'USER'}){

      print"Location: $cgiurl/wwwthread_admin.cgi\n\n";

   }
   dbmclose(%DB);
}

#***********************************************************************
# Archive_Board
#***********************************************************************

sub archive_board{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   
   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");
    
  
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="doarchive">
   <input type=hidden name=admin value="$admin">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   By placing a checkmark by the boards below you will be marking them for
archival. This will remove all of the posts from the current board and
move them to a archive.
   </td></tr><tr><td class=light>

STUFF

   $total=$DB{'BOARDS'};
   for($i=1;$i<=$total;$i++){
      $bname="BOARD"."$i";
      if($DB{$bname}){
         if(!(@bstuff['0']=~/.archive/)){
      @bstuff=split(/\t/,$DB{$bname});
      print"<input type=checkbox name=$bname> @bstuff['1']<br>\n"; 
   } }  }

print<<STUFF;
   <input type=hidden name=total value=$total>
   </td></tr><tr><td class=light colspan=2>
   <input type=submit value=submit>
   </td></tr>

STUFF

&index_footer;

}

#***********************************************************************
# Do_archive
#***********************************************************************

sub do_archive{

   &verify_admin;

   dbmopen(%DB,$board_db,0666)||&not_right_info($info = "Couldn't open the
database '$board_db'");

   $total=$FORM{'total'};
   for($i=1;$i<=$total;$i++){
      $bname="BOARD"."$i";
      $bdate="DATE"."$i";

      if($FORM{$bname}){
         @bstuff=split(/\t/,$DB{$bname});
         $archivenum=@bstuff['3'];
         $archivenum++;

         $archive="$data_db/"."@bstuff['0']".".archive$archivenum";
         $old="$data_db/"."@bstuff['0']";
         rename("$old$ext","$archive$ext");
         mkdir("$old$ext",0777)||&not_right_info($info = "Couldn't make
the directory '$old$ext'");

         dbmopen(%DC,$old,0666)||&not_right_info($info = "Couldn't open
the database '$old'");

         dbmopen(%DD,$archive,0666)||&not_right_info($info = "Couldn't
open the database '$archive'");

         foreach $var (sort(keys(%DC))){
            $DD{$var} = $DC{$var};
         }
         dbmclose(%DC);
         dbmclose(%DD);
         $temp="$old".".db";
         unlink($temp);
         $temp="$old".".dir";
         unlink($temp);         
         $temp="$old".".pag";
         unlink($temp);

         dbmopen(%DATA,$archive,0666)||&not_right_info($info = "Couldn't
open the database '$archive'");

         dbmopen(%DD,$old,0666)||&not_right_info($info = "Couldn't open
the database '$old'");

         $DD{'TOTAL'}=$DATA{'TOTAL'};
         dbmclose(%DD);
         dbmclose(%DATA);


         $fixit="@bstuff['0']"."\t"."@bstuff['1']"."\t"."@bstuff['2']"."\t"."$archivenum";
         $DB{$bname}=$fixit;
         $arcdate=$DB{$bdate};
         $DB{$bdate}="";

         $newarchive="@bstuff['0']".".archive"."$archivenum";

         $DB{$newarchive}=$arcdate;
      }
 
  }

  dbmclose(%DB);

   &admin_thanks;
   open(FILE,"adminthanks.html")||&not_right($info = "Couldn't open the
file 'adminthanks.html'");

   while(<FILE>){
      print "$_";
   }
   &index_footer; 

}

#***********************************************************************
# Edit_Prop
#***********************************************************************

sub edit_prop{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   
   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");
    
  
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="do_prop">
   <input type=hidden name=admin value="$admin">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   Place a checkmark by the board you wish to edit.
   </td></tr><tr><td class=light>

STUFF

   $total=$DB{'BOARDS'};
   for($i=1;$i<=$total;$i++){
      $bname="BOARD"."$i";
      if($DB{$bname}){
         @bstuff=split(/\t/,$DB{$bname});
         print"<input type=radio name=board value=$bname>@bstuff['1']<br>\n"; 
         if(@bstuff['3']){
            for($a=1;$a<=@bstuff['3'];$a++){
               $arch="@bstuff['0']".".archive"."$a";
               if($DB{$arch}){
                  print"<input type=radio name=board value=$arch>@bstuff['1'] archive $a<br>\n";
               }
            }
         }
      }

       
   }

print<<STUFF;
   </td></tr><tr><td class=light colspan=2><br><br>
   </td></tr><tr><td class=light colspan=2>
   <input type=submit value=submit>

   </td></tr>

STUFF

&index_footer;

}

#***********************************************************************
# Do_Prop
#***********************************************************************

sub do_prop{
   &verify_admin;
   if(!($FORM{'board'})){
      $info="You must select a board";
      &not_right_info;
   }

   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   
if($FORM{'board'}=~/.archive/){
       
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="changeprop">
   <input type=hidden name=admin value="$admin">
   <input type=hidden name=board value="$FORM{'board'}">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   You may only enable or disable HTML in archived boards.
   </td></tr><tr><td class=light>
STUFF

   $whichb="$data_db/$FORM{'board'}";
   dbmopen(%DB,$whichb,0666)||&not_right($info = "Couldn't open the
database '$whichdb'");

   if(($DB{'HTML'} eq "yes")||(!($DB{'HTML'}))){
      print"HTML is currently enabled. Select the checkbox below if you
wish to disable it.<br>";
      print"<input type=checkbox name=html value=disable>";
      print" Disable HTML";
   }else{
      print"HTML if currently disabled. Select the checkbox below if you
want to enable it.<br>";
      print"<input type=checkbox name=html value=enable>";
      print" Enable HTML";
   }
   dbmclose(%DB);

}else{

print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="changeprop">
   <input type=hidden name=admin value="$admin">
   <input type=hidden name=board value="$FORM{'board'}">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   Below is the current properties for the selected board. You may edit
to your needs.
   </td></tr><tr><td class=light>
STUFF

   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");

   @stuff=split(/\t/,$DB{$FORM{'board'}});
   print"Board Title<br>";
   print"<input type=text name=btitle
size=50 value=\"@stuff['1']\"><br><br>";
   print"Board Description<br>";
   print"<input type=text size=75 name=bdesc
value=\"@stuff['2']\"><br><br>";
   dbmclose(%DB);

   $whichb="$data_db/@stuff['0']";
   dbmopen(%DB,$whichb,0666)||&not_right($info = "Couldn't open the
database '$whichdb'");

   if(($DB{'HTML'} eq "yes")||(!($DB{'HTML'}))){
      print"HTML is currently enabled. Select the checkbox below if you
wish to disable it.<br>";
      print"<input type=checkbox name=html value=disable>";
      print" Disable HTML";
   }else{
      print"HTML if currently disabled. Select the checkbox below if you
want to enable it.<br>";
      print"<input type=checkbox name=html value=enable>";
      print" Enable HTML";
   }
   dbmclose(%DB);

}
 
print<<STUFF;
   <input type=hidden name=total value=$total>
   </td></tr><tr><td class=light colspan=2>
   <input type=submit value=submit>
   </td></tr>

STUFF

&index_footer;

}

#***********************************************************************
# Change_Prop
#***********************************************************************

sub change_prop{

   &verify_admin;

   if($FORM{'board'}=~/.archive/){

      $whichb="$data_db/$FORM{'board'}";
      dbmopen(%DB,$whichb,0666)||&not_right_info($info = "Couldn't open
the database '$whichdb'");

      if($FORM{'html'} eq "enable"){
         $DB{'HTML'}="yes";
      }
      if($FORM{'html'} eq "disable"){
         $DB{'HTML'}="no";
      }
      dbmclose(%DB);
   }else{

      dbmopen(%DB,$board_db,0666)||&not_right_info($info = "Couldn't open
the database '$board_db'");

      @stuff=split(/\t/,$DB{$FORM{'board'}});
      

$newline="@stuff['0']"."\t"."$FORM{'btitle'}"."\t"."$FORM{'bdesc'}"."\t"."@stuff['3']";
      $DB{$FORM{'board'}}=$newline;
      dbmclose(%DB);

      $whichb="$data_db/@stuff['0']";
      dbmopen(%DB,$whichb,0666)||&not_right_info($info = "Couldn't open
the database '$whichb'");

      if($FORM{'html'} eq "enable"){
         $DB{'HTML'}="yes";
      }
      if($FORM{'html'} eq "disable"){
         $DB{'HTML'}="no";
      }
      dbmclose(%DB);

   }

   &admin_thanks;
   open(FILE,"adminthanks.html")||&not_right($info = "Couldn't open the
file 'adminthanks.html'");
   while(<FILE>){
      print "$_";
   } 
   &index_footer;

}      

#***********************************************************************
# Edit_User
#***********************************************************************

sub edit_user{

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="list_user">
   <input type=hidden name=admin value="$admin">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   Select your choice below.
   </td></tr><tr><td class=light>

   <input type=radio name=users value=biglist>
   Show all registered users.
   <br><br>
   <input type=radio name=users value=alpha>
   Show all registered users that start with the letter
   <select name=letter>
      <option>A
      <option>B
      <option>C
      <option>D
      <option>E
      <option>F
      <option>G
      <option>H
      <option>I
      <option>J
      <option>K
      <option>L
      <option>M
      <option>N
      <option>O
      <option>P
      <option>Q
      <option>R
      <option>S
      <option>T
      <option>U
      <option>V
      <option>W
      <option>X
      <option>Y
      <option>Z
   </select>
   <br><br>
   <input type=radio name=users value=idle>
   Show all users who have not posted within
   <select name=idle>
      <option value=1>1 month
      <option value=2>2 months
      <option value=3>3 months
      <option value=4>4 months
      <option value=5>5 months
      <option value=6>6 months
      <option value=7>7 months
      <option value=8>8 months
      <option value=9>9 months
      <option value=10>10 months
      <option value=11>11 months
      <option value=year>1 year or more
   </select>
   </td></tr><tr><td class=light colspan=2><br><br>
   </td></tr><tr><td class=light colspan=2>
   <input type=submit value=submit>

   </td></tr>

STUFF

&index_footer;

}

#***********************************************************************
# List_User
#***********************************************************************

sub list_user{

   if(!($FORM{'users'})){
      $info="You must select an option";
      &not_right_info;
   }

   &verify_admin;
   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   
print<<STUFF;
   <form method=post action="$cgiurl/wwwthread_admin.cgi">
   <input type=hidden name=action value="change_user">
   <input type=hidden name=admin value="$admin">
    <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
   <tr><td class=dark colspan=2>
   You may edit or delete the users below. If you wish to edit a user,
select the user you wish to edit then choose edit user. If you wish to
delete a user or users, select all the users you wish to delete and choose
delete users.
   </td></tr><tr><td class=light>
STUFF

if($FORM{'users'}eq "biglist" ){

   dbmopen(%DB,$user_db,0666)||&not_right($info = "Couldn't open the
database '$user_db'");

   $tot=0;
   foreach $var (sort(keys(%DB))){
      if((!($var=~/total$/))&&(!($var=~/date$/))&&(!($var eq "TOTAL"))){
         $tot++;
         $nam="user"."$tot";
         print "<input type=checkbox name=$nam value=\"$var\"> ";
         print "$var<br>";
      }
   }
   print"<input type=hidden name=total value=$tot>";
}

if($FORM{'users'}eq "alpha" ){

   dbmopen(%DB,$user_db,0666)||&not_right($info = "Couldn't open the
database '$user_db'");

   $tot=0;
   $letter="\L$FORM{'letter'}\E";
   foreach $var (sort(keys(%DB))){
      $user=$var;
      $var="\L$var\E";
      if((!($var=~/total$/))&&(!($var=~/date$/))&&($var=~/^$letter/)){
         $tot++;
         $nam="user"."$tot";
         print "<input type=checkbox name=$nam value=\"$user\"> ";
         print "$user<br>";
      }
   }
   print"<input type=hidden name=total value=$tot>";

}

if($FORM{'users'}eq "idle" ){

   dbmopen(%DB,$user_db,0666)||&not_right($info = "Couldn't open the
database '$user_db'");

   $tot=0;

   if($FORM{'idle'} eq "year"){
      $seconds="32140800";
   }else{
      $seconds=(2678400)*($FORM{'idle'});
   }
   
   foreach $var (sort(keys(%DB))){
   
      if($var=~/date$/){
         $idler=$DB{$var};
         $currtime=time();
         $idletime=$currtime-$seconds;
         if($idler<$idletime){
            $tot++;
            $var=~s/date//g;
            $nam="user"."$tot";
            print "<input type=checkbox name=$nam value=\"$var\"> ";
            print "$var<br>";

         }
      }

   }
   print"<input type=hidden name=total value=$tot>";

}

dbmclose(%DB);

 
print<<STUFF;
   </td></tr><tr><td class=light colspan=2><br><br>
   <input type=radio name=which value=edit> Edit User
   <br>
   <input type=radio name=which value=delete> Delete Users
   </td></tr><tr><td class=light colspan=2>
   <input type=submit value=submit>

   </td></tr>

STUFF

&index_footer;

}


#***********************************************************************
# Change_User
#***********************************************************************

sub change_user{

   if(!($FORM{'which'})){
      $info="You must choose edit or delete";
      &not_right_info;
   }

   &verify_admin;

   if($FORM{'which'} eq "delete"){

      dbmopen(%DATA,$user_db,0666)||&not_right($info = "Couldn't open the 
database '$user_db'");

      for($i=0;$i<=$FORM{'total'};$i++){
         $select="user"."$i";
         if($FORM{$select}){
            $nam=$FORM{$select};
            $dat="$nam"."date";
            $tot="$nam"."total";
            delete($DATA{$nam});
            delete($DATA{$dat});
            delete($DATA{$tot});
         }
      }
      dbmclose(%DATA);
      &admin_thanks;
      open(FILE,"adminthanks.html")||&not_right($info = "Couldn't open
the file 'adminthanks.html'");

      while(<FILE>){
      print "$_";
      }
      &index_footer; 
   }else{

   $whichmenu="top_admin";
   $admin=$FORM{'admin'};
   &admin_header;
   
   dbmopen(%DB,$user_db,0666)||&not_right($info = "Couldn't open the
database '$user_db'");
 
   for($i=0;$i<=$FORM{'total'};$i++){
   $nam="user"."$i";
      if($FORM{$nam}){
         @user=split(/\t/,$DB{$FORM{$nam}});

print<<STUFF;
        <form method=post action="$cgiurl/wwwthread_admin.cgi">
        <input type=hidden name=action value="do_user">
        <input type=hidden name=admin value="$admin">
        <TABLE width=100% BORDER=0 cellpadding=2 cellspacing=0>
        <tr><td class=dark colspan=2>Below is the current profile for $FORM{$nam}. You may edit this as needed.
        </td></tr><tr><td class=light>
        <input type=hidden name=username value="$FORM{$nam}">
        Username </td><td class=light>$FORM{$nam}</td></tr><tr><td
class=light>
        Password </td><td class=light>
        <input type=text name=password value="@user['0']">
        </td></tr><tr><td class=light>
        Email </td><td class=light>
        <input type=text name=email value="@user['1']">
        </td></tr><tr><td class=light>
        Fullname </td><td class=light>
        <input type=text name=fullname value="@user['2']">
        </td></tr><tr><td class=light>
        Homepage </td><td class=light>
        <input type=text name=homepage value="@user['3']">
        </td></tr><tr><td class=light>
        Hobbies </td><td class=light>
        <input type=text name=hobbies value="@user['4']">
        </td></tr><tr><td class=light>
        Occupation </td><td class=light>
        <input type=text name=occupation value="@user['5']">

        </td></tr><tr><td class=light colspan=2>
        <input type=submit value=submit>

        </td></tr>


STUFF
        dbmclose(%DB);
        &index_footer;    
      }

   }

   }

}

#***********************************************************************
# Do_user
#***********************************************************************

sub do_user{

   &verify_admin;
   dbmopen(%DB,$user_db,0666)||&not_right_info($info = "Couldn't open the
database '$user_db'");
   $newline="$FORM{'password'}"."\t"."$FORM{'email'}"."\t"."$FORM{'fullname'}"."\t"."$FORM{'homepage'}"."\t"."$FORM{'hobbies'}"."\t"."$FORM{'occupation'}";
   $DB{$FORM{'username'}}=$newline;

   dbmclose(%DB);

   &admin_thanks;
   open(FILE,"adminthanks.html")||&not_right($info = "Couldn't open the
file 'adminthanks.html'");
   while(<FILE>){
      print "$_";
   }
   &index_footer; 

}   
