#!/usr/bin/perl
###########################################################################
#    WWWThreads  - Interactive Discussion Forum
#    Copyright (C) 1998  Rick Baker	rbaker@techline.com
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
###########################################################################
require 'wwwthread_variables.pl';
require 'wwwthread_utilities.pl';

#***********************************************************************
# Call the Main Routines
#***********************************************************************

&get_input;			# Get the Input
&get_cookie;
&assign_query;			# Assign Query String to variables
&determine;			# Determine what the user is tryint to do

exit;				# End of Program

#***********************************************************************
# Assign_Query; Assign query String to Variables
#***********************************************************************

sub assign_query{

   $type=$FORM{'board'};
   $num=$FORM{'num'};
   $action=$FORM{'action'};
   $bnum=$FORM{'bnum'};
   $user=$FORM{'user'};
   $user=~s/\|SPC\|/ /g;
   $user=~s/\|AMP\|/&/g;
   %oldcookie=%cookie;

}

#***********************************************************************
# Determine; Determine what the user is trying to do
#***********************************************************************

sub determine{

   if($action eq ""){
      &show_index;
   }
   if($action eq "newuser"){
      &new_user;
   }
   if($action eq "editinfo"){
      &edit_info;
   }
   if(($action eq "list")&&(!($type))){
      &show_index;
   }
   if(($action eq "list")&&($type)){
      &list_board;
   }
   if($action eq "post"){
      &new_post;
   }
   if($action eq "show"){
      &show_post;
   }
   if($action eq "user"){
      &show_user;
   }
   if($action eq "reply"){
      &make_reply;
   }
   if($action eq "showfaq"){
      &show_faq;
   }
   if($action eq "search"){
      &search;
   }
   if($action eq "dosearch"){
      &do_search;
   }
}

#***********************************************************************
# Show_Index; Show all the boards
#***********************************************************************

sub show_index{

   $whichmenu="top_none";
   &index_header;
   print"<TABLE BORDER=0 WIDTH=100% CELLPADDING=2 CELLSPACING=0>";

   dbmopen(%DB,$board_db,0666)|| &not_right($info="Couldn't open the
database '$board_db'");;

   $total=$DB{'BOARDS'};
   for($i=1;$i<=$total;$i++){
      
      $whichb="BOARD"."$i";
      $dateb="DATE"."$i";
      $lastpost=$DB{$dateb};
      if($DB{$whichb}){

         $bdata=$DB{$whichb};
         @barray=split(/\t/,$bdata);
         $archs=@barray['3'];
         dbmopen(%DC,"$data_db/@barray['0']",0666)||&not_right($info =
"Couldn't open the database '$data_db/@barray['0']'");

         $tpost=$DC{'POSTS'};
         $tot=$DC{'TOTAL'};
         if(!(@barray['0']=~/.archive/)){
         
print<<STUFF;
         <TR>
         <TD class=dark width=50% valign=bottom>
         <B><FONT SIZE="-1"><a href="$cgiurl/wwwthread.cgi?action=list&board=@barray['0']&bnum=$i&from=index">@barray['1']</a></FONT></B>
         </TD><TD class=dark width=15%>
         <FONT SIZE="-2"><b>

STUFF

  if(($tot == 0)&&($tpost==0)){
     print"New Board";
  }elsif(($tot > 0)&&($tpost>0)){
     print"$tpost Posts";
  }else{
     print "Archived"; 
  }
 dbmclose(%DC);



if($oldcookie{@barray['0']} < $tot){
   print"<img src=\"$imageurl/new.gif\">";
}

if($archs){
   for($z=0;$z<=$archs;$z++){
      $posts=0;
      $archive="@barray['0']".".archive"."$z";
      if($DB{$archive}){
         dbmopen(%DF,"$data_db/$archive",0666)||&not_right($info =
"Couldn't open the database '$data_db/$archive'");

         $posts=$posts+$DF{'POSTS'};
         dbmclose(%DF);
      }
   }
print"<br>$posts Archived";
}
print<<STUFF;
         </FONT></b>
         </TD><TD class=dark align=right width=35% valign=bottom>
         <B><FONT SIZE="-2">Last Post: $lastpost</FONT></B>
         </TD></TR>
         <TR>
         <TD COLSPAN=3 class=light>
         <P>@barray['2']
         <BR><br>
         </TD></TR>
         <TR>
         <TD COLSPAN=3 bgcolor="#000000">
         <P>
         </TD></TR>

STUFF
}
}
}
 
print<<STUFF;
  <TR>
      <TD class=dark colspan=3>
         <P><BR>      
      </TD></TR>
STUFF
   dbmclose(%DB);
   &index_footer;
   exit;
}

#***********************************************************************
# New_User
#***********************************************************************

sub new_user{

   $whichmenu="top_index";
   &index_header;
   print"<FORM METHOD=\"post\" action=\"$cgiurl/wwwthread_newuser.cgi\">";
   open(FILE,"newuser.html")||&not_right($info = "Couldn't open the file
'newuser.html'");

   while(<FILE>){
      print"$_";
   }
   close(FILE);
   &index_footer;
   exit;
}

#***********************************************************************
# Edit_Info
#***********************************************************************

sub edit_info{

   $whichmenu="top_index";
   &index_header;
   print"<FORM METHOD=\"post\" action=\"$cgiurl/wwwthread_editinfo.cgi\">";
   open(FILE,"editinfo.html")||&not_right($info = "Couldn't open the file 
'editinfo.html'");

   while(<FILE>){
      print"$_";
   }
   close(FILE);
   &index_footer;
   exit;
}

#***********************************************************************
# List_Board
#***********************************************************************

sub list_board{


  # Set cookies
	
   if($FORM{'from'} eq "index"){
      $whichb="$data_db"."/$type";
      dbmopen(%DB,$whichb,0666)||&not_right_info($info = "Couldn't open
the database '$whichdb'");
      $bcookie="$type";
      $old="$type"."never";
      $oldvalue="$cookie{$bcookie}";
      $Cookie_Exp_Date = $cexp;
      &set_cookie("$bcookie","$DB{'TOTAL'}","$old","$oldvalue");
      dbmclose(%DB);
      &get_cookie;
   }

   $whichmenu="top_noreply";
   &index_header;
   if($type=~/.archive/){
      ($blah,$boname)=split(/archive/,$type,2);
      $boname="Archive $boname";
   }else{
   $whichdb="BOARD"."$bnum";
   
   dbmopen(%DB,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");

   @stuff=split(/\t/,$DB{$whichdb});
   $boname="@stuff['1']";
   dbmclose(%DB);
   }

print<<STUFF;
   <TABLE BORDER=0 WIDTH=100% CELLPADDING=2 CELLSPACING=0>
   <TR>
      <TD align=center class=dark colspan=3>
          <b><font size=-1>$boname</font></B>
      </TD></TR>

STUFF
      print"<TR>\n";
      print"<TD class=light width=55%>";
      print"Subject";
      print"</td><td class=light width=15%>";
      print"Poster";
      print"</td><td class=light width=30%>";
      print"Date";
      print"</td></tr><tr>";
   dbmopen(%DB,"$data_db/$type",0666)||&not_right($info = "Couldn't open
the database '$data_db/$type'");

   $blah="$type"."reader";
   $bold="$type"."never";
   $tpost=$DB{'TOTAL'};
   $class="alt";
   for($i=$tpost;$i>=0;$i--){
   
      if($DB{$i}){

         @stuff=split(/\t/,$DB{$i});
         $username=@stuff['4'];
         $username=~s/ /|SPC|/g;
         $username=~s/&/|AMP|/g;
            if((@stuff['0'] eq "Main")){
               print"<td colspan=3 class=dark>";
               print"</td></tr><tr><td class=$class valign=top>";

               $check=",$i,";
               if(($i > $cookie{$bold})&&(!($cookie{$blah}=~/$check/))){
                  print"<img src=\"$imageurl/redfolder.gif\">&nbsp;";
               }else{
               print"<img src=\"$imageurl/folder.gif\">&nbsp;";
               }
               print"<a href=\"$cgiurl/wwwthread.cgi?action=show&board=$type&bnum=$bnum&num=$i\">@stuff['5']</a>\n";
               print"</td><td class=$class valign=top>";
               print"<font size=-1>\n";
               print"<a
href=\"$cgiurl/wwwthread.cgi?action=user&board=$type&user=$username\">@stuff['4']</a>";
               print"</font>\n";
               print"</td><td class=$class valign=top>";
               print"<font size=-2>\n";
               print"@stuff['3']";
               print"</font>";
               if($class eq "alt"){
                  $class ="light";
               }else{
                  $class ="alt";
               }
               print"</td></tr><tr>";
  
               if(@stuff['2']){
                  &list_replies;
               }

             
        }
     }

  }
print<<STUFF;
   <TD class=$class colspan=2>
   </TD></TR>
STUFF
   dbmclose(%DB);
   $whichb="BOARD"."$bnum";
   dbmopen(%DD,$board_db,0666)||&not_right($info = "Couldn't open the
database '$board_db'");

   @bstuff=split(/\t/,$DD{$whichb});
   if((@bstuff['3'])&&(!($type=~/.archive/))){

print<<STUFF;
</TABLE><br>
   <TABLE border=0 cellpadding=2 cellspacing=0 width=100%>
   <TR><TD colspan=3 class=dark align=center>
   Archives
   </TD></TR>
STUFF

   for($i=@bstuff['3'];$i>=1;$i--){
      
      $archname="@bstuff['0']".".archive"."$i";
      if($DD{$archname}){

         $bdata=$DD{$archname};
         @barray=split(/\t/,$bdata);
         dbmopen(%DC,"$data_db/$archname",0666)||&not_right($info =
"Couldn't open the database '$data_db/$archname'");

         $tpost=$DC{'POSTS'};
         $tot=$DC{'TOTAL'};
print<<STUFF;
         <TR>
         <TD class=light width=50%>
         <B><FONT SIZE="-1"><a href="$cgiurl/wwwthread.cgi?action=list&board=$archname&bnum=$i&from=index">Archive $i</a></FONT></B>
         </TD><TD class=light width=15%>
         <B><FONT SIZE="-1">$tpost Posts
STUFF
         dbmclose(%DC);

if($oldcookie{$archname} < $tot){
   print"<img src=\"$imageurl/new.gif\">";
}
print<<STUFF;
         </FONT></B>
         </TD><TD class=light align=right width=35%>
         <B><FONT SIZE="-2">Last Post: $bdata</FONT></B>
         </TD></TR>
         <TR>
         <TD COLSPAN=3 class=dark>
         </TD></TR>

STUFF
}
}


   }
   dbmclose(%DB);
   &index_footer;

   
}


sub list_replies{
   local(@replies)=split(/,/,@stuff['2']);
   local($i);
   $size=@replies-1;
   for($i=$size;$i>=0;$i--){                  
      print"<td class=$class valign=top>\n";
      @stuff=split(/\t/,$DB{@replies[$i]});
      $username=@stuff['4'];
      $username=~s/ /|SPC|/g;
      $username=~s/&/|AMP|/g;
      $indent++;
      &do_indent;
      print"<a href=\"$cgiurl/wwwthread.cgi?action=show&board=$type&bnum=$bnum&num=@replies[$i]\">@stuff['5']</a>\n";
      print"</td><td class=$class valign=top>";
      print"<a
href=\"$cgiurl/wwwthread.cgi?action=user&board=$type&user=$username\">@stuff['4']</a>";
      print"</td><td class=$class valign=top>\n";
      print"<font size=-2>";
      print"@stuff['3']";
      print"<font>";
      if($class eq "alt"){
         $class = "light";
      }else{
         $class ="alt";
      }
      print"</td></tr><tr>\n";

      if(@stuff['2']){

        &list_replies;
      }
         $indent--;

   }


}

sub do_indent{
   
   $blah="$type"."reader";
   $bold="$type"."never";
   #&get_cookie;
   for($j=0;$j<$indent;$j++){ 
     print"<img src=\"$imageurl/blank.gif\">";
   }
   $check=",@replies[$i],";
   if((@replies[$i] > $cookie{$bold})&&(!($cookie{$blah}=~/$check/))){
      print"<img src=\"$imageurl/redfolder.gif\">&nbsp;";
   }else{
      print"<img src=\"$imageurl/folder.gif\">&nbsp;";
   }
}

#***********************************************************************
# New_Post
#***********************************************************************

sub new_post{

   $whichmenu="board_index";
   &index_header;
   print"<FORM METHOD=\"post\" action=\"$cgiurl/wwwthread_newpost.cgi\">";
   print"<input type=hidden name=board value=\"$type\">";
   print"<input type=hidden name=bnum value=\"$bnum\">";

print<<STUFF;
   <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 WIDTH=100%>
   <TR>
      <TD class=dark WIDTH="150">
         Username
      </TD><TD class=dark WIDTH="490">
         <B><FONT SIZE="-1"><INPUT TYPE="text" NAME="name"
         VALUE="$cookie{'username'}" SIZE=30></FONT></B>
      </TD></TR>
   <TR>
      <TD class=dark WIDTH="150">
         Password
      </TD><TD class=dark WIDTH="490">
         <INPUT TYPE="password" NAME="password"
VALUE="$cookie{'password'}" SIZE=30>
      </TD></TR>

   <TR>
      <TD class=dark WIDTH="150">
         Subject
      </TD><TD class=dark WIDTH="490">
         <INPUT TYPE="text" NAME="subject" VALUE="" SIZE=30 maxlength=30>
      </TD></TR>
   <TR>
      <TD COLSPAN=2 class=light WIDTH="100%">
         <P>Post:</P>
         
         <P><TEXTAREA NAME="post" ROWS=10 COLS=60></TEXTAREA></P>
STUFF

if($usemail == 1){

   if($mailall == 1){
      print"<P><input type=checkbox name=rmail value=\"yes\" checked>";
      print"Please email all replies.";
   }
   if($mailall == 0){
      print"<P><input type=checkbox name=rmail value=\"yes\">";
      print"Please email all replies.";
   }
   
}
print<<STUFF;  
         <P><INPUT TYPE="submit" NAME="Submit"
         VALUE="Submit"><INPUT TYPE="reset" VALUE="Reset">
      </TD></TR>
STUFF

&index_footer;
exit;
}

#***********************************************************************
# Show_Post
#***********************************************************************

sub show_post{
   $whichb="$data_db"."/$type";
   dbmopen(%DB,$whichb,0666)||&not_right_info($info = "Couldn't open the
database '$whichdb'");

   $bcookie="$type";
   $Cookie_Exp_Date = $cexp;
   &set_cookie("$bcookie","$DB{'TOTAL'}");
   dbmclose(%DB);
   &get_cookie;


   $blah="$type"."reader";
   $read="$cookie{$blah}".",$num,";
   $Cookie_Exp_Date = '';
   &set_cookie("$blah","$read");
   &get_cookie;
   $whichmenu="top_all";
   &index_header;   

   dbmopen(%DB,"$data_db/$type",0666)||&not_right($info = "Couldn't open
the database '$data_db/$type'");

   @pstuff=split(/\t/,$DB{$num});
   $username=@pstuff['4'];
   $username=~s/ /|SPC|/g;
   $username=~s/&/|AMP|/g;
   $html="$DB{'HTML'}";
   open(FILE,"$data_db/$type/$num$ext")||&not_right($info = "Couldn't
open the file '$data_db/$type/$num$ext'");

   @post=<FILE>;
   close(FILE);
   $post=join(/ /,@post);
   if($html eq "no"){
     $post=~s/</&lt;/g;
     $post=~s/>/&gt;/g;
   }

print<<STUFF;

   <TABLE BORDER=0 WIDTH=100% CELLPADDING=2 CELLSPACING=0>
   <TR>
       <TD class=dark>
       Subject
       </TD>
       <TD class=dark colspan=2>
       @pstuff['5']
       </TD></tr><tr>
       <TD class=dark>
       Posted by
       </TD>
       <TD class=dark colspan=2>
       <a
href="$cgiurl/wwwthread.cgi?action=user&board=$type&user=$username">
       @pstuff['4']
       </a>
       </TD></tr><tr>
       <TD class=dark>
       Posted on
       </TD>
       <TD colspan=2 class=dark>
       @pstuff['3']
       </TD></TR><TR>
STUFF
   if($showip == 1){
       print"<TD class=dark>\n";
       print"From IP";
       print"</td>\n";
       print"<TD colspan=2 class=dark>\n";
       print"@pstuff['8'] &nbsp;";
       print"</td></tr><tr>\n";
   }
   if(@pstuff['1']){
       print"<TD class=dark>\n";
       print"In Reply to";
       print"</TD>\n";
       print"<TD colspan=2 class=dark>\n";
       @rstuff=split(/\t/,$DB{@pstuff['1']});
       print"<a href=\"$cgiurl/wwwthread.cgi?action=show&board=$type&bnum=$bnum&num=@pstuff['1']\">";

       print"@rstuff['5']</a>";
       print"</TD></TR><tr>";
   }

print<<STUFF;
       <TD colspan=3 class=light>
       <br>
       <p>$post
       <br><br>
       </TD>
      


</tr>
STUFF

   if(@pstuff['2']){
      print"</tr></table><br><table width=100% cellpadding=2 cellspacing=0>";
      print"Replies";
      print"</TD></tr><tr>\n";
      @rstuff=split(/,/,@pstuff['2']);
      $size=@rstuff-1;
      $class="light";
      $blah="$type"."reader";
      $bold="$type"."never";
      for($i=$size;$i>=0;$i--){
      print"<TD class=$class valign=top>";
        @stuff=split(/\t/,$DB{@rstuff[$i]});
        $username=@stuff['4'];
        $username=~s/ /|SPC|/g;
        $username=~s/&/|AMP|/g; 
        $check=",@rstuff[$i],";
        if((@rstuff[$i] > $cookie{$bold})&&(!($cookie{$blah}=~/$check/))){
           print"<img src=\"$imageurl/redfolder.gif\">&nbsp;";
        }else{
           print"<img src=\"$imageurl/folder.gif\">&nbsp;";
        }

         print"<a
href=\"$cgiurl/wwwthread.cgi?action=show&board=$type&bnum=$bnum&num=@rstuff[$i]\">@stuff['5']</a>\n";
         print"</td><td class=$class valign=top>";
         print"<a
href=\"$cgiurl/wwwthread.cgi?action=user&board=$type&user=$username\">@stuff['4']</a>";
         print"</td><td class=$class valign=top>\n";
         print"<font size=-2>";
         print"@stuff['3']";
         print"</font>\n";
         if($class eq "alt"){
            $class = "light";
         }else{
            $class ="alt";
         }
         print"</td></tr><tr>\n";
         if(@stuff['2']){
            &list_replies;
         }
      }     
   }
&index_footer;
dbmclose(%DB);
exit;         
   
}




#***********************************************************************
# Show_User
#***********************************************************************

sub show_user{

  $whichmenu="board_index";

  dbmopen(%DB,"$user_db",0666)|| &not_right_info($info = "Couldn't open
the database '$user_db'");

  if(!($DB{$user})){
     dbmclose(%DB);

     $info="This userid has been deleted. $user";
     &not_right_info;
  }
  &index_header;

  @ustuff=split(/\t/,$DB{$user});
  $tp="$user"."total";
  $tpost=$DB{$tp};

  dbmclose(%DB);
  if(@ustuff['3'] ne "http://"){
     @ustuff['3']="<a href=\"@ustuff['3']\">@ustuff['3']</a>";
  }else{
     @ustuff['3']="";
  }

print<<STUFF;
   <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 WIDTH=100%>
   <TR>
      <TD class=light WIDTH="150">
         Username
      </TD><TD COLSPAN=2 class=light >
         $user         
      </TD></TR>
   <TR>
      <TD class=light WIDTH="150">
         Email
      </TD><TD COLSPAN=2 class=light>
         <a href="mailto: @ustuff['1']">@ustuff['1']</a>
      </TD></TR>
   <TR>
      <TD class=light WIDTH="150">
         Full Name
      </TD><TD COLSPAN=2 class=light>
         @ustuff['2']
      </TD></TR>
   <TR>
      <TD class=light WIDTH="150">
         Homepage
      </TD><TD COLSPAN=2 class=light>
         @ustuff['3']
      </TD></TR>
   <TR>
      <TD class=light WIDTH="150">
         Occupation
      </TD><TD COLSPAN=2 class=light>
         @ustuff['4']
      </TD></TR>
   <TR>
      <TD class=light WIDTH="150">
         Hobbies
      </TD><TD COLSPAN=2 class=light>
         @ustuff['5']
      </TD></TR>
   <TR>
      <TD class=light WIDTH="150">
         Total Posts
      </TD><TD COLSPAN=2 class=light>
         $tpost
      </TD></TR>   
   <TR><TD colspan=3>
STUFF
   &back_button;
   print"</TD></TR>";

   &index_footer;
   exit;
}

#***********************************************************************
# Make_Reply
#***********************************************************************

sub make_reply{

  dbmopen(%DB,"$data_db/$type",0666)|| &not_right_info($info = "Couldn't
open the database '$data_db/$type'");

  @stuff=split(/\t/,$DB{$num});
  dbmclose(%DB);

  open(FILE,"$data_db/$type/$num$ext")|| &not_right_info($info = "Couldn't
open the file '$data_db/$type/$num$ext'");

  @post=<FILE>;
  close(FILE);
  $post=join(/ /,@post);

  $repl=@stuff['5'];
  $repl=~s/"/'/g;
  if(!($repl=~/Re:/)){
     $repl="Re: $repl";
  }
  $whichmenu="board_index";
  &index_header;
  
  print"<form method=post action=\"$cgiurl/wwwthread_reply.cgi\">\n";
  print"<input type=hidden name=board value=\"$type\">\n";
  print"<input type=hidden name=bnum value=\"$bnum\">\n";
  print"<input type=hidden name=num value=\"$num\">\n";

print<<STUFF;

<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 WIDTH=100%>
   <TR>
      <TD class=dark WIDTH="150">
         Username
      </TD><TD class=dark WIDTH="490">
         <B><FONT SIZE="-1"><INPUT TYPE="text" NAME="name"
         VALUE="$cookie{'username'}" SIZE=30></FONT></B>
      </TD></TR>
   <TR>
      <TD class=dark WIDTH="150">
         Password
      </TD><TD class=dark WIDTH="490">
         <INPUT TYPE="password" NAME="password"
VALUE="$cookie{'password'}" SIZE=30>
      </TD></TR>
   <TR>  
      <TD class=dark WIDTH="150">
         Subject
      </TD><TD class=dark WIDTH="490">
         <INPUT TYPE="text" NAME="subject" VALUE="$repl"
SIZE=30 maxlength=30>
      </TD></TR>
   <TR>
      <TD COLSPAN=2 class=light WIDTH="100%">
         <P>Reply:</P>

         <P><TEXTAREA NAME="post" ROWS=10 COLS=60
wrap=soft></TEXTAREA></P>

STUFF
if($usemail ==1){

   if($mailall == 1){
      print"<P><input type=checkbox name=rmail value=\"yes\" checked>";
      print"Please email all replies.";
   }
   if($mailall == 0){
      print"<P><input type=checkbox name=rmail value=\"yes\">";
      print"Please email all replies.";
   } 
}
print<<STUFF;
         <P><INPUT TYPE="submit" NAME="Submit"
         VALUE="Submit"><INPUT TYPE="reset" VALUE="Reset">
      </TD></TR>  
   </TABLE>

  <TABLE BORDER=0 width=100% cellpadding=2 cellspacing=0>
  <TR><TD class=dark>
  <p>&nbsp;</p><center>
  In Response To:
  </center>
  <p>$post
  </TD></TR>

STUFF

  &index_footer;
  exit;
}

#***********************************************************************
# Show_Faq
#***********************************************************************

sub show_faq{

   $whichmenu="top_index";
   &index_header;
   open(FILE,"faq.html")||&not_right($info = "Couldn't open the file
'faq.html'");
   while(<FILE>){
      print"$_";
   }
   close(FILE);
   &index_footer;
   exit;
}

#***********************************************************************
# Search
#***********************************************************************

sub search {

   $whichmenu="top_index";
   &index_header;

   print"<form method=post action=\"$cgiurl/wwwthread.cgi\">";
   print"<input type=hidden name=action value=dosearch>";
   print"<table border=0 width=100% cellpadding=2 cellspacing=0>";
   print"<tr><td class=dark>";
   print"Select which area you wish to search and then enter the word or
phrase you want to search for. You may also enter a username to see all
posts by a specific user or you can enter a date as long as it is in the 
proper format such as Feb 23 or Mon Jul 22.";
   print"</td></tr>";
   print"<tr><td class=light>";

   print"<p>&nbsp;</p><p>Select boards to search: ";

   dbmopen(%DB,$board_db,0666)|| &not_right($info = "Couldn't open the
database '$board_db'");

   $total=$DB{'BOARDS'};
   
   print"<select name=\"search_board\">";

   for($i=1;$i<=$total;$i++){

      $whichb="BOARD"."$i";
      @bdata=split(/\t/,$DB{$whichb});
      print"<option value=@bdata['0']>@bdata['1']\n";

   }

   print"<option value=all>All forums\n";
   print"</select>";

   print"<br><br>Word or Phrase to search for: ";
   print"<input type=text name=searchtext>";
   print"<br><br>";
   print"<input type=submit value=submit>";


   dbmclose(%DB);

   print"</td></tr>";
   &index_footer;
   exit;
}

#***********************************************************************
# Do_Search
#***********************************************************************

sub do_search {

   $whichmenu="top_index";
   &index_header;

   print"<table border=0 width=100% cellpadding=2 cellspacing=0>";
   print"<tr><td class=dark>";
   print"Below are the posts that match your search criteria.";
   print"</td></tr>";
   print"<tr><td class=light>";

   print"<p>&nbsp;</p><p>";

   if($FORM{'search_board'} eq "all"){
      &search_all;
   }else{
   $boarddb="$data_db"."/$FORM{'search_board'}";
   dbmopen(%DB,$boarddb,0666)||&not_right($info = "Couldn't open the
database '$boarddb'");

   $total=$DB{'TOTAL'};
   for($i=1;$i<=$total;$i++){
      $stuff=$DB{$i};
      @astuff=split(/\t/,$DB{$i});
      $username=@astuff['4'];
      $username=~s/ /|SPC|/g;
      $username=~s/&/|AMP|/g;
      $stuff="\L$stuff\E";
      $searchtext="\L$FORM{'searchtext'}\E";
      $mnum="$data_db"."/"."$FORM{'search_board'}"."/"."$i$ext";
      open(FILE,"$mnum")||&not_right($info = "Couldn't open the file
'$mnum'");

      @pstuff=<FILE>;
      close(FILE);
      $pstuff=join(/ /,@pstuff);
      if(($stuff=~/$searchtext/)||($pstuff=~/$searchtext/)){
         print"<a href=\"$cgiurl/wwwthread.cgi?action=show&board=$FORM{'search_board'}&num=$i\"> @astuff['5']</a>\n";
         print"<font size=-2><b> posted by";
         print"</font></b>";
         print" <a
href=\"$cgiurl/wwwthread.cgi?action=user&board=$type&user=$username\">@astuff['4']</a>";
         print"<font size=-2><b>\n";
         print" at @astuff['3']";
         print"</font></b>\n";
         print"<br>";
      }
   }
   }

   $whichb="$FORM{'search_board'}";

   dbmopen(%DATA,"$board_db",0666)||&not_right($info = "Couldn't open the 
database '$board_db'");

   $total=$DATA{'BOARDS'};
   for($i=1;$i<=$total;$i++){
      $whichone="BOARD"."$i";
      @blah=split(/\t/,$DATA{$whichone});
      if(@blah['0'] eq $whichb){
         $archt=@blah['3'];
         if($archt){
            for($f=$archt;$f>=1;$f--){
               $arch="$whichb".".archive"."$f";
               dbmopen(%DD,"$data_db/$arch",0666)||&not_right($info =
"Couldn't open the database '$data_db/$arch'");

               $total=$DD{'TOTAL'};
               for($x=0;$x<=$total;$x++){
               $stuff=$DD{$x};
               @astuff=split(/\t/,$DD{$x});
               $username=~s/ /|SPC|/g;
               $username=~s/&/|AMP|/g;
               $stuff="\L$stuff\E";
               $searchtext="\L$FORM{'searchtext'}\E";
               open(FILE,"$data_db/$arch/$x$ext")||&not_right($info =
"Couldn't open the file '$data_db/$arch/$x$ext'");

               @pstuff=<FILE>;
               close(FILE);
               $pstuff=join(/ /,@pstuff);
               if(($stuff=~/$searchtext/)||($pstuff=~/searchtext/)){
                  print"<a href=\"$cgiurl/wwwthread.cgi?action=show&board=$arch&num=$x\"> @astuff['5']</a>\n";
                  print"<font size=-2><b> posted by";
                  print"</font></b>";
                  print" <a
href=\"$cgiurl/wwwthread.cgi?action=user&board=$type&user=$username\">@astuff['4']</a>";
                  print"<font size=-2><b>\n";
                  print" at @astuff['3']";
                  print"</font></b>\n";
                  print"<br>";
               }
            }dbmclose(%DD);
         }
      }
      }
   }
   dbmclose(%DATA);
   print"</td></tr>";
   &index_footer;
   exit;
}

#***********************************************************************
# Search_all
#***********************************************************************


sub search_all{

   dbmopen(%DC,"$board_db",0666)||&not_right_info($info = "Couldn't open
the database '$board_db'");

   $ptotal=$DC{'BOARDS'};
   for($f=1;$f<=$ptotal;$f++){
       $whichb="BOARD"."$f";
       @blah=split(/\t/,$DC{$whichb});
       $search_board=@blah['0'];
       $archs=@blah['3'];
       $nam=@blah['0'];
       print"<br><b>@blah['1']</b><br><br>\n";  
       $boarddb="$data_db"."/$search_board";

       dbmopen(%DB,$boarddb,0666)||&not_right($info = "Couldn't open the
database '$boarddb'");

       $total=$DB{'TOTAL'};
       for($i=0;$i<=$total;$i++){
          $stuff=$DB{$i};
          @astuff=split(/\t/,$DB{$i});
          $username=@astuff['4'];
          $username=~s/ /|SPC|/g;
          $username=~s/&/|AMP|/g;
          $stuff="\L$stuff\E";
          $searchtext="\L$FORM{'searchtext'}\E";
          open(FILE,"$data_db/$search_board/$i$ext")||&not_right($info =
"Couldn't open the file '$data_db/$search_board/$i$ext'");

          @pstuff=<FILE>;
          close(FILE);
          $pstuff=join(/ /,@pstuff);
          if(($stuff=~/$searchtext/)||($pstuff=~/$searchtext/)){
             print"<a href=\"$cgiurl/wwwthread.cgi?action=show&board=@blah['0']&num=$i\"> @astuff['5']</a>\n";
             print"<font size=-2><b> posted by";
             print"</font></b>";
             print" <a
href=\"$cgiurl/wwwthread.cgi?action=user&board=$type&user=$username\">@astuff['4']</a>";
             print"<font size=-2><b>\n";
             print" at @astuff['3']";
             print"</font></b>\n";
             print"<br>";
          }
       }
   dbmclose(%DB);
   if($archs){
      for($z=$archs;$z>=1;$z--){
         $arch="$nam".".archive"."$z";

         dbmopen(%DD,"$data_db/$arch",0666)||&not_right($info = "Couldn't 
open the database '$data_db/$arch'");

         $total=$DD{'TOTAL'};
         for($x=0;$x<=$total;$x++){
            $stuff=$DD{$x};
            @astuff=split(/\t/,$DD{$x});
            $username=@astuff['4'];
            $username=~s/ /|SPC|/g;
            $username=~s/&/|AMP|/g;
            $stuff="\L$stuff\E";
            $searchtext="\L$FORM{'searchtext'}\E";
            if($stuff=~/$searchtext/){
               print"<a href=\"$cgiurl/wwwthread.cgi?action=show&board=$arch&num=$x\"> @astuff['5']</a>\n";
               print"<font size=-2><b> posted by";
               print"</font></b>";
               print" <a
href=\"$cgiurl/wwwthread.cgi?action=user&board=$type&user=$username\">@astuff['4']</a>";
               print"<font size=-2><b>\n";
               print" at @astuff['3']";
               print"</font></b>\n";
               print"<br>";
             }
          }
          dbmclose(%DD);
}}}
   dbmclose(%DC);

}


