//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fvre
//______________________________________________________________________________

package org.demo.webwader.xmlrpc;

import xbrowser.plugin.*;
import xbrowser.*;
import xbrowser.options.XOptionPage;

import helma.xmlrpc.*;
import java.util.Vector;

/**
 * This is the plugin for XBrowser, the eXtended web Browser.
 * For more information see the 
 * <a href="http://www.geocities.com/xa_arnold/index.html">
 * XBrowser home page</a>
 *
 * @author Jean-Paul Le Fvre
 * @version $Id: W4Servant.java,v 1.3 2001/06/04 09:12:04 lefevre Exp $
 */
public class W4Servant extends DisplayerServant implements XPlugin
{
    /**
     * The name of this servant.
     */
    static final private String NAME = "W4Servant";
    /**
     * The context used by this plugin.
     */
    private XPluginContext context;
    /**
     * The embedded handler implementing a <code>Displayer</code>.
     */
    private class XbDisplayHandler implements XmlRpcHandler {
	/**
	 * Executes a request coming to the server.
	 * @param method the name of the method to execute.
	 * @param params the arrays of parameters.
	 */
	public Object execute(String method, Vector params) throws Exception
	{
	    if(method == null) {
		throw new XmlRpcException(0, "Invalid null method");
	    }
	    else if(method.equals("activate")) {
		warn(NAME + " activated");
		return "activated";
	    }
	    else if(method.equals("displayPage")) {

		if(params == null) {
		    throw new XmlRpcException(0, "Missing url parameter");
		}

		String url = params.elementAt(0).toString();
		XBrowser.getBrowser().showInActiveDocument(url);

		return Boolean.TRUE;
	    }
	    else if(method.equals("getName")) {
		return NAME;
	    }
	    else{
		throw new XmlRpcException(0, "Method not handled : " + method);
	    }
	}
    }
//______________________________________________________________________________
    /**
     * Creates the servant.
     * @throw IOException if the server cannot be created.
     */
public W4Servant() throws java.io.IOException
    {
	super();
    }
//______________________________________________________________________________
/**
 * Initializes the plugin.
 */
final public void init()
{
    warn("Start listening http connections on port " + getPort());    
}
//______________________________________________________________________________
/**
 * Returns the handler used by this servant to handle connections.
 * <br>
 * It is this <code>XbDisplayHandler()</code>
 * @return the handler.
 */
final protected XmlRpcHandler getHandler()
    {
	return new XbDisplayHandler();
    }
//______________________________________________________________________________
/**
 * Starts the plugin.
 */
public void start()
{
    warn("WebWader servant started");    
}
//______________________________________________________________________________
/**
 * Stops the plugin.
 */
public void stop()
    {
	warn("Stop listening http connections");    
	shutdown();
    }
//______________________________________________________________________________
/**
 * Returns the option page.
 * @return null
 */
public XOptionPage getOptionPage()
    {
	return null;
    }
//______________________________________________________________________________
/**
 * Destroys the plugin.
 */
public void destroy()
    {
    }
//______________________________________________________________________________
/**
 * Destroys the plugin.
 * @param context the new context.
 */
public void setContext(XPluginContext context)
    {
	this.context = context;
	context.getResourceManager().initResourceBundle("webwader");
    }
//______________________________________________________________________________
/**
 * Destroys the plugin.
 * @return the title of this plugin.
 */
public String getTitle()
    {
	return context.getResourceManager().getProperty(this, "Title");
    }
//______________________________________________________________________________
/**
 * Prints a message.
 * @param msg the string to print.
 */
protected void warn(String msg)
    {
	XRepository.getLogger().message(this, msg + " !");
    }
}
//______________________________________________________________________________
