//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.xmlrpc;

import org.demo.webwader.VersionInfo;
import org.demo.webwader.gui.GuiResources;
import org.ariane.tools.TryProg;
import org.ariane.tools.ToolBox;

/**
 * The server used to test the xmlrpc communications.
 * <P>
 * <code>
 * Usage : java org.demo.webwader.xmlrpc.URLPrinter [-v|d|q][-V][-h]
 * </code>
 * It is meant to work with <code>PrintURL</code> - the client. This
 * program is just a harness for <code>DisplayerServant</code>.
 * @see PrintURL
 * @see DisplayerServant
 * @version $Id: URLPrinter.java,v 1.2 2001/06/04 09:19:04 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

public class URLPrinter extends TryProg {

//______________________________________________________________________________
/**
 * The main program.
 * @param args the command line.
 */
public static void main (String[] args)
  {
      URLPrinter prog    = new URLPrinter();

      if (! prog.parseArg(args)) {
	  System.err.println("Can't parse command line !");
	  exitWrong();
      }

      if (! prog.run()) {
	  System.err.println("Can't execute URLPrinter !");
	  exitWrong();
      }

      System.exit(ToolBox.OK);
  }
//______________________________________________________________________________
/**
 * Creates the program.
 * <br>
 * It loads the properties used in the application : the default JVS
 * values, the general WebWader values and the user values.
 */
public URLPrinter()
  {
      super("URLPrinter");
      setResources();
  }
//______________________________________________________________________________
/**
 * Launches the program.
 * <br>
 * It starts the servant.
 * @return true if successful.
 * @see DisplayerServant
 */
public	boolean run()
  {
      if(ToolBox.debug) {
	  System.out.println(VersionInfo.instance().toString());
      }

      try {
	  DisplayerServant servant = new DisplayerServant();
	  System.out.println("Let the server work !");

	  int count = Thread.activeCount();
	  // Waiting for the first connection.
	  while(count > 1 && count < 3) {
	      Thread.sleep(1000);
	      count = Thread.activeCount();
	  }
	  // Once a connection has occured.
	  while(count > 2) {
	      Thread.sleep(2000);
	      count = Thread.activeCount();
	      if(false) System.out.println("Running threads : "+ count);
	  }
      }
      catch(Exception ex) {
	  ToolBox.warn("Can't run URLPrinter " + ex);
	  return false;
      }

      return true;
  }
//______________________________________________________________________________
/**
 * Installs the specific resources.
 * @see	org.demo.webwader.Resources
 */
protected void setResources()
  {
      resources = org.demo.webwader.Resources.instance();
  }
//______________________________________________________________________________
/**
 * Prints how to use the program.
 */
private	void printUsage()
  {
      System.out.println(
      "Usage   : java org.demo.webwader.xmlrpc.URLPrinter [options]");
      System.out.println("Options : [-v|-d|-q][-V][-h]");
  }
//______________________________________________________________________________
/**
 * Parses the command line.
 * <Br>
 * <code>Usage   : -v|d|q -V -h</code>
 * @return true if the command line is correct.
 */
public	boolean parseArg(String args[])
  {
    int i          = 0;
    int error      = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'V':
	  org.demo.webwader.VersionInfo.print();
	  return false;

	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;

	default	:
	  printUsage();
	  error++;
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}


