//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.xmlrpc;

import org.demo.webwader.VersionInfo;
import org.demo.webwader.gui.Displayer;
import org.ariane.tools.TryProg;
import org.ariane.tools.ToolBox;
import java.io.*;
import java.net.URL;
import helma.xmlrpc.XmlRpcException;
import java.net.MalformedURLException;

/**
 * The client used to test the xmlrpc servers.
 * <P>
 * <Code>
 * Usage : java org.demo.webwader.xmlrpc.PrintURL [-v|d|q][-V][-h]
 * </Code>
 * <P>
 * It parses the command line. A loop is started to enter data.
 *
 * @see URLPrinter
 * @version $Id: PrintURL.java,v 1.2 2001/05/27 16:24:59 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

public class PrintURL extends TryProg {

//______________________________________________________________________________
/**
 * The main program.
 * @param args the command line.
 */
public static void main (String[] args)
  {
      PrintURL prog    = new PrintURL();

      if (! prog.parseArg(args)) {
	  System.err.println("Can't parse command line !");
	  exitWrong();
      }

      if (! prog.run()) {
	  System.err.println("Can't execute PrintURL !");
	  exitWrong();
      }

      System.exit(ToolBox.OK);
  }
//______________________________________________________________________________
/**
 * Creates the program.
 * <br>
 * It loads the properties used in the application : the default JVS
 * values, the general WebWader values and the user values.
 */
public PrintURL()
  {
      super("PrintURL");
      setResources();
  }
//______________________________________________________________________________
/**
 * Launches the program .
 * @return true if successful.
 * @see #startLoop()
 */
public	boolean run()
  {
      if(ToolBox.debug) {
	  System.out.println(VersionInfo.instance().toString());
      }

      try {
	  startLoop();
	  System.out.println("See you later !");
      }
      catch(Exception ex) {
	  ToolBox.warn("Can't run PrintURL " + ex);
	  return false;
      }

      return true;
  }
//______________________________________________________________________________
/**
 * Manages the dialog with the server.
 * <br>
 * It creates an instance of <code>XmlDisplayer</code>, the client-side
 * object.
 * @see XmlDisplayer
 */
private void startLoop()
  {
      printOptions();

      boolean ok = true;
      BufferedReader d = new BufferedReader(new InputStreamReader(System.in));

      XmlDisplayer displayer = XmlDisplayer.instance();

      while(ok) {

	  System.out.print("Option : ");
	  String answer = null;
	  try {
	      answer = d.readLine();
	  }
	  catch(IOException ex) {
	      System.out.println("Can't read answer !");
	  }

	  /**
	   * First check for help or exit options.
	   */
	  if(answer.equalsIgnoreCase("H") || answer.equals("?")) {
	      printOptions();
	      continue;
	  }
	  else if(answer.equalsIgnoreCase("I") || answer.equalsIgnoreCase("D")){
	      System.out.println("Displayer : " + displayer.getName());
	      continue;
	  }
	  else if(answer.equalsIgnoreCase("K")){
	      displayer.kill();
	      continue;
	  }
	  else if(answer.equalsIgnoreCase("Q") || answer.equalsIgnoreCase("X")){
	      return;
	  }

	  /**
	   * The entered string is considered as an URL to display.
	   */
	  if(false) System.out.println("URL : " + answer);
	  try {
	      displayer.displayPage(new URL(answer));
	  }
	  catch(MalformedURLException ex) {
	      ToolBox.warn("Invalid URL " + answer, ex);
	  }
      }  
  }
//______________________________________________________________________________
/**
 * Prints the list of options.
 */
private void printOptions()
  {
      System.out.println();
      System.out.println("To get help    : 'h' or '?'");
      System.out.println("To get info    : 'i' or 'd'");
      System.out.println("To exit enter  : 'x' or 'q'");
      System.out.println("To kill server : 'k'");
      System.out.println("To display an URL give the location.");
      System.out.println();
      System.out.println();
  }
//______________________________________________________________________________
/**
 * Installs the specific resources.
 * @see	org.demo.webwader.Resources
 */
protected void setResources()
  {
      resources = org.demo.webwader.Resources.instance();
  }
//______________________________________________________________________________
/**
 * Prints how to use the program.
 */
private	void printUsage()
  {
      System.out.println(
      "Usage   : java org.demo.webwader.xmlrpc.PrintURL [options]");
      System.out.println("Options : [-v|-d|-q][-V][-h]");
  }
//______________________________________________________________________________
/**
 * Parses the command line.
 * <Br>
 * <Code>Usage   : -v|d|q -V -h</Code>
 * @return true if the command line is correct.
 */
public	boolean parseArg(String args[])
  {
    int i          = 0;
    int error      = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'V':
	  org.demo.webwader.VersionInfo.print();
	  return false;

	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;

	default	:
	  printUsage();
	  error++;
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}


