//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fvre
//______________________________________________________________________________

package org.demo.webwader.xmlrpc;

import org.ariane.tools.ToolBox;
import org.demo.webwader.Resources;
import org.demo.webwader.BadConfigurationException;
import helma.xmlrpc.*;
import java.util.Vector;
import java.io.IOException;

/**
 * This server knows how to display a document.
 * <br>
 * It is an extension of a small Web server.
 * It receives instructions through XML-RPC.
 *
 * @author Jean-Paul Le Fvre
 * @version $Id: DisplayerServant.java,v 1.4 2001/06/04 09:10:45 lefevre Exp $
 */

class DisplayerServant extends WebServer {
    /**
     * The name of this servant.
     */
    static final private String NAME = "XmlDisplayerServant";
    /**
     * The default port on which the server listens.
     */
    static final public int PORT = 8380;
    /**
     * The embedded handler implementing a <code>Displayer</code>.
     * It simply prints messages on standard output.
     */
    private class DefaultDisplayHandler implements XmlRpcHandler {
	/**
	 * Executes a request coming to the server.
	 * @param method the name of the method to execute.
	 * @param params the arrays of parameters.
	 */
	public Object execute(String method, Vector params) throws Exception
	{
	    if(method == null) {
		throw new XmlRpcException(0, "Invalid null method");
	    }
	    else if(method.equals("kill")) {
		warn(NAME + " killed");
		shutdown();
		return "killed"; // null is not allowed
	    }
	    else if(method.equals("activate")) {
		warn(NAME + " activated");
		return "activated";
	    }
	    else if(method.equals("displayPage")) {

		if(params == null) {
		    throw new XmlRpcException(0, "Missing url parameter");
		}

		Object url = params.elementAt(0);
		warn(url.toString());
		return Boolean.TRUE;
	    }
	    else if(method.equals("getName")) {
		return NAME;
	    }
	    else{
		throw new XmlRpcException(0, "Method not handled : " + method);
	    }
	}
    }
//______________________________________________________________________________
/**
 * Creates the servant.
 * <br>
 * The port number on which the remote object receives calls is found in
 * the resources. The XML parser is also defined in the properties.
 *
 * @throw IOException if the server cannot be started.
 * @throw BadConfigurationException if the XML driver is not found..
 * @see #addHandler
 * @see #getHandler
 * @see #getPort()
 * @see XmlDisplayer#setDriver()
 */
protected DisplayerServant() throws IOException, BadConfigurationException
    {
	super(getPort());
	if(ToolBox.debug) ToolBox.warn("XmlRpc port : " + getServerPort());

	setParanoid(true);
	acceptClient("127.0.0.1");
	XmlDisplayer.setXmlDriver();
	addHandler("Displayer", getHandler());
    }
//______________________________________________________________________________
/**
 * Returns the port used by this servant to listen to connections.
 * <br>
 * It is in <code>WebWader.XMLRPC.Port</code>.
 * @return the number.
 */
static final public int getPort()
{
    Resources rsrc = (Resources)Resources.instance();

    return rsrc.get(rsrc.PREFIX + "XMLRPC.Port", PORT);
}
//______________________________________________________________________________
/**
 * Returns the handler used by this servant to handle connections.
 * <br>
 * It is this <code>DefaultDisplayHandler()</code>
 * @return the handler.
 */
protected XmlRpcHandler getHandler()
    {
	return new DefaultDisplayHandler();
    }
//______________________________________________________________________________
/**
 * Prints a message.
 * <br>
 * This implemenation just encapsulates <code>System.out.println()</code>
 * @param msg the string to print.
 */
protected void warn(String msg)
    {
	System.out.println(msg + " !");
    }
//______________________________________________________________________________
}




