//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import java.net.URL;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.Displayer;

/**
 * A displayer based on the Swing component.
 * <Br>
 * The window is provided by the JEditorPane component.
 * @version $Id: SwingDisplayer.java,v 1.6 2001/01/14 17:51:39 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public class SwingDisplayer extends JEditorPane implements Displayer {
  /**
   * @serial The unique instance.
   */
private  static SwingDisplayer displayer = null;
    /**
     * @serial The name of this tool.
     */
public static final String NAME = "RemoteSwing";
    /**
     * @serial The set of properties.
     */
private GuiResources resources;

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <br>
 * It is a singleton
 * @return the unique instance.
 */
protected static SwingDisplayer instance()
  {
    if(displayer == null) displayer = new SwingDisplayer();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the SwingDisplayer.
 * <br>
 * The properties are set and a listener is intalled. It is a very
 * simple one handling clicks on hyperlinks.
 */
private SwingDisplayer()
  {
      super();

      resources  = GuiResources.instance();
      setEditable(false);
      setOpaque(true);
      setBackground(resources.getPaneBackground());
      setForeground(resources.getPaneForeground());
      setFont(resources.getTextFont());
      /**
       * Taken from the javadoc of JEditorPane.
       */
      class ClickListener implements HyperlinkListener {

	  public void hyperlinkUpdate(HyperlinkEvent ev) {

	      if (ev.getEventType() != HyperlinkEvent.EventType.ACTIVATED)
		  return;

	      if (ev instanceof HTMLFrameHyperlinkEvent) {
		  HTMLDocument doc = (HTMLDocument)getDocument();
		  doc.processHTMLFrameHyperlinkEvent(
				     (HTMLFrameHyperlinkEvent)ev);
		  return;
	      }
	      
	      displayPage(ev.getURL());
	  }
      }

      addHyperlinkListener(new ClickListener());
  }
//______________________________________________________________________________
/**
 * Activates this displayer.
 * <br>
 * Simply displays the welcome page.
 * #displayPage
 */
final public void activate()
{
    try {
      displayPage(new URL(resources.getWelcomeLocation()));
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display welcome page", ex);
	return;
    }
}
//______________________________________________________________________________
/**
 * Displays the specified document.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 * #setPage
 */
final public boolean displayPage(URL url)
{
    if(url == null) return false;

    try {
	NavePane.instance().setURLField(url);
	setPage(url);
	return true;
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page " + url.toString(), ex);
	return false;
    }
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
}


