//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fevre
//______________________________________________________________________________

package org.demo.webwader.rbi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.net.URL;

/**
 * A displayer knows how to display a document.
 * <br>
 * It is the interface proposed by the remote browsers.
 * @author   Jean-Paul Le Fvre
 * @version $Id: RemoteDisplayer.java,v 1.2 2001/01/07 19:43:15 lefevre Exp $
 * @see DisplayerServant
 * @see org.demo.webwader.gui.JavaDisplayer
 */

public interface RemoteDisplayer extends Remote {
/*
 * Sets a new current displayer.
 * @param name the new displayer.
 * @return true is the displayer is actually changed, false otherwise.
 * @throw RemoteException if the call cannot be completed.
 */
boolean changeDisplayer(String name) throws RemoteException;
  /*
   * Activates this tool.
   * @throw RemoteException if the call cannot be completed.
   */
void activate() throws RemoteException;
  /*
   * Displays a HTML page.
   * <br>
   * It the url points to a document which is not displayable, the method
   * returns false.
   *
   * @param url the URL of the document to show.
   * @return true if the page has been actually shown, false otherwise.
   * @throw RemoteException if the call cannot be completed.
   */
boolean displayPage(URL url) throws RemoteException;
  /*
   * Gets the name of the displayer.
   * @return a ident.
   * @throw RemoteException if the call cannot be completed.
   */
String getName() throws RemoteException;

//______________________________________________________________________________
}









