//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import org.ariane.tools.ToolBox;

import java.util.Properties;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

import org.demo.webwader.gui.SwingDisplayer;

/**
 * The customized OptionPane.
 * <Br>
 * It presents a tabbed pane displaying the various settings.
 *
 * @version $Id: OptionPane.java,v 1.3 2001/01/06 09:38:07 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

class OptionPane extends Dialog {
  /**
   * @serial The unique instance.
   */
private  static OptionPane option_pane = null;
  /**
   * @serial The temporary local flag.
   */
private boolean verbose = true;
  /**
   * @serial The temporary local flag.
   */
private boolean debug = false;
  /**
   * @serial A mode button.
   */
private JRadioButton quiet_button;
  /**
   * @serial A mode button.
   */
private JRadioButton verbose_button;
  /**
   * @serial A mode button.
   */
private JRadioButton debug_button;
  /**
   * @serial The displayer combo box.
   */
private JComboBox displayer_combo;
  /**
   * @serial The temporary local displayer.
   */
private int displayer;

//______________________________________________________________________________
/**
 * Gets an unique instance of the option_pane.
 * <Br>
 * It is a singleton.
 * @return the unique instance.
 */
protected static OptionPane instance()
  {
    if(option_pane == null) option_pane = new OptionPane();

    return option_pane;
  }
//______________________________________________________________________________
/**
 * Creates the OptionPane.
 */
private OptionPane()
  {
      super();
  }
//______________________________________________________________________________
/**
 * Builds the main component.
 * @return the tabbed pane.
 */
protected JComponent createComponent()
{
      JTabbedPane pane = new JTabbedPane();

      pane.setBackground(resources.getPaneBackground());
      pane.setForeground(resources.getPaneForeground());

      pane.add("Displayer", createDisplayOptionsPane());
      pane.add("Options",   createMiscOptionsPane());

      Color bg = resources.getPaneBackground().darker();
      pane.setBackgroundAt(0, bg);
      pane.setBackgroundAt(1, bg);

      setInitialSize("Options", 300, 200);

      return pane;
}
//______________________________________________________________________________
/**
 * Builds the pane showing the options.
 * <Br>
 * The verbosity mode can be selected.
 * @return the pane.
 */
private JComponent createMiscOptionsPane()
{
      JPanel pane     = new JPanel();
      Color  fg       = resources.getPaneForeground();
      Component space = Box.createHorizontalStrut(resources.getSpace());

      pane.setLayout(new BoxLayout(pane, BoxLayout.X_AXIS));
      pane.setOpaque(true);
      pane.setBackground(resources.getPaneBackground());
      pane.setForeground(fg);
      pane.setBorder(resources.getMarginBorder());

      JLabel header = new JLabel("Verbosity : ");
      header.setAlignmentX(Component.LEFT_ALIGNMENT);
      header.setFont(resources.getLabelFont());
      header.setHorizontalAlignment(JLabel.LEFT);
      header.setForeground(fg);
      header.setToolTipText("To select one of quiet, verbose, debug");
      pane.add(header);
      pane.add(space);

      ButtonGroup group  = new ButtonGroup();

      /**
       * Define what to change when a button is selected.
       * The mode is set to one of quiet, verbose or debug.
       * Actually, only local variables are changed. The
       * global ones are updated if the OK button is pressed.
       * Note that there is only one global OK.
       */
      class VerbosityListener implements ActionListener {
	  final public void actionPerformed(ActionEvent ev) {
	      int c = ev.getActionCommand().charAt(0);
	      switch(c) {
	      case 'Q' :	// Quiet
		 verbose = false; 
		 debug   = false; 
		 break;

	      case 'D' :	// Debug
		 verbose = true; 
		 debug   = true; 
		 break;

	      default :		// Verbose
		 verbose = true; 
		 debug   = false; 
		 break;
	      }
	  }
      }
      VerbosityListener listener = new VerbosityListener();

      quiet_button   = new JRadioButton("Quiet");
      if(! (ToolBox.verbose || ToolBox.debug)) quiet_button.setSelected(true);
      quiet_button.addActionListener(listener);
      quiet_button.setFont(resources.getTextFont());
      quiet_button.setOpaque(false);
      quiet_button.setForeground(fg);
      group.add(quiet_button);
      pane.add(quiet_button);

      verbose_button = new JRadioButton("Verbose");
      if(ToolBox.verbose && ! ToolBox.debug) verbose_button.setSelected(true);
      verbose_button.addActionListener(listener);
      verbose_button.setFont(resources.getTextFont());
      verbose_button.setOpaque(false);
      verbose_button.setForeground(fg);
      group.add(verbose_button);
      pane.add(verbose_button);

      debug_button   = new JRadioButton("Debug");
      if(ToolBox.debug) debug_button.setSelected(true);
      debug_button.addActionListener(listener);
      debug_button.setFont(resources.getTextFont());
      debug_button.setOpaque(false);
      debug_button.setForeground(fg);
      group.add(debug_button);
      pane.add(debug_button);

      return pane;
}
//______________________________________________________________________________
/**
 * Builds the pane showing navigation parameters.
 *
 * @return the pane.
 */
private JComponent createDisplayOptionsPane()
{
      JPanel pane        = new JPanel();
      GridBagLayout grid = new GridBagLayout();
      Color fg           = resources.getPaneForeground();
      pane.setLayout(grid);
      pane.setOpaque(true);
      pane.setBackground(resources.getPaneBackground());
      pane.setForeground(fg);

      GridBagConstraints cons = new GridBagConstraints();
      cons.weightx       = 0.0;
      cons.weighty       = 0.0;
      cons.anchor        = GridBagConstraints.CENTER;
      cons.insets.left   = resources.getSpace();
      cons.insets.right  = cons.insets.left;
      cons.insets.top    = 2 * cons.insets.left;
      cons.insets.bottom = cons.insets.left;

      JLabel item  =  new JLabel("Displayer : ");
      item.setFont(resources.getLabelFont());
      item.setToolTipText("Tool used to display HTML pages");
      item.setForeground(fg);
      cons.gridwidth  = 1;
      cons.anchor     = GridBagConstraints.WEST;
      cons.insets.top = cons.insets.left;
      grid.setConstraints(item, cons);
      pane.add(item);

      displayer_combo = new JComboBox(DisplayersBag.instance().getNamesList());
      displayer_combo.setForeground(fg);
      displayer_combo.setOpaque(false);
      cons.gridwidth = GridBagConstraints.REMAINDER;
      grid.setConstraints(displayer_combo, cons);
      pane.add(displayer_combo);

      /**
       * Defines what to do when a new displayer is selected in the combo box.
       */
      class DisplayerListener implements ActionListener {
	  final public void actionPerformed(ActionEvent ev) {
	      updateDisplayer(displayer_combo.getSelectedIndex());
	  }
      }
      displayer_combo.addActionListener(new DisplayerListener());

      return pane;
}
//______________________________________________________________________________
/**
 * Carries out the operation when a button item is pressed.
 * <Br>
 * It overrides the default method in the super Class.
 * It OK is pressed, verbosity, scanning and navigation are updated.
 *
 * @param ev the event generated.
 */
public void actionPerformed(ActionEvent ev)
{
    super.actionPerformed(ev);
    if(! confirmed) return;

    ToolBox.verbose = verbose;
    ToolBox.debug   = debug;

    BrowserPane.instance().setDisplayer(displayer);
}
//______________________________________________________________________________
/**
 * Displays the Pane and waits for a button pressed.
 * <Br>
 * @return true if the answer is OK, false otherwise.
 * @see #actionPerformed
 */
public boolean display()
{
    if(! (ToolBox.verbose || ToolBox.debug)) {
	verbose = false;
	debug   = false;
	quiet_button.setSelected(true);
    }
    else if(ToolBox.debug) {
	verbose = true;
	debug   = true;
	debug_button.setSelected(true);
    }
    else {
	verbose = true;
	debug   = false;
	verbose_button.setSelected(true);
    }

    DisplayersBag bag = DisplayersBag.instance();
    displayer_combo.setSelectedIndex(bag.getDisplayerIndex());

    setVisible(true);

    return confirmed;
}
//______________________________________________________________________________
/**
 * Changes the current displayer.
 * <Br>
 * @param displayer the selected displayer by the combo.
 */
final private void updateDisplayer(int displayer)
{
    this.displayer = displayer;
}
//______________________________________________________________________________
}



