//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.swing.border.Border;

import org.demo.webwader.gui.GuiResources;
import org.ariane.tools.ToolBox;

/**
 * Manages the main frame and the menu bar of the Browser.
 * <Br>
 * The main frame is divided in four parts :
 * <Ul>
 * <Li>the top pane which displays a couple of nice icons.
 * <Li>the nave pane presenting controls for the navigation.
 * <Li>the main pane showing a html page.
 * <Li>the bottom pane used to give some feeback to the user.
 * </Ul>
 * @version $Id: NavePane.java,v 1.1 2001/01/14 17:47:13 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see Browser
 */
//______________________________________________________________________________

class NavePane extends JPanel {
    /**
     * @serial The button home command.
     */
private	static final String BACK_HOME = "Back Home";
    /**
     * @serial The url field command.
     */
private	static final String SHOW_URL = "Show URL";
    /**
     * @serial The set of properties.
     */
private GuiResources resources;
  /**
   * @serial The url field.
   */
private JTextField url_field;
  /**
   * @serial The current browser pane.
   */
private BrowserPane  browser;
  /**
   * @serial The unique instance.
   */
private static NavePane nave_pane = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of the Navigation pane.
 * <Br>
 * It is a singleton.
 * @return the unique instance.
 */
protected static NavePane instance()
  {
    if(nave_pane == null) nave_pane = new NavePane();
    return nave_pane;
  }
//______________________________________________________________________________
/**
 * Creates the NavePane of the application.
 * <br>
 * It displays the field used to enter the URLs and a button to get home back.
 */
private NavePane()
  {
      super();

      resources  = GuiResources.instance();

      ToolBox.dot();
      setLayout(new FlowLayout(FlowLayout.LEFT));
      setBackground(resources.getPaneBackground());
      setOpaque(true);
      Border border = BorderFactory.createCompoundBorder(
      resources.getMatteBorder(), resources.getLineBorder());
      setBorder(border);

      JLabel label = new JLabel("URL : ");

      label.setForeground(resources.getPaneForeground());
      label.setFont(resources.getLabelFont());
      add(label);
      int h = label.getHeight();
      ToolBox.dot();

      /**
       * Reacts to an action in the url field or in the button.
       */
      class UrlListener implements ActionListener {
	  final public void actionPerformed(ActionEvent ev) {
	      String cmd = ev.getActionCommand();

	      if(cmd.equals(BACK_HOME)) {
		  displayHomePage();
	      }
	      else if(cmd.equals(SHOW_URL)) {
		  displayPage();
	      }
	  }
      }

      UrlListener listener = new UrlListener();

      int ncol   = resources.get(Browser.APPLI + ".URLField.Width", 80);
      url_field  =  new JTextField(ncol);
      url_field.setFont(resources.getTextFont());
      url_field.setBackground(resources.getBoardBackground());
      url_field.setForeground(resources.getBoardForeground());
      url_field.setBorder(resources.getInBorder());
      url_field.setEditable(true);
      url_field.setText(null);
      url_field.addActionListener(listener);
      url_field.setActionCommand(SHOW_URL);

      add(url_field);
      ToolBox.dot();

      add(Box.createHorizontalGlue());

      JButton button  = new JButton(resources.getIcon("home.gif"));
      Dimension bdim  = new Dimension(31, 31);
      button.setToolTipText("Back to home page");
      button.addActionListener(listener);
      button.setActionCommand(BACK_HOME);
      button.setPreferredSize(bdim);
      add(button);

      h += resources.getSpace();
      int width  = resources.get(Browser.APPLI + ".Width",  800);
      setMaximumSize(new Dimension(width, h));
  }
//______________________________________________________________________________
/**
 * Displays the home page.
 * <br>
 * The location is found in the properties. If it is not there the
 * W4 welcome page is shown.
 * @see #displayURL
 */
final protected void displayHomePage()
{
    String url = resources.get(Browser.APPLI + ".Home");
    if(url == null) url = resources.getWelcomeLocation();

    displayURL(url);
}
//______________________________________________________________________________
/**
 * Changes the current URL and displays it.
 * @param url the new URL.
 * @see #displayPage
 */
final protected void displayURL(String url)
{
    url_field.setText(url);
    displayPage();
}
//______________________________________________________________________________
/**
 * Displays the page located at the current URL found in the field.
 * @see BrowserPane#displayPage
 */
final private void displayPage()
{
    URL url = null;
    try {
	url = getURL();
	if(url == null) return;

	MainFrame.inform("Displaying : " + url);
	browser.displayPage(url);
    }
    catch(MalformedURLException ex) {
	ErrorWindow.instance().display("Invalid URL specification");
    }
    catch(Exception ex) {
	ErrorWindow.instance().display("Can't display " + ((url == null) ?
				       "null URL" : url.toString()));
    }
}
//______________________________________________________________________________
/**
 * Updates content of the URL field.
 * @param url the new URL.
 * @see #getURL
 */
final protected void setURLField(URL url)
{
    url_field.setText(url.toExternalForm());
}
//______________________________________________________________________________
/**
 * Updates content of the URL field.
 * @param url the new URL.
 * @see #getURL
 */
final protected void setURLField(String url)
{
    url_field.setText(url);
}
//______________________________________________________________________________
/**
 * Gets the current URL from the field.
 * <br>
 * If the field is empty or null returns null.
 * @return the current URL.
 * @throw MalformedURLException is the url is wrong.
 * @see #setURLField
 */
final protected URL getURL() throws MalformedURLException
{
    String loc = url_field.getText();
    if(loc == null) return null;
    loc = loc.trim();
    if(loc.length() < 1) return null;

    return new URL(loc);
}
//______________________________________________________________________________
/**
 * Sets the links between the panes.
 * @param browser the component.
 */
final protected void setBrowserPane(BrowserPane browser)
{
    this.browser = browser;
}
//______________________________________________________________________________
}

