//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import javax.swing.*;
import java.net.URL;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.Displayer;
import ice.storm.StormBase;
import ice.storm.ContentLoader;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

/**
 * A displayer based on the Ice component.
 * <br>
 * The IceSoft API documentation is available
 * <a href="http://www.icesoft.no/Doc/ICEBrowser/api/index.html">online</a>.
 *
 * @version $Id: IceDisplayer.java,v 1.7 2001/04/11 19:20:50 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see SwingDisplayer
 */
//______________________________________________________________________________

public class IceDisplayer extends JPanel implements Displayer {
  /**
   * @serial The unique instance.
   */
private  static IceDisplayer displayer = null;
    /**
     * @serial The name of this tool.
     */
public static final String NAME = DisplayersBag.ICE_DISPLAYER_NAME;
    /**
     * @serial The set of properties.
     */
private GuiResources resources;
    /**
     * @serial The ice storm base object.
     */
private StormBase base;

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <br>
 * It is a singleton
 * @return the unique instance.
 */
public static IceDisplayer instance()
  {
    if(displayer == null) displayer = new IceDisplayer();

    return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the IceDisplayer.
 * <br>
 * It creates the StormBase object.
 * A property change listener is added to update the URL text field.
 */
private IceDisplayer()
  {
      super();

      resources  = GuiResources.instance();
      setOpaque(true);
      setBackground(resources.getPaneBackground());
      setForeground(resources.getPaneForeground());
      setFont(resources.getTextFont());

      base = new StormBase();
      base.setComponentToolkitName("swing");
      base.setContainer(this, NAME);

      class ClickListener implements PropertyChangeListener {
	  public void propertyChange(PropertyChangeEvent ev) {

	      if(ev.getPropertyName().equals("location")) {
		  NavePane.instance().setURLField((String)ev.getNewValue());
	      }
	  }
      }

      base.addPropertyChangeListener(new ClickListener(), null);
  }
//______________________________________________________________________________
/**
 * Activates this displayer.
 * <br>
 * Simply displays the welcome page.
 */
final public void activate()
{
    try {
      displayPage(new URL(resources.getWelcomeLocation()));
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display welcome page", ex);
	return;
    }
}
//______________________________________________________________________________
/**
 * Displays the specified document.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 */
final public boolean displayPage(URL url)
{
    if(url == null) return false;

    try {
	NavePane.instance().setURLField(url);
	base.renderContent(new ContentLoader(url, null), NAME);
	return true;
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page " + url.toString(), ex);
	return false;
    }
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
}


