//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import javax.swing.*;
import java.net.URL;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.GuiResources;
import org.demo.webwader.gui.Displayer;
import horst.*;

/**
 * A displayer based on the HTMLWindow package written by H. Heister.
 * <Br>
 * The HTMLWindow API documentation is available
 * <a href =
 *"http://home.earthlink.net/~hheister/htmlwindow/docs/horst/HTMLWindow.html">
 * online</a>.
 * @version $Id: HorstDisplayer.java,v 1.6 2001/01/15 17:16:23 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see SwingDisplayer
 */
//______________________________________________________________________________

public class HorstDisplayer extends HTMLWindow implements Displayer {
  /**
   * @serial The unique instance.
   */
private  static HorstDisplayer displayer = null;
    /**
     * @serial The name of this tool.
     */
public static final String NAME = DisplayersBag.HORST_DISPLAYER_NAME;
    /**
     * @serial The set of properties.
     */
private GuiResources resources;
    /**
     * @serial The panel showing the pages.
     */
private HTMLPane pane;

//______________________________________________________________________________
/**
 * Gets an unique instance of the displayer.
 * <br>
 * It is a singleton. Note that <code>HTMLWindow</code> ctor has bugs.
 * @return the unique instance.
 */
public static HorstDisplayer instance()
  {
      try { 
	  if(displayer == null) displayer = new HorstDisplayer();
      }
      catch(Throwable t) {
	  /**
	   * There is something wrong in the HTMLWindow ctor.
	   * Retrying seems to work !
	   */
	  if(ToolBox.debug)
	  System.err.println("Error in Horst HTMLWindow : " + t.getMessage());
	  displayer = new HorstDisplayer();
      }

      return displayer;
  }
//______________________________________________________________________________
/**
 * Creates the HorstDisplayer.
 * <br>
 * It creates the window and keeps track of the html pane.
 * A link listener is added to update the URL text field.
 */
private HorstDisplayer()
  {
      super();

      resources  = GuiResources.instance();
      setOpaque(true);
      setBackground(resources.getPaneBackground());
      setForeground(resources.getPaneForeground());
      setFont(resources.getTextFont());

      pane = new HTMLPane();
      setHTMLPane(pane);

      class ClickListener implements LinkListener {
	  public void mouseOverLink(LinkEvent ev) {
	  }
	  public boolean mousePressedOverLink(LinkEvent ev) {
	      NavePane.instance().setURLField(ev.getLink());
	      return true;
	  }
      }

      pane.addLinkListener(new ClickListener());
  }
//______________________________________________________________________________
/**
 * Activates this displayer.
 * <br>
 * Simply displays the welcome page.
 */
final public void activate()
{
    try {
      displayPage(new URL(resources.getWelcomeLocation()));
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display welcome page", ex);
	return;
    }
}
//______________________________________________________________________________
/**
 * Displays the specified document.
 * @param url the url of the page.
 * @return true is the page has been displayed.
 */
final public boolean displayPage(URL url)
{
    if(url == null) return false;

    try {
	NavePane.instance().setURLField(url);
	pane.openPage(url);
	return true;
    }
    catch(Exception ex) {
	ToolBox.warn("Can't display page " + url.toString(), ex);
	return false;
    }
}
//______________________________________________________________________________
/**
 * Returns the name of this tool.
 * @return the string.
 */
final public String getName()
{
    return NAME;
}
//______________________________________________________________________________
}


