//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import javax.swing.*;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.io.IOException;
import org.ariane.tools.ToolBox;
import org.ariane.tools.Resources;

/**
 * A customized Dialog used to display information about the program.
 * <Br>
 * The documentation is provided by a html page.
 *
 * @version $Id: HelpWindow.java,v 1.3 2001/01/07 13:13:30 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

class HelpWindow extends Dialog {
  /**
   * @serial The unique instance.
   */
private  static HelpWindow window = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of the window.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
protected static HelpWindow instance()
  {
    if(window == null) window = new HelpWindow();

    return window;
  }
//______________________________________________________________________________
/**
 * Creates the HelpWindow.
 */
private HelpWindow()
  {
      super("Documentation  ", "help.gif");
      ok_button.setVisible(false);
      cancel_button.setToolTipText("To close the window");
  }
//______________________________________________________________________________
/**
 * Builds the main component.
 * @return the component.
 */
protected JComponent createComponent()
{
    JEditorPane text    = new JEditorPane();

    text.setEditable(false);
    text.setOpaque(true);
    text.setBackground(resources.getPaneBackground());
    text.setForeground(resources.getPaneForeground());
    text.setFont(resources.getTextFont());
    text.setBorder(makeMarginBorder());

    setInitialSize("Help", 600, 700);

    JScrollPane scroll = new JScrollPane(text);
    Dimension dim      = getInitialSize();

    int w = dim.width;
    int h = dim.height - 200;
    if(h < 100) h = 100;
    dim.setSize(w, h);
    scroll.setPreferredSize(dim);
    scroll.setBorder(resources.getMatteBorder());

    URL url = null;
    try {
	url = getPage();
	text.setPage(url);
    }
    catch(Exception ex) {
	text.setText(writeText());
	ToolBox.warn("Can't get page " + String.valueOf(url), ex);
    }

    return scroll;
}
//______________________________________________________________________________
/**
 * Creates the text to be displayed.
 * @return the string.
 */
final private String writeText()
{
    StringBuffer buf = new StringBuffer("The documentation can be found at :");

    String url = resources.get("WebWader.DocURL",
	         "http://jeanpaul.lefevre.free.fr/java/webwader/index.html");

    buf.append("\n").append(url).append("\n\n");
    buf.append("Use your favorite browser !");

    return buf.toString();
}
//______________________________________________________________________________
/**
 * Gets the documentation page.
 * <Br>
 * It is in file:/path/to/jvs/lib/webwader-help.html
 *
 * @return the page.
 * @throw java.net.MalformedURLException is the url is wrong.
 */
final private URL getPage() throws java.net.MalformedURLException
{
    StringBuffer buf = new StringBuffer("file:");
    buf.append(Resources.instance().getLibDirectory());
    buf.append("browser-help.html");

    String path = path = buf.toString();

    return new URL(path);
}
//______________________________________________________________________________
}


