//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader.rbi;

import javax.swing.*;
import org.ariane.tools.ToolBox;
import org.demo.webwader.gui.GuiResources;

/**
 * A customized Dialog : used to display an error message.
 * <br>
 * It is a singleton.
 * @version $Id: ErrorWindow.java,v 1.1 2001/01/07 13:12:43 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

class ErrorWindow extends org.ariane.gui.ErrorWindow {
  /**
   * @serial The unique instance.
   */
private  static ErrorWindow window = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of the window.
 * <Br>
 * It is a singleton.
 * @return the unique instance.
 */
protected static ErrorWindow instance()
  {
    if(window == null) window = new ErrorWindow();

    return window;
  }
//______________________________________________________________________________
/**
 * Creates the ErrorWindow.
 * The button ok is unvisible.
 */
private ErrorWindow()
  {
      super(MainFrame.instance());
  }
//______________________________________________________________________________
/**
 * Installs the resources used to build the Dialog.
 */
protected void setResources()
    {
	resources = GuiResources.instance();
    }
//______________________________________________________________________________
}

